/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.io.input.BOMInputStream;
import com.microsoft.azure.toolkit.lib.appservice.function.core.AzureFunctionPackagerBase;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionMethod;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.Binding;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class AzureFunctionPackager
extends AzureFunctionPackagerBase {
    private static final String TRIGGER_TYPE = "triggerType";
    protected static final String LINE_FEED = "\r\n";
    protected static final String FUNCTION_JSON = "function.json";
    protected static final String HOST_JSON = "host.json";
    protected static final String LOCAL_SETTINGS_JSON = "local.settings.json";
    protected static final String EXTENSION_BUNDLE = "extensionBundle";
    protected static final String SEARCH_FUNCTIONS = "Step 1 of 8: Searching for Azure Functions entry points";
    protected static final String FOUND_FUNCTIONS = " Azure Functions entry point(s) found.";
    protected static final String NO_FUNCTIONS = "Azure Functions entry point not found, plugin will exit.";
    protected static final String GENERATE_CONFIG = "Step 2 of 8: Generating Azure Functions configurations";
    protected static final String GENERATE_SKIP = "No Azure Functions found. Skip configuration generation.";
    protected static final String GENERATE_DONE = "Generation done.";
    protected static final String VALIDATE_CONFIG = "Step 3 of 8: Validating generated configurations";
    protected static final String VALIDATE_SKIP = "No configurations found. Skip validation.";
    protected static final String VALIDATE_DONE = "Validation done.";
    protected static final String SAVING_HOST_JSON = "Step 4 of 8: Copying/creating host.json";
    protected static final String SAVING_LOCAL_SETTINGS_JSON = "Step 5 of 8: Copying/creating local.settings.json";
    protected static final String SAVE_FUNCTION_JSONS = "Step 6 of 8: Saving configurations to function.json";
    protected static final String SAVE_SKIP = "No configurations found. Skip save.";
    protected static final String SAVE_FUNCTION_JSON = "Starting processing function: ";
    protected static final String SAVE_SUCCESS = "Successfully saved to ";
    protected static final String COPY_JARS = "Step 7 of 8: Copying JARs to staging directory";
    protected static final String COPY_SUCCESS = "Copied successfully.";
    protected static final String INSTALL_EXTENSIONS = "Step 8 of 8: Installing function extensions if needed";
    protected static final String SKIP_INSTALL_EXTENSIONS_HTTP = "Skip install Function extension for HTTP Trigger Functions";
    protected static final String INSTALL_EXTENSIONS_FINISH = "Function extension installation done.";
    protected static final String BUILD_SUCCESS = "Successfully built Azure Functions.";
    private static final String DEFAULT_LOCAL_SETTINGS_JSON = "{ \"IsEncrypted\": false, \"Values\": { \"FUNCTIONS_WORKER_RUNTIME\": \"java\" } }";
    private static final String DEFAULT_HOST_JSON = "{\"version\":\"2.0\",\"extensionBundle\":{\"id\":\"Microsoft.Azure.Functions.ExtensionBundle\",\"version\":\"[1.*, 2.0.0)\"}}\n";
    private static final String SKIP_INSTALL_EXTENSIONS_FLAG = "skipInstallExtensions flag is set, skip install extension";
    private static final String SKIP_INSTALL_EXTENSIONS_BUNDLE = "Extension bundle specified, skip install extension";
    private static final String EXTENSION_BUNDLE_ID = "Microsoft.Azure.Functions.ExtensionBundle";
    private static final String EXTENSION_BUNDLE_PREVIEW_ID = "Microsoft.Azure.Functions.ExtensionBundle.Preview";
    private static final BindingEnum[] FUNCTION_WITHOUT_FUNCTION_EXTENSION;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public static AzureFunctionPackager getInstance() {
        return AzureFunctionPackagerHolder.instance;
    }

    @AzureOperation(name="function.prepare_staging_folder", type=AzureOperation.Type.TASK)
    public void packageProject(FunctionProject project, boolean installExtension, String funcPath) {
        FunctionProject functionProject = project;
        boolean bl = installExtension;
        String string = funcPath;
        Object[] objectArray = new Object[]{functionProject, Conversions.booleanObject((boolean)bl), string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<FunctionMethod> methods = this.findAnnotatedMethodsInner(project);
            if (methods.isEmpty()) {
                AzureMessager.getMessager().info(NO_FUNCTIONS);
            } else {
                Map<String, FunctionConfiguration> configMap = this.generateConfigurations(project, methods);
                this.trackFunctionProperties(configMap);
                this.validateFunctionConfigurations(configMap);
                ObjectWriter objectWriter = this.getObjectWriter();
                try {
                    this.copyHostJson(project);
                    this.copyLocalSettingsJson(project);
                    this.writeFunctionJsonFiles(project, objectWriter, configMap);
                    this.copyJarsToStageDirectory(project);
                    Set<BindingEnum> bindingEnums = this.getFunctionBindingEnums(configMap);
                    if (this.isInstallingExtensionNeeded(!installExtension, project, bindingEnums)) {
                        this.installExtensionStep(project, funcPath);
                    }
                    AzureMessager.getMessager().info(BUILD_SUCCESS);
                }
                catch (IOException e) {
                    throw new AzureToolkitRuntimeException("Cannot perform IO operations due to error:" + e.getMessage(), (Throwable)e);
                }
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="function.list_function_methods", params={"project.getName()"}, type=AzureOperation.Type.TASK)
    private List<FunctionMethod> findAnnotatedMethodsInner(FunctionProject project) {
        FunctionProject functionProject = project;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)functionProject);
        try {
            List<FunctionMethod> list;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureMessager.getMessager().info("\r\nStep 1 of 8: Searching for Azure Functions entry points");
            try {
                List<FunctionMethod> functions = project.findAnnotatedMethods();
                AzureMessager.getMessager().info(functions.size() + FOUND_FUNCTIONS);
                list = functions;
            }
            catch (Exception ex) {
                AzureMessager.getMessager().error((Throwable)ex, "Encounter error when parsing Azure Function annotations.", new Object[0]);
                list = Collections.emptyList();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private Map<String, FunctionConfiguration> generateConfigurations(FunctionProject project, List<FunctionMethod> methods) {
        AzureMessager.getMessager().info("\r\nStep 2 of 8: Generating Azure Functions configurations");
        Map<String, FunctionConfiguration> configMap = this.generateConfigurationsInner(project, methods);
        if (configMap.size() == 0) {
            AzureMessager.getMessager().info(GENERATE_SKIP);
        }
        AzureMessager.getMessager().info(GENERATE_DONE);
        return configMap;
    }

    private void installExtensionStep(FunctionProject project, String funcPath) {
        AzureMessager.getMessager().info(INSTALL_EXTENSIONS);
        project.installExtension(funcPath);
        AzureMessager.getMessager().info(INSTALL_EXTENSIONS_FINISH);
    }

    private void validateFunctionConfigurations(Map<String, FunctionConfiguration> configMap) {
        AzureMessager.getMessager().info("\r\nStep 3 of 8: Validating generated configurations");
        if (configMap.isEmpty()) {
            AzureMessager.getMessager().info(VALIDATE_SKIP);
        } else {
            configMap.values().forEach(FunctionConfiguration::validate);
            AzureMessager.getMessager().info(VALIDATE_DONE);
        }
    }

    private void writeFunctionJsonFiles(FunctionProject project, ObjectWriter objectWriter, Map<String, FunctionConfiguration> configMap) throws IOException {
        AzureMessager.getMessager().info("\r\nStep 6 of 8: Saving configurations to function.json");
        if (configMap.size() == 0) {
            AzureMessager.getMessager().info(SAVE_SKIP);
        } else {
            for (Map.Entry<String, FunctionConfiguration> config : configMap.entrySet()) {
                this.writeFunctionJsonFile(project, objectWriter, config.getKey(), config.getValue());
            }
        }
    }

    private void writeFunctionJsonFile(FunctionProject project, ObjectWriter objectWriter, String functionName, FunctionConfiguration config) throws IOException {
        AzureMessager.getMessager().info(SAVE_FUNCTION_JSON + functionName);
        File functionJsonFile = Paths.get(project.getStagingFolder().getAbsolutePath(), functionName, FUNCTION_JSON).toFile();
        this.writeObjectToFile(objectWriter, config, functionJsonFile);
        AzureMessager.getMessager().info(SAVE_SUCCESS + functionJsonFile.getAbsolutePath());
    }

    private void copyHostJson(FunctionProject project) throws IOException {
        AzureMessager.getMessager().info("\r\nStep 4 of 8: Copying/creating host.json");
        File sourceHostJsonFile = (File)ObjectUtils.firstNonNull((Object[])new File[]{project.getHostJsonFile(), new File(project.getBaseDirectory(), HOST_JSON)});
        File destHostJsonFile = Paths.get(project.getStagingFolder().getAbsolutePath(), HOST_JSON).toFile();
        AzureFunctionPackager.copyFilesWithDefaultContent(sourceHostJsonFile, destHostJsonFile, DEFAULT_HOST_JSON);
        AzureMessager.getMessager().info(SAVE_SUCCESS + destHostJsonFile.getAbsolutePath());
    }

    private void copyLocalSettingsJson(FunctionProject project) throws IOException {
        AzureMessager.getMessager().info("\r\nStep 5 of 8: Copying/creating local.settings.json");
        File sourceLocalSettingsJsonFile = (File)ObjectUtils.firstNonNull((Object[])new File[]{project.getLocalSettingsJsonFile(), new File(project.getBaseDirectory(), LOCAL_SETTINGS_JSON)});
        File destLocalSettingsJsonFile = Paths.get(project.getStagingFolder().getAbsolutePath(), LOCAL_SETTINGS_JSON).toFile();
        AzureFunctionPackager.copyFilesWithDefaultContent(sourceLocalSettingsJsonFile, destLocalSettingsJsonFile, DEFAULT_LOCAL_SETTINGS_JSON);
        AzureMessager.getMessager().info(SAVE_SUCCESS + destLocalSettingsJsonFile.getAbsolutePath());
    }

    private static void copyFilesWithDefaultContent(File source, File dest, String defaultContent) throws IOException {
        if (source != null && source.exists()) {
            FileUtils.copyFile((File)source, (File)dest);
        } else {
            FileUtils.write((File)dest, (CharSequence)defaultContent, (Charset)Charset.defaultCharset());
        }
    }

    private void writeObjectToFile(ObjectWriter objectWriter, Object object, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        objectWriter.writeValue(targetFile, object);
    }

    private ObjectWriter getObjectWriter() {
        DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n");
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).writer((PrettyPrinter)prettyPrinter);
    }

    private void copyJarsToStageDirectory(FunctionProject project) throws IOException {
        String stagingDirectory = project.getStagingFolder().getAbsolutePath();
        AzureMessager.getMessager().info("\r\nStep 7 of 8: Copying JARs to staging directory" + stagingDirectory);
        File libFolder = Paths.get(stagingDirectory, "lib").toFile();
        if (libFolder.exists()) {
            FileUtils.cleanDirectory((File)libFolder);
        }
        for (File file : project.getDependencies()) {
            FileUtils.copyFileToDirectory((File)file, (File)libFolder);
        }
        FileUtils.copyFileToDirectory((File)project.getArtifactFile(), (File)new File(stagingDirectory));
        AzureMessager.getMessager().info(COPY_SUCCESS);
    }

    private void trackFunctionProperties(Map<String, FunctionConfiguration> configMap) {
        AzureTelemetry.getActionContext().setProperty(TRIGGER_TYPE, StringUtils.join(this.getFunctionBindingList(configMap), (String)","));
    }

    private List<String> getFunctionBindingList(Map<String, FunctionConfiguration> configMap) {
        return configMap.values().stream().flatMap(configuration -> configuration.getBindings().stream()).map(Binding::getType).sorted().distinct().collect(Collectors.toList());
    }

    private Set<BindingEnum> getFunctionBindingEnums(Map<String, FunctionConfiguration> configMap) {
        HashSet<BindingEnum> result = new HashSet<BindingEnum>();
        configMap.values().forEach(configuration -> configuration.getBindings().forEach(binding -> result.add(binding.getBindingEnum())));
        return result;
    }

    private boolean isInstallingExtensionNeeded(boolean skipInstallExtensions, FunctionProject project, Set<BindingEnum> bindingTypes) {
        if (skipInstallExtensions) {
            AzureMessager.getMessager().info(SKIP_INSTALL_EXTENSIONS_FLAG);
            return false;
        }
        JsonObject hostJson = this.readHostJson(project);
        String extensionBundleId = Optional.ofNullable(hostJson).map(host -> host.getAsJsonObject(EXTENSION_BUNDLE)).map(extensionBundle -> extensionBundle.get("id")).map(JsonElement::getAsString).orElse(null);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)extensionBundleId, (CharSequence[])new CharSequence[]{EXTENSION_BUNDLE_ID, EXTENSION_BUNDLE_PREVIEW_ID})) {
            AzureMessager.getMessager().info(SKIP_INSTALL_EXTENSIONS_BUNDLE);
            return false;
        }
        boolean isNonHttpTriggersExist = bindingTypes.stream().anyMatch(binding -> !Arrays.asList(FUNCTION_WITHOUT_FUNCTION_EXTENSION).contains(binding));
        if (!isNonHttpTriggersExist) {
            AzureMessager.getMessager().info(SKIP_INSTALL_EXTENSIONS_HTTP);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonObject readHostJson(FunctionProject project) {
        File hostJson = (File)ObjectUtils.firstNonNull((Object[])new File[]{project.getHostJsonFile(), new File(project.getHostJsonFile(), HOST_JSON)});
        try (FileInputStream fis = new FileInputStream(hostJson);){
            Scanner scanner = new Scanner((InputStream)new BOMInputStream((InputStream)fis));
            try {
                String jsonRaw = scanner.useDelimiter("\\Z").next();
                JsonObject jsonObject = JsonParser.parseString((String)jsonRaw).getAsJsonObject();
                scanner.close();
                return jsonObject;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        AzureFunctionPackager.ajc$preClinit();
        FUNCTION_WITHOUT_FUNCTION_EXTENSION = new BindingEnum[]{BindingEnum.HttpOutput, BindingEnum.HttpTrigger};
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureFunctionPackager.java", AzureFunctionPackager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "packageProject", "com.microsoft.azure.toolkit.lib.appservice.function.core.AzureFunctionPackager", "com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionProject:boolean:java.lang.String", "project:installExtension:funcPath", "", "void"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findAnnotatedMethodsInner", "com.microsoft.azure.toolkit.lib.appservice.function.core.AzureFunctionPackager", "com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionProject", "project", "", "java.util.List"), 127);
    }

    private static class AzureFunctionPackagerHolder {
        static final AzureFunctionPackager instance = new AzureFunctionPackager();

        private AzureFunctionPackagerHolder() {
        }
    }
}

