/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebDeploymentSlotBasic;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceCreator;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAzureManager;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp$AjcClosure3;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import io.jsonwebtoken.lang.Collections;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApp
extends AbstractAppService<com.azure.resourcemanager.appservice.models.WebApp, WebAppEntity>
implements IWebAppBase<WebAppEntity> {
    private static final Logger log;
    private static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    private final AppServiceManager azureClient;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public WebApp(@Nonnull String id, @Nonnull AppServiceManager azureClient) {
        super(id);
        this.azureClient = azureClient;
    }

    public WebApp(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name, @Nonnull AppServiceManager azureClient) {
        super(subscriptionId, resourceGroup, name);
        this.azureClient = azureClient;
    }

    public WebApp(@Nonnull WebSiteBase webAppBasic, @Nonnull AppServiceManager azureClient) {
        super(webAppBasic);
        this.azureClient = azureClient;
    }

    public AppServicePlan plan() {
        return (AppServicePlan)((AzureAppServicePlan)Azure.az(AzureAppServicePlan.class)).get(((com.azure.resourcemanager.appservice.models.WebApp)this.remote()).appServicePlanId());
    }

    public WebAppCreator create() {
        return new WebAppCreator();
    }

    @Override
    @NotNull
    protected WebAppEntity getEntityFromRemoteResource(@NotNull com.azure.resourcemanager.appservice.models.WebApp remote) {
        return AppServiceUtils.fromWebApp((WebAppBase)remote);
    }

    @Override
    protected com.azure.resourcemanager.appservice.models.WebApp loadRemote() {
        return (com.azure.resourcemanager.appservice.models.WebApp)this.azureClient.webApps().getByResourceGroup(this.resourceGroup, this.name);
    }

    @Override
    @AzureOperation(name="webapp.delete", params={"this.entity.getName()"}, type=AzureOperation.Type.SERVICE)
    public void delete() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.exists()) {
                this.status("PENDING");
                this.azureClient.functionApps().deleteById(this.id());
                ((AzureWebApp)Azure.az(AzureWebApp.class)).refresh();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="webapp.start", params={"this.entity.getName()"}, type=AzureOperation.Type.SERVICE)
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.start();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="webapp.stop", params={"this.entity.getName()"}, type=AzureOperation.Type.SERVICE)
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.stop();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="webapp.restart", params={"this.entity.getName()"}, type=AzureOperation.Type.SERVICE)
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.restart();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    public void deploy(@Nonnull com.microsoft.azure.toolkit.lib.appservice.model.DeployType deployType, @Nonnull File targetFile, @Nullable String targetPath) {
        DeployOptions options = new DeployOptions().withPath(targetPath);
        AzureMessager.getMessager().info(AzureString.format((String)"Deploying (%s)[%s] %s ...", (Object[])new Object[]{targetFile.toString(), deployType.toString(), StringUtils.isBlank((CharSequence)targetPath) ? "" : " to " + targetPath}));
        ((com.azure.resourcemanager.appservice.models.WebApp)this.remote()).deploy(DeployType.fromString((String)deployType.getValue()), targetFile, options);
    }

    public WebAppUpdater update() {
        return new WebAppUpdater();
    }

    @Override
    public AbstractAppService<com.azure.resourcemanager.appservice.models.WebApp, WebAppEntity> refresh() {
        try {
            AbstractAzureManager abstractAzureManager = super.refresh();
            return abstractAzureManager;
        }
        finally {
            try {
                CacheManager.evictCache((String)"appservice/webapp/{}/slots", (String)this.name());
            }
            catch (Throwable e) {
                log.warn("failed to evict cache", e);
            }
        }
    }

    @Cacheable(cacheName="appservice/webapp/{}/slot/{}", key="${this.name()}/$slotName")
    public WebAppDeploymentSlot deploymentSlot(String slotName) {
        String string = slotName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebApp$AjcClosure1 webApp$AjcClosure1 = new WebApp$AjcClosure1(objectArray);
        return (WebAppDeploymentSlot)CacheManager.aspectOf().aroundCacheable(webApp$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/webapp/{}/slots", key="${this.name()}", condition="!(force&&force[0])")
    public List<WebAppDeploymentSlot> deploymentSlots(boolean ... force) {
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)blArray);
        Object[] objectArray = new Object[]{this, blArray, joinPoint};
        WebApp$AjcClosure3 webApp$AjcClosure3 = new WebApp$AjcClosure3(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(webApp$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public void swap(String slotName) {
        ((com.azure.resourcemanager.appservice.models.WebApp)this.remote()).swap(slotName);
    }

    static {
        WebApp.ajc$preClinit();
        log = LoggerFactory.getLogger(WebApp.class);
    }

    static final /* synthetic */ WebAppDeploymentSlot deploymentSlot_aroundBody0(WebApp ajc$this, String slotName, JoinPoint joinPoint) {
        return new WebAppDeploymentSlot(ajc$this, (com.azure.resourcemanager.appservice.models.WebApp)ajc$this.remote(), slotName);
    }

    static final /* synthetic */ List deploymentSlots_aroundBody2(WebApp ajc$this, boolean[] force, JoinPoint joinPoint) {
        return ((com.azure.resourcemanager.appservice.models.WebApp)ajc$this.remote()).deploymentSlots().list().stream().map(slot -> new WebAppDeploymentSlot(this, (com.azure.resourcemanager.appservice.models.WebApp)this.remote(), (WebDeploymentSlotBasic)slot)).collect(Collectors.toList());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebApp.java", WebApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "", "", "", "void"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "", "", "", "void"), 98);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "", "", "", "void"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "", "", "", "void"), 110);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploymentSlot", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "java.lang.String", "slotName", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebAppDeploymentSlot"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "deploymentSlots", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "[Z", "force", "", "java.util.List"), 146);
    }

    public class WebAppUpdater
    extends AbstractAppServiceUpdater<WebApp> {
        public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system for existing app service";
        private boolean modified = false;

        public WebApp commit() {
            WebApp.Update update = (WebApp.Update)((com.azure.resourcemanager.appservice.models.WebApp)WebApp.this.remote()).update();
            if (this.getAppServicePlan() != null && this.getAppServicePlan().isPresent()) {
                update = this.updateAppServicePlan(update, this.getAppServicePlan().get());
            }
            if (this.getRuntime() != null && this.getRuntime().isPresent()) {
                update = this.updateRuntime(update, this.getRuntime().get());
            }
            if (this.getDockerConfiguration() != null && this.getDockerConfiguration().isPresent() && WebApp.this.getRuntime().isDocker()) {
                this.modified = true;
                update = this.updateDockerConfiguration(update, this.getDockerConfiguration().get());
            }
            if (!Collections.isEmpty(this.getAppSettingsToAdd())) {
                this.modified = true;
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (!Collections.isEmpty(this.getAppSettingsToRemove())) {
                this.modified = true;
                this.getAppSettingsToRemove().forEach(arg_0 -> ((WebApp.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                this.modified = true;
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, this.getDiagnosticConfig().get());
            }
            if (this.modified) {
                WebApp.this.remote = (HasId)update.apply();
            }
            WebApp.this.entity = AppServiceUtils.fromWebApp((WebAppBase)WebApp.this.remote);
            ((AzureWebApp)Azure.az(AzureWebApp.class)).refresh();
            WebApp.this.refreshStatus();
            return WebApp.this;
        }

        private WebApp.Update updateAppServicePlan(WebApp.Update update, AppServicePlanEntity newServicePlan) {
            String servicePlanId = ((com.azure.resourcemanager.appservice.models.WebApp)WebApp.this.remote()).appServicePlanId();
            AppServicePlanEntity currentServicePlan = ((AppServicePlan)((AzureAppServicePlan)Azure.az(AzureAppServicePlan.class)).get(servicePlanId)).entity();
            if (StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getId(), (CharSequence)newServicePlan.getId()) || StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getName(), (CharSequence)newServicePlan.getName()) && StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getResourceGroup(), (CharSequence)newServicePlan.getResourceGroup())) {
                return update;
            }
            com.azure.resourcemanager.appservice.models.AppServicePlan newPlanServiceModel = AppServiceUtils.getAppServicePlan(newServicePlan, WebApp.this.azureClient);
            if (newPlanServiceModel == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            this.modified = true;
            return update.withExistingAppServicePlan(newPlanServiceModel);
        }

        private WebApp.Update updateDockerConfiguration(WebApp.Update update, DockerConfiguration dockerConfiguration) {
            WebApp.UpdateStages.WithStartUpCommand draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()}) ? update.withPublicDockerHubImage(dockerConfiguration.getImage()) : (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl()) ? update.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()) : update.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()));
            this.modified = true;
            return draft.withStartUpCommand(dockerConfiguration.getStartUpCommand());
        }

        private WebApp.Update updateRuntime(WebApp.Update update, Runtime newRuntime) {
            Runtime current = WebApp.this.getRuntime();
            if (newRuntime.getOperatingSystem() != null && current.getOperatingSystem() != newRuntime.getOperatingSystem()) {
                throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
            }
            if (Objects.equals(current, newRuntime) || current.isDocker()) {
                return update;
            }
            this.modified = true;
            OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), current.getOperatingSystem()}));
            switch (operatingSystem) {
                case LINUX: {
                    return update.withBuiltInImage(AppServiceUtils.toRuntimeStack(newRuntime));
                }
                case WINDOWS: {
                    return (WebApp.Update)update.withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(AppServiceUtils.toWebContainer(newRuntime));
                }
            }
            throw new AzureToolkitRuntimeException(String.format(WebApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    public class WebAppCreator
    extends AbstractAppServiceCreator<WebApp> {
        @Override
        public WebApp commit() {
            WebApp.DefinitionStages.WithCreate withCreate;
            WebApp.DefinitionStages.Blank blank = (WebApp.DefinitionStages.Blank)WebApp.this.azureClient.webApps().define(this.getName());
            Runtime runtime = this.getRuntime();
            com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlan(this.getAppServicePlanEntity(), WebApp.this.azureClient);
            if (appServicePlan == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            switch (runtime.getOperatingSystem()) {
                case LINUX: {
                    withCreate = this.createLinuxWebApp(blank, appServicePlan, runtime);
                    break;
                }
                case WINDOWS: {
                    withCreate = this.createWindowsWebApp(blank, appServicePlan, runtime);
                    break;
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    withCreate = this.createDockerWebApp(blank, appServicePlan, dockerConfiguration);
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException(String.format(WebApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{runtime.getOperatingSystem()}));
                }
            }
            if (this.getAppSettings() != null && this.getAppSettings().isPresent()) {
                withCreate.withAppSettings(this.getAppSettings().get());
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, this.getDiagnosticConfig().get());
            }
            WebApp.this.remote = (HasId)withCreate.create();
            WebApp.this.entity = AppServiceUtils.fromWebApp((WebAppBase)WebApp.this.remote);
            WebApp.this.refreshStatus();
            ((AzureWebApp)Azure.az(AzureWebApp.class)).refresh();
            return WebApp.this;
        }

        WebApp.DefinitionStages.WithCreate createWindowsWebApp(WebApp.DefinitionStages.Blank blank, com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan, Runtime runtime) {
            return (WebApp.DefinitionStages.WithCreate)blank.withExistingWindowsPlan(appServicePlan).withExistingResourceGroup(WebApp.this.resourceGroup).withJavaVersion(AppServiceUtils.toJavaVersion(runtime.getJavaVersion())).withWebContainer(AppServiceUtils.toWebContainer(runtime));
        }

        WebApp.DefinitionStages.WithCreate createLinuxWebApp(WebApp.DefinitionStages.Blank blank, com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan, Runtime runtime) {
            return blank.withExistingLinuxPlan(appServicePlan).withExistingResourceGroup(WebApp.this.resourceGroup).withBuiltInImage(AppServiceUtils.toRuntimeStack(runtime));
        }

        WebApp.DefinitionStages.WithCreate createDockerWebApp(WebApp.DefinitionStages.Blank blank, com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan, DockerConfiguration dockerConfiguration) {
            WebApp.DefinitionStages.WithLinuxAppFramework withLinuxAppFramework = blank.withExistingLinuxPlan(appServicePlan).withExistingResourceGroup(WebApp.this.resourceGroup);
            WebApp.DefinitionStages.WithStartUpCommand draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(dockerConfiguration.getImage()) : (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()));
            return draft.withStartUpCommand(dockerConfiguration.getStartUpCommand());
        }
    }
}

