/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.WebDeploymentSlotBasic;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WebAppDeploymentSlot
extends AbstractAppService<DeploymentSlot, WebAppDeploymentSlotEntity>
implements IWebAppBase<WebAppDeploymentSlotEntity> {
    private static final String WEB_APP_DEPLOYMENT_SLOT_ID_TEMPLATE = "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/sites/%s/slots/%s";
    @Nonnull
    private final WebApp parent;
    @Nonnull
    private final com.azure.resourcemanager.appservice.models.WebApp webAppClient;

    public WebAppDeploymentSlot(@Nonnull String id, @Nonnull AppServiceManager azureClient) {
        super(id);
        this.webAppClient = (com.azure.resourcemanager.appservice.models.WebApp)azureClient.webApps().getById(ResourceId.fromString((String)id).parent().id());
        this.parent = ((AzureAppService)Azure.az(AzureAppService.class)).webapp(this.subscriptionId, this.resourceGroup, this.webAppClient.name());
    }

    public WebAppDeploymentSlot(@Nonnull WebApp parent, @Nonnull com.azure.resourcemanager.appservice.models.WebApp webAppClient, @Nonnull String slotName) {
        super(Utils.getSubscriptionId(webAppClient.id()), webAppClient.resourceGroupName(), slotName);
        this.webAppClient = webAppClient;
        this.parent = parent;
    }

    public WebAppDeploymentSlot(@Nonnull WebApp parent, @Nonnull com.azure.resourcemanager.appservice.models.WebApp webAppClient, @Nonnull WebDeploymentSlotBasic slotBasic) {
        super((WebSiteBase)slotBasic);
        this.webAppClient = webAppClient;
        this.parent = parent;
    }

    public WebApp webApp() {
        return this.parent;
    }

    public WebAppDeploymentSlotCreator create() {
        return new WebAppDeploymentSlotCreator();
    }

    public WebAppDeploymentSlotUpdater update() {
        return new WebAppDeploymentSlotUpdater();
    }

    @Override
    @NotNull
    protected WebAppDeploymentSlotEntity getEntityFromRemoteResource(@NotNull DeploymentSlot remote) {
        return AppServiceUtils.fromWebAppDeploymentSlot(remote);
    }

    @Override
    protected DeploymentSlot loadRemote() {
        return (DeploymentSlot)this.webAppClient.deploymentSlots().getByName(this.name);
    }

    @Override
    public void delete() {
        ((com.azure.resourcemanager.appservice.models.WebApp)((DeploymentSlot)this.remote()).parent()).deploymentSlots().deleteById(this.id());
        this.webApp().refresh();
    }

    @Override
    public void deploy(com.microsoft.azure.toolkit.lib.appservice.model.DeployType deployType, File targetFile, String targetPath) {
        DeployOptions options = new DeployOptions().withPath(targetPath);
        ((DeploymentSlot)this.remote()).deploy(DeployType.fromString((String)deployType.getValue()), targetFile, options);
    }

    @Override
    public String id() {
        return String.format(WEB_APP_DEPLOYMENT_SLOT_ID_TEMPLATE, this.subscriptionId, this.resourceGroup, this.webAppClient.name(), this.name);
    }

    public class WebAppDeploymentSlotUpdater {
        private final List<String> appSettingsToRemove = new ArrayList<String>();
        private final Map<String, String> appSettingsToAdd = new HashMap<String, String>();
        private DiagnosticConfig diagnosticConfig = null;

        public WebAppDeploymentSlotUpdater withoutAppSettings(String key) {
            this.appSettingsToRemove.add(key);
            return this;
        }

        public WebAppDeploymentSlotUpdater withAppSettings(Map<String, String> appSettings) {
            this.appSettingsToAdd.putAll(appSettings);
            return this;
        }

        public WebAppDeploymentSlotUpdater withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        public WebAppDeploymentSlot commit() {
            DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)((DeploymentSlot)WebAppDeploymentSlot.this.remote()).update();
            if (this.getAppSettingsToAdd() != null) {
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (this.getAppSettingsToRemove() != null) {
                this.getAppSettingsToRemove().forEach(arg_0 -> ((DeploymentSlotBase.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, this.getDiagnosticConfig());
            }
            WebAppDeploymentSlot.this.remote = (HasId)update.apply();
            WebAppDeploymentSlot.this.entity = AppServiceUtils.fromWebAppDeploymentSlot((DeploymentSlot)WebAppDeploymentSlot.this.remote);
            WebAppDeploymentSlot.this.refreshStatus();
            return WebAppDeploymentSlot.this;
        }

        public List<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettingsToAdd() {
            return this.appSettingsToAdd;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }

    public class WebAppDeploymentSlotCreator {
        public static final String CONFIGURATION_SOURCE_NEW = "new";
        public static final String CONFIGURATION_SOURCE_PARENT = "parent";
        private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current web app";
        private static final String FAILED_TO_GET_CONFIGURATION_SOURCE = "Failed to get configuration source slot";
        private String name;
        private String configurationSource = "parent";
        private Map<String, String> appSettings = null;
        private DiagnosticConfig diagnosticConfig = null;

        public WebAppDeploymentSlotCreator withName(String name) {
            this.name = name;
            return this;
        }

        public WebAppDeploymentSlotCreator withAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
            return this;
        }

        public WebAppDeploymentSlotCreator withConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        public WebAppDeploymentSlotCreator withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        public WebAppDeploymentSlot commit() {
            DeploymentSlot.DefinitionStages.WithCreate withCreate;
            String source;
            com.azure.resourcemanager.appservice.models.WebApp webApp = WebAppDeploymentSlot.this.webAppClient;
            DeploymentSlot.DefinitionStages.Blank blank = (DeploymentSlot.DefinitionStages.Blank)webApp.deploymentSlots().define(this.getName());
            switch (source = StringUtils.isEmpty((CharSequence)this.configurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)this.configurationSource)) {
                case "new": {
                    withCreate = blank.withBrandNewConfiguration();
                    break;
                }
                case "parent": {
                    withCreate = blank.withConfigurationFromParent();
                    break;
                }
                default: {
                    try {
                        DeploymentSlot deploymentSlot = Optional.ofNullable((DeploymentSlot)webApp.deploymentSlots().getByName(this.configurationSource)).orElseThrow(() -> new AzureToolkitRuntimeException(CONFIGURATION_SOURCE_DOES_NOT_EXISTS));
                        withCreate = blank.withConfigurationFromDeploymentSlot(deploymentSlot);
                        break;
                    }
                    catch (ManagementException e) {
                        throw new AzureToolkitRuntimeException(FAILED_TO_GET_CONFIGURATION_SOURCE, (Throwable)e);
                    }
                }
            }
            if (this.getAppSettings() != null) {
                withCreate.withAppSettings(this.getAppSettings());
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, this.getDiagnosticConfig());
            }
            WebAppDeploymentSlot.this.remote = (HasId)withCreate.create();
            WebAppDeploymentSlot.this.entity = AppServiceUtils.fromWebAppDeploymentSlot((DeploymentSlot)WebAppDeploymentSlot.this.remote);
            WebAppDeploymentSlot.this.refreshStatus();
            WebAppDeploymentSlot.this.parent.refresh();
            return WebAppDeploymentSlot.this;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }
}

