/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.PublishingProfileFormat;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.manager.AppServiceKuduManager;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.service.IProcessClient;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService$AjcClosure3;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAzureManager;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureBaseResource;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;

abstract class AbstractAppService<T extends WebAppBase, R extends AppServiceBaseEntity>
extends AbstractAzureManager<T>
implements IAppService<R>,
AzureOperationEvent.Source<AbstractAppService<T, R>> {
    protected static final String APP_SERVICE_ID_TEMPLATE = "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/sites/%s";
    protected AppServiceKuduManager kuduManager;
    protected R entity;
    protected String status = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public AbstractAppService(@Nonnull String id) {
        super(id);
    }

    public AbstractAppService(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name) {
        super(subscriptionId, resourceGroup, name);
    }

    public AbstractAppService(@Nonnull WebSiteBase webSiteBase) {
        super(webSiteBase.id());
    }

    public AbstractAppService(@Nonnull T appService) {
        super(appService);
        this.entity = this.getEntityFromRemoteResource((WebAppBase)this.remote);
    }

    @Override
    @AzureOperation(name="resource.refresh.resource", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void refresh() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.status("Pending");
            super.refresh();
            this.refreshStatus();
            this.entity = null;
            try {
                CacheManager.evictCache((String)"appservice/{}/runtime", (String)this.id());
                CacheManager.evictCache((String)"appservice/{}/appSettings", (String)this.id());
            }
            catch (Throwable throwable) {
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    public void start() {
        this.status("Pending");
        ((WebAppBase)this.remote()).start();
        super.refresh();
        this.refreshStatus();
    }

    @Override
    public void stop() {
        this.status("Pending");
        ((WebAppBase)this.remote()).stop();
        super.refresh();
        this.refreshStatus();
    }

    @Override
    public void restart() {
        this.status("Pending");
        ((WebAppBase)this.remote()).restart();
        super.refresh();
        this.refreshStatus();
    }

    public String id() {
        return String.format(APP_SERVICE_ID_TEMPLATE, this.subscriptionId, this.resourceGroup, this.name);
    }

    @Nonnull
    @Deprecated
    public synchronized R entity() {
        if (this.entity == null) {
            this.entity = this.getEntityFromRemoteResource((WebAppBase)this.remote());
        }
        return this.entity;
    }

    @Override
    @Deprecated
    public R getRawEntity() {
        return this.entity;
    }

    @Override
    public String hostName() {
        return ((WebAppBase)this.remote()).defaultHostname();
    }

    @Override
    public String state() {
        return ((WebAppBase)this.remote()).state();
    }

    @Override
    public String linuxFxVersion() {
        return ((WebAppBase)this.remote()).linuxFxVersion();
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return AppServiceUtils.fromPublishingProfile(((WebAppBase)this.remote()).getPublishingProfile());
    }

    @Override
    public DiagnosticConfig getDiagnosticConfig() {
        return AppServiceUtils.fromWebAppDiagnosticLogs(((WebAppBase)this.remote()).diagnosticLogsConfig());
    }

    @Override
    public Flux<String> streamAllLogsAsync() {
        return ((WebAppBase)this.remote()).streamAllLogsAsync();
    }

    @Override
    public Flux<ByteBuffer> getFileContent(String path) {
        return this.getFileClient().getFileContent(path);
    }

    @Override
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return this.getFileClient().getFilesInDirectory(dir);
    }

    @Override
    public AppServiceFile getFileByPath(String path) {
        return this.getFileClient().getFileByPath(path);
    }

    @Override
    public void uploadFileToPath(String content, String path) {
        this.getFileClient().uploadFileToPath(content, path);
    }

    @Override
    public void createDirectory(String path) {
        this.getFileClient().createDirectory(path);
    }

    @Override
    public void deleteFile(String path) {
        this.getFileClient().deleteFile(path);
    }

    @Override
    public List<ProcessInfo> listProcess() {
        return this.getProcessClient().listProcess();
    }

    @Override
    public CommandOutput execute(String command, String dir) {
        return this.getProcessClient().execute(command, dir);
    }

    @Override
    public InputStream listPublishingProfileXmlWithSecrets() {
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String resourceName = StringUtils.equals((CharSequence)resourceId.resourceType(), (CharSequence)"slots") ? String.format("%s/slots/%s", resourceId.parent().name(), resourceId.name()) : resourceId.name();
        CsmPublishingProfileOptions csmPublishingProfileOptions = new CsmPublishingProfileOptions().withFormat(PublishingProfileFormat.FTP);
        return ((WebSiteManagementClient)((AppServiceManager)((WebAppBase)this.remote()).manager()).serviceClient()).getWebApps().listPublishingProfileXmlWithSecrets(resourceId.resourceGroupName(), resourceName, csmPublishingProfileOptions);
    }

    @Override
    public TunnelStatus getAppServiceTunnelStatus() {
        return this.getProcessClient().getAppServiceTunnelStatus();
    }

    public String name() {
        return this.name;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public String status() {
        if (Objects.nonNull(this.status)) {
            return this.status;
        }
        this.refreshStatus();
        return "Loading";
    }

    public final void refreshStatus() {
        AzureTaskManager.getInstance().runOnPooledThread(() -> this.status(this.loadStatus()));
    }

    @Override
    public AppServicePlan getAppServicePlan() {
        return (AppServicePlan)((AzureAppServicePlan)Azure.az(AzureAppServicePlan.class)).get(((WebAppBase)this.remote()).appServicePlanId());
    }

    @Override
    public Region getRegion() {
        return Region.fromName((String)((WebAppBase)this.remote()).regionName());
    }

    @Override
    @Cacheable(cacheName="appservice/{}/appSettings", key="${this.getId()}")
    public Map<String, String> getAppSettings() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AbstractAppService$AjcClosure1 abstractAppService$AjcClosure1 = new AbstractAppService$AjcClosure1(objectArray);
        return (Map)CacheManager.aspectOf().aroundCacheable(abstractAppService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @Cacheable(cacheName="appservice/{}/runtime", key="${this.getId()}")
    public Runtime getRuntime() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AbstractAppService$AjcClosure3 abstractAppService$AjcClosure3 = new AbstractAppService$AjcClosure3(objectArray);
        return (Runtime)CacheManager.aspectOf().aroundCacheable(abstractAppService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    protected final void status(@Nonnull String status) {
        String oldStatus = this.status;
        this.status = status;
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldStatus, (CharSequence)this.status)) {
            AzureEventBus.emit((String)"common|resource.status_changed", (Object)this);
        }
    }

    protected String loadStatus() {
        if (!this.exists()) {
            return "Unknown";
        }
        String state = Optional.ofNullable(((WebAppBase)this.remote()).state()).map(Objects::toString).orElse("");
        return IAzureBaseResource.Status.status.stream().filter(status -> StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)state)).findFirst().orElse("Unknown");
    }

    protected IFileClient getFileClient() {
        return this.getKuduManager();
    }

    protected IProcessClient getProcessClient() {
        return this.getKuduManager();
    }

    protected AppServiceKuduManager getKuduManager() {
        if (this.kuduManager == null) {
            this.kuduManager = AppServiceKuduManager.getClient((WebAppBase)this.remote(), this);
        }
        return this.kuduManager;
    }

    @Nonnull
    protected abstract R getEntityFromRemoteResource(@Nonnull T var1);

    @Override
    @Nullable
    protected abstract T loadRemote();

    static {
        AbstractAppService.ajc$preClinit();
    }

    static final /* synthetic */ Map getAppSettings_aroundBody0(AbstractAppService ajc$this, JoinPoint joinPoint) {
        return Utils.normalizeAppSettings(((WebAppBase)ajc$this.remote()).getAppSettings());
    }

    static final /* synthetic */ Runtime getRuntime_aroundBody2(AbstractAppService ajc$this, JoinPoint joinPoint) {
        return AppServiceUtils.getRuntimeFromAppService((WebAppBase)ajc$this.remote());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAppService.java", AbstractAppService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService", "", "", "", "void"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAppSettings", "com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService", "", "", "", "java.util.Map"), 258);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRuntime", "com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.model.Runtime"), 264);
    }
}

