/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.HostKeysInner;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlotBasic;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionAppDeploymentSlot
extends FunctionAppBase<FunctionDeploymentSlot, FunctionAppDeploymentSlotEntity>
implements IFunctionAppBase<FunctionAppDeploymentSlotEntity> {
    private static final String FUNCTION_DEPLOYMENT_SLOT_ID_TEMPLATE = "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/sites/%s/slots/%s";
    @Nonnull
    private final FunctionApp parent;
    @Nonnull
    private final com.azure.resourcemanager.appservice.models.FunctionApp functionAppClient;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public FunctionAppDeploymentSlot(@Nonnull FunctionApp parent, @Nonnull com.azure.resourcemanager.appservice.models.FunctionApp functionApp, @Nonnull String slotName) {
        super(Utils.getSubscriptionId(functionApp.id()), functionApp.resourceGroupName(), slotName);
        this.parent = parent;
        this.functionAppClient = functionApp;
    }

    public FunctionAppDeploymentSlot(@Nonnull FunctionApp parent, @Nonnull com.azure.resourcemanager.appservice.models.FunctionApp functionApp, @Nonnull FunctionDeploymentSlotBasic slotBasic) {
        super((WebSiteBase)slotBasic);
        this.parent = parent;
        this.functionAppClient = functionApp;
    }

    public FunctionApp functionApp() {
        return this.parent;
    }

    public FunctionAppDeploymentSlotCreator create() {
        return new FunctionAppDeploymentSlotCreator();
    }

    public FunctionAppDeploymentSlotUpdater update() {
        return new FunctionAppDeploymentSlotUpdater();
    }

    @Override
    @NotNull
    protected FunctionAppDeploymentSlotEntity getEntityFromRemoteResource(@NotNull FunctionDeploymentSlot remote) {
        return AppServiceUtils.fromFunctionAppDeploymentSlot(remote);
    }

    @Override
    @AzureOperation(name="functionapp.delete_slot.slot|app", params={"this.name(), this.parent.name()"}, type=AzureOperation.Type.SERVICE)
    public void delete() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.functionAppClient.deploymentSlots().deleteById(this.id());
            this.functionApp().refresh();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="functionapp.start_slot.slot|app", params={"this.name(), this.parent.name()"}, type=AzureOperation.Type.SERVICE)
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.start();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="functionapp.stop_slot.slot|app", params={"this.name(), this.parent.name()"}, type=AzureOperation.Type.SERVICE)
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.stop();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="functionapp.restart_slot.slot|app", params={"this.name(), this.parent.name()"}, type=AzureOperation.Type.SERVICE)
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.restart();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nullable
    protected FunctionDeploymentSlot loadRemote() {
        return (FunctionDeploymentSlot)this.functionAppClient.deploymentSlots().getByName(this.name);
    }

    @Override
    public String getMasterKey() {
        String name = String.format("%s/slots/%s", this.parent.getName(), this.getName());
        return (String)((WebSiteManagementClient)((AppServiceManager)((FunctionDeploymentSlot)this.remote()).manager()).serviceClient()).getWebApps().listHostKeysAsync(this.getResourceGroupName(), name).map(HostKeysInner::masterKey).block();
    }

    @Override
    public String id() {
        return String.format(FUNCTION_DEPLOYMENT_SLOT_ID_TEMPLATE, this.subscriptionId, this.resourceGroup, this.functionAppClient.name(), this.name);
    }

    static {
        FunctionAppDeploymentSlot.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionAppDeploymentSlot.java", FunctionAppDeploymentSlot.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot", "", "", "", "void"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot", "", "", "", "void"), 81);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot", "", "", "", "void"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot", "", "", "", "void"), 93);
    }

    public class FunctionAppDeploymentSlotUpdater {
        private final List<String> appSettingsToRemove = new ArrayList<String>();
        private final Map<String, String> appSettingsToAdd = new HashMap<String, String>();
        private DiagnosticConfig diagnosticConfig = null;

        public FunctionAppDeploymentSlotUpdater withoutAppSettings(String key) {
            this.appSettingsToRemove.add(key);
            return this;
        }

        public FunctionAppDeploymentSlotUpdater withAppSettings(Map<String, String> appSettings) {
            this.appSettingsToAdd.putAll(appSettings);
            return this;
        }

        public FunctionAppDeploymentSlotUpdater withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        public FunctionAppDeploymentSlot commit() {
            DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)((FunctionDeploymentSlot)FunctionAppDeploymentSlot.this.remote()).update();
            if (this.getAppSettingsToAdd() != null) {
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (this.getAppSettingsToRemove() != null) {
                this.getAppSettingsToRemove().forEach(arg_0 -> ((DeploymentSlotBase.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, this.getDiagnosticConfig());
            }
            FunctionAppDeploymentSlot.this.remote = (HasId)update.apply();
            FunctionAppDeploymentSlot.this.entity = AppServiceUtils.fromFunctionAppDeploymentSlot((FunctionDeploymentSlot)FunctionAppDeploymentSlot.this.remote);
            FunctionAppDeploymentSlot.this.refreshStatus();
            return FunctionAppDeploymentSlot.this;
        }

        public List<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettingsToAdd() {
            return this.appSettingsToAdd;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }

    public class FunctionAppDeploymentSlotCreator {
        public static final String CONFIGURATION_SOURCE_NEW = "new";
        public static final String CONFIGURATION_SOURCE_PARENT = "parent";
        private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current web app";
        private static final String FAILED_TO_GET_CONFIGURATION_SOURCE = "Failed to get configuration source slot";
        private String name;
        private String configurationSource = "parent";
        private Map<String, String> appSettings = null;
        private DiagnosticConfig diagnosticConfig = null;

        public FunctionAppDeploymentSlotCreator withName(String name) {
            this.name = name;
            return this;
        }

        public FunctionAppDeploymentSlotCreator withAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
            return this;
        }

        public FunctionAppDeploymentSlotCreator withConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        public FunctionAppDeploymentSlotCreator withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        public FunctionAppDeploymentSlot commit() {
            FunctionDeploymentSlot.DefinitionStages.WithCreate withCreate;
            String source;
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp = FunctionAppDeploymentSlot.this.functionAppClient;
            FunctionDeploymentSlot.DefinitionStages.Blank blank = (FunctionDeploymentSlot.DefinitionStages.Blank)functionApp.deploymentSlots().define(this.getName());
            switch (source = StringUtils.isEmpty((CharSequence)this.configurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)this.configurationSource)) {
                case "new": {
                    withCreate = blank.withBrandNewConfiguration();
                    break;
                }
                case "parent": {
                    withCreate = blank.withConfigurationFromParent();
                    break;
                }
                default: {
                    try {
                        FunctionDeploymentSlot deploymentSlot = Optional.ofNullable((FunctionDeploymentSlot)functionApp.deploymentSlots().getByName(this.configurationSource)).orElseThrow(() -> new AzureToolkitRuntimeException(CONFIGURATION_SOURCE_DOES_NOT_EXISTS));
                        withCreate = blank.withConfigurationFromDeploymentSlot(deploymentSlot);
                        break;
                    }
                    catch (ManagementException e) {
                        throw new AzureToolkitRuntimeException(FAILED_TO_GET_CONFIGURATION_SOURCE, (Throwable)e);
                    }
                }
            }
            if (this.getAppSettings() != null) {
                withCreate.withAppSettings(this.getAppSettings());
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, this.getDiagnosticConfig());
            }
            FunctionAppDeploymentSlot.this.remote = (HasId)withCreate.create();
            FunctionAppDeploymentSlot.this.entity = AppServiceUtils.fromFunctionAppDeploymentSlot((FunctionDeploymentSlot)FunctionAppDeploymentSlot.this.remote);
            FunctionAppDeploymentSlot.this.refreshStatus();
            FunctionAppDeploymentSlot.this.parent.refresh();
            return FunctionAppDeploymentSlot.this;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }
}

