/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.AzureFunction;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceCreator;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceCreator;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp$AjcClosure3;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp$AjcClosure5;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import io.jsonwebtoken.lang.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionApp
extends FunctionAppBase<com.azure.resourcemanager.appservice.models.FunctionApp, FunctionAppEntity>
implements IFunctionAppBase<FunctionAppEntity> {
    private static final Logger log;
    public static final String FUNCTIONS_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    public static final JavaVersion DEFAULT_JAVA_VERSION;
    private static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    private final AppServiceManager azureClient;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public FunctionApp(@Nonnull String id, @Nonnull AppServiceManager azureClient) {
        super(id);
        this.azureClient = azureClient;
    }

    public FunctionApp(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name, @Nonnull AppServiceManager azureClient) {
        super(subscriptionId, resourceGroup, name);
        this.azureClient = azureClient;
    }

    public FunctionApp(@Nonnull WebSiteBase webSiteBase, @Nonnull AppServiceManager azureClient) {
        super(webSiteBase);
        this.azureClient = azureClient;
    }

    public AppServicePlan plan() {
        return (AppServicePlan)((AzureAppServicePlan)Azure.az(AzureAppServicePlan.class)).get(((com.azure.resourcemanager.appservice.models.FunctionApp)this.remote()).appServicePlanId());
    }

    public IAppServiceCreator<FunctionApp> create() {
        return new FunctionAppCreator();
    }

    public IAppServiceUpdater<FunctionApp> update() {
        return new FunctionAppUpdater();
    }

    @Cacheable(cacheName="appservice/functionapp/{}/slot/{}", key="${this.name()}/$slotName")
    public FunctionAppDeploymentSlot deploymentSlot(String slotName) {
        String string = slotName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        FunctionApp$AjcClosure1 functionApp$AjcClosure1 = new FunctionApp$AjcClosure1(objectArray);
        return (FunctionAppDeploymentSlot)CacheManager.aspectOf().aroundCacheable(functionApp$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/functionapp/{}/slots", key="${this.name()}", condition="!(force&&force[0])")
    public List<FunctionAppDeploymentSlot> deploymentSlots(boolean ... force) {
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)blArray);
        Object[] objectArray = new Object[]{this, blArray, joinPoint};
        FunctionApp$AjcClosure3 functionApp$AjcClosure3 = new FunctionApp$AjcClosure3(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(functionApp$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/functionapp/{}/functions", key="${this.name()}", condition="!(force&&force[0])")
    public List<FunctionEntity> listFunctions(boolean ... force) {
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)blArray);
        Object[] objectArray = new Object[]{this, blArray, joinPoint};
        FunctionApp$AjcClosure5 functionApp$AjcClosure5 = new FunctionApp$AjcClosure5(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(functionApp$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public void triggerFunction(String functionName, Object input) {
        ((com.azure.resourcemanager.appservice.models.FunctionApp)this.remote()).triggerFunction(functionName, input);
    }

    public void swap(String slotName) {
        ((com.azure.resourcemanager.appservice.models.FunctionApp)this.remote()).swap(slotName);
    }

    public void syncTriggers() {
        ((com.azure.resourcemanager.appservice.models.FunctionApp)this.remote()).syncTriggers();
    }

    @Override
    @AzureOperation(name="functionapp.delete_app.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void delete() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.exists()) {
                this.status("Pending");
                this.azureClient.functionApps().deleteById(this.id());
                ((AzureFunction)Azure.az(AzureFunction.class)).refresh();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    public void refresh() {
        try {
            super.refresh();
        }
        finally {
            try {
                CacheManager.evictCache((String)"appservice/functionapp/{}/slots", (String)this.name());
                CacheManager.evictCache((String)"appservice/functionapp/{}/slot/{}", (String)"<ALL>");
            }
            catch (Throwable e) {
                log.warn("failed to evict cache", e);
            }
        }
    }

    @Override
    @AzureOperation(name="functionapp.start_app.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.start();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="functionapp.stop_app.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.stop();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="functionapp.restart_app.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            super.restart();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    protected FunctionAppEntity getEntityFromRemoteResource(@NotNull com.azure.resourcemanager.appservice.models.FunctionApp remote) {
        return AppServiceUtils.fromFunctionApp(remote);
    }

    @Override
    @Nullable
    protected com.azure.resourcemanager.appservice.models.FunctionApp loadRemote() {
        return (com.azure.resourcemanager.appservice.models.FunctionApp)this.azureClient.functionApps().getByResourceGroup(this.resourceGroup, this.name);
    }

    @Override
    public String getMasterKey() {
        return ((com.azure.resourcemanager.appservice.models.FunctionApp)this.remote()).getMasterKey();
    }

    public Map<String, String> listFunctionKeys(String functionName) {
        return ((com.azure.resourcemanager.appservice.models.FunctionApp)this.remote()).listFunctionKeys(functionName);
    }

    static {
        FunctionApp.ajc$preClinit();
        log = LoggerFactory.getLogger(FunctionApp.class);
        DEFAULT_JAVA_VERSION = JavaVersion.JAVA_8;
    }

    static final /* synthetic */ FunctionAppDeploymentSlot deploymentSlot_aroundBody0(FunctionApp ajc$this, String slotName, JoinPoint joinPoint) {
        return new FunctionAppDeploymentSlot(ajc$this, (com.azure.resourcemanager.appservice.models.FunctionApp)ajc$this.remote(), slotName);
    }

    static final /* synthetic */ List deploymentSlots_aroundBody2(FunctionApp ajc$this, boolean[] force, JoinPoint joinPoint) {
        return ((Stream)((com.azure.resourcemanager.appservice.models.FunctionApp)ajc$this.remote()).deploymentSlots().list().stream().parallel()).map(functionSlotBasic -> this.deploymentSlot(functionSlotBasic.name())).collect(Collectors.toList());
    }

    static final /* synthetic */ List listFunctions_aroundBody4(FunctionApp ajc$this, boolean[] force, JoinPoint joinPoint) {
        return ajc$this.azureClient.functionApps().listFunctions(ajc$this.resourceGroup, ajc$this.name).stream().map(AppServiceUtils::fromFunctionAppEnvelope).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionApp.java", FunctionApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploymentSlot", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "java.lang.String", "slotName", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "deploymentSlots", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "[Z", "force", "", "java.util.List"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "listFunctions", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "[Z", "force", "", "java.util.List"), 100);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "", "", "", "void"), 121);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "", "", "", "void"), 145);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "", "", "", "void"), 151);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp", "", "", "", "void"), 157);
    }

    public class FunctionAppUpdater
    extends AbstractAppServiceUpdater<FunctionApp> {
        public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system for existing app service";
        private boolean modified = false;

        public FunctionApp commit() {
            FunctionApp.Update update = (FunctionApp.Update)((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.remote()).update();
            String functionExtensionVersion = Optional.ofNullable(this.getAppSettingsToAdd().get(FunctionApp.FUNCTIONS_EXTENSION_VERSION)).orElseGet(() -> (String)FunctionApp.this.getAppSettings().get(FunctionApp.FUNCTIONS_EXTENSION_VERSION));
            if (this.getAppServicePlan() != null && this.getAppServicePlan().isPresent()) {
                update = this.updateAppServicePlan(update, this.getAppServicePlan().get());
            }
            if (this.getRuntime() != null && this.getRuntime().isPresent()) {
                update = this.updateRuntime(update, this.getRuntime().get(), functionExtensionVersion);
            }
            if (this.getDockerConfiguration() != null && this.getDockerConfiguration().isPresent() && FunctionApp.this.getRuntime().isDocker()) {
                this.modified = true;
                update = this.updateDockerConfiguration(update, this.getDockerConfiguration().get());
            }
            if (!Collections.isEmpty(this.getAppSettingsToAdd())) {
                this.modified = true;
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (!Collections.isEmpty(this.getAppSettingsToRemove())) {
                this.modified = true;
                this.getAppSettingsToRemove().forEach(arg_0 -> ((FunctionApp.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                this.modified = true;
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, this.getDiagnosticConfig().get());
            }
            if (this.modified) {
                FunctionApp.this.remote = (HasId)update.apply();
            }
            FunctionApp.this.entity = AppServiceUtils.fromFunctionApp((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.remote);
            FunctionApp.this.refreshStatus();
            return FunctionApp.this;
        }

        private FunctionApp.Update updateAppServicePlan(FunctionApp.Update update, AppServicePlanEntity newServicePlan) {
            AppServicePlan plan = FunctionApp.this.getAppServicePlan();
            if (StringUtils.equalsIgnoreCase((CharSequence)plan.getId(), (CharSequence)newServicePlan.getId()) || StringUtils.equalsIgnoreCase((CharSequence)plan.getName(), (CharSequence)newServicePlan.getName()) && StringUtils.equalsIgnoreCase((CharSequence)plan.getResourceGroupName(), (CharSequence)newServicePlan.getResourceGroup())) {
                return update;
            }
            com.azure.resourcemanager.appservice.models.AppServicePlan newPlanServiceModel = AppServiceUtils.getAppServicePlan(newServicePlan, FunctionApp.this.azureClient);
            if (newPlanServiceModel == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            this.modified = true;
            return update.withExistingAppServicePlan(newPlanServiceModel);
        }

        private FunctionApp.Update updateRuntime(FunctionApp.Update update, Runtime newRuntime, String functionExtensionVersion) {
            Runtime current = FunctionApp.this.getRuntime();
            if (newRuntime.getOperatingSystem() != null && current.getOperatingSystem() != newRuntime.getOperatingSystem()) {
                throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
            }
            if (Objects.equals(current, newRuntime) || current.isDocker()) {
                return update;
            }
            this.modified = true;
            OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), current.getOperatingSystem()}));
            switch (operatingSystem) {
                case LINUX: {
                    return update.withBuiltInImage(AppServiceUtils.toFunctionRuntimeStack(newRuntime, functionExtensionVersion));
                }
                case WINDOWS: {
                    return this.updateWindowsFunctionApp(update, current, newRuntime);
                }
            }
            throw new AzureToolkitRuntimeException(String.format(FunctionApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }

        private FunctionApp.Update updateDockerConfiguration(FunctionApp.Update update, DockerConfiguration dockerConfiguration) {
            if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()})) {
                return update.withPublicDockerHubImage(dockerConfiguration.getImage());
            }
            if (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl())) {
                return update.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
            }
            return update.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
        }

        FunctionApp.Update updateWindowsFunctionApp(FunctionApp.Update update, Runtime currentRuntime, Runtime newRuntime) {
            if (Objects.equals(currentRuntime.getJavaVersion(), JavaVersion.OFF)) {
                JavaVersion javaVersion = Optional.ofNullable(newRuntime.getJavaVersion()).orElse(DEFAULT_JAVA_VERSION);
                return (FunctionApp.Update)update.withJavaVersion(AppServiceUtils.toJavaVersion(javaVersion)).withWebContainer(null);
            }
            if (ObjectUtils.notEqual((Object)newRuntime.getJavaVersion(), (Object)JavaVersion.OFF) && ObjectUtils.notEqual((Object)newRuntime.getJavaVersion(), (Object)currentRuntime.getJavaVersion())) {
                return (FunctionApp.Update)update.withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(null);
            }
            return update;
        }
    }

    public class FunctionAppCreator
    extends AbstractAppServiceCreator<FunctionApp> {
        public static final String APP_SETTING_MACHINEKEY_DECRYPTION_KEY = "MACHINEKEY_DecryptionKey";
        public static final String APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE = "WEBSITES_ENABLE_APP_SERVICE_STORAGE";
        public static final String APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE = "false";
        public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE = "FUNCTION_APP_EDIT_MODE";
        public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY = "readOnly";

        @Override
        public FunctionApp commit() {
            FunctionApp.DefinitionStages.WithCreate withCreate;
            FunctionApp.DefinitionStages.Blank blank = (FunctionApp.DefinitionStages.Blank)FunctionApp.this.azureClient.functionApps().define(this.getName());
            Runtime runtime = this.getRuntime();
            com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlan(this.getAppServicePlanEntity(), FunctionApp.this.azureClient);
            if (appServicePlan == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            String functionExtensionVersion = this.getAppSettings().map(map -> (String)map.get(FunctionApp.FUNCTIONS_EXTENSION_VERSION)).orElse(null);
            switch (runtime.getOperatingSystem()) {
                case LINUX: {
                    withCreate = this.createLinuxFunctionApp(blank, appServicePlan, runtime, functionExtensionVersion);
                    break;
                }
                case WINDOWS: {
                    withCreate = this.createWindowsFunctionApp(blank, appServicePlan, runtime);
                    break;
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    withCreate = this.createDockerFunctionApp(blank, appServicePlan, dockerConfiguration);
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException(String.format(FunctionApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{runtime.getOperatingSystem()}));
                }
            }
            if (this.getAppSettings() != null && this.getAppSettings().isPresent()) {
                withCreate.withAppSettings(this.getAppSettings().get());
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, this.getDiagnosticConfig().get());
            }
            FunctionApp.this.remote = (HasId)withCreate.create();
            FunctionApp.this.entity = AppServiceUtils.fromFunctionApp((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.remote);
            FunctionApp.this.refreshStatus();
            ((AzureFunction)Azure.az(AzureFunction.class)).refresh();
            return FunctionApp.this;
        }

        FunctionApp.DefinitionStages.WithCreate createWindowsFunctionApp(FunctionApp.DefinitionStages.Blank blank, com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan, Runtime runtime) {
            return (FunctionApp.DefinitionStages.WithCreate)((FunctionApp.DefinitionStages.WithCreate)blank.withExistingAppServicePlan(appServicePlan).withExistingResourceGroup(FunctionApp.this.resourceGroup)).withJavaVersion(AppServiceUtils.toJavaVersion(runtime.getJavaVersion())).withWebContainer(null);
        }

        FunctionApp.DefinitionStages.WithCreate createLinuxFunctionApp(FunctionApp.DefinitionStages.Blank blank, com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan, Runtime runtime, String functionExtensionVersion) {
            return blank.withExistingLinuxAppServicePlan(appServicePlan).withExistingResourceGroup(FunctionApp.this.resourceGroup).withBuiltInImage(AppServiceUtils.toFunctionRuntimeStack(runtime, functionExtensionVersion));
        }

        FunctionApp.DefinitionStages.WithCreate createDockerFunctionApp(FunctionApp.DefinitionStages.Blank blank, com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan, DockerConfiguration dockerConfiguration) {
            if (StringUtils.equalsIgnoreCase((CharSequence)appServicePlan.pricingTier().toSkuDescription().tier(), (CharSequence)"Dynamic")) {
                throw new AzureToolkitRuntimeException("Docker function is not supported in consumption service plan");
            }
            FunctionApp.DefinitionStages.WithDockerContainerImage withLinuxAppFramework = blank.withExistingLinuxAppServicePlan(appServicePlan).withExistingResourceGroup(FunctionApp.this.resourceGroup);
            FunctionApp.DefinitionStages.WithCreate withCreate = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(dockerConfiguration.getImage()) : (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()));
            String decryptionKey = this.generateDecryptionKey();
            return (FunctionApp.DefinitionStages.WithCreate)withCreate.withAppSetting(APP_SETTING_MACHINEKEY_DECRYPTION_KEY, decryptionKey).withAppSetting(APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE, APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE).withAppSetting(APP_SETTING_FUNCTION_APP_EDIT_MODE, APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY);
        }

        protected String generateDecryptionKey() {
            return Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)32)).toUpperCase();
        }
    }
}

