/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.manager.AzureFunctionsResourceManager;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.service.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.FTPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.MSFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.RunFromBlobFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.RunFromZipFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.ZIPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class FunctionAppBase<T extends WebAppBase, R extends AppServiceBaseEntity>
extends AbstractAppService<T, R>
implements IFunctionAppBase<R> {
    private AzureFunctionsResourceManager functionsResourceManager;

    public FunctionAppBase(@NotNull String id) {
        super(id);
    }

    public FunctionAppBase(@NotNull String subscriptionId, @NotNull String resourceGroup, @NotNull String name) {
        super(subscriptionId, resourceGroup, name);
    }

    public FunctionAppBase(@NotNull WebSiteBase webSiteBase) {
        super(webSiteBase);
    }

    @Override
    public void deploy(File targetFile) {
        this.deploy(targetFile, this.getDefaultDeployType());
    }

    @Override
    public void deploy(File targetFile, FunctionDeployType functionDeployType) {
        this.getDeployHandlerByType(functionDeployType).deploy(targetFile, (WebAppBase)this.remote());
    }

    @Override
    protected IFileClient getFileClient() {
        if (this.functionsResourceManager == null) {
            this.functionsResourceManager = AzureFunctionsResourceManager.getClient((WebAppBase)this.remote(), this);
        }
        return this.functionsResourceManager;
    }

    protected FunctionDeployType getDefaultDeployType() {
        if (this.getRuntime().getOperatingSystem() == OperatingSystem.WINDOWS) {
            return FunctionDeployType.RUN_FROM_ZIP;
        }
        PricingTier pricingTier = this.getAppServicePlan().getPricingTier();
        return StringUtils.equalsAnyIgnoreCase((CharSequence)pricingTier.getTier(), (CharSequence[])new CharSequence[]{"Dynamic", "ElasticPremium"}) ? FunctionDeployType.RUN_FROM_BLOB : FunctionDeployType.RUN_FROM_ZIP;
    }

    protected IFunctionDeployHandler getDeployHandlerByType(FunctionDeployType deployType) {
        switch (deployType) {
            case FTP: {
                return new FTPFunctionDeployHandler();
            }
            case ZIP: {
                return new ZIPFunctionDeployHandler();
            }
            case MSDEPLOY: {
                return new MSFunctionDeployHandler();
            }
            case RUN_FROM_ZIP: {
                return new RunFromZipFunctionDeployHandler();
            }
            case RUN_FROM_BLOB: {
                return new RunFromBlobFunctionDeployHandler();
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported deployment type");
    }
}

