/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.common.validator.SchemaValidator;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CreateOrUpdateAppServicePlanTask
extends AzureTask<AppServicePlan> {
    private static final String CREATE_APP_SERVICE_PLAN = "Creating app service plan %s...";
    private static final String CREATE_APP_SERVICE_PLAN_DONE = "Successfully created app service plan %s.";
    private static final String CREATE_NEW_APP_SERVICE_PLAN = "createNewAppServicePlan";
    private AppServicePlanConfig config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="appservice.create_update_plan.plan", params={"this.config.servicePlanName()"}, type=AzureOperation.Type.SERVICE)
    public AppServicePlan execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SchemaValidator.getInstance().validateAndThrow("appservice/AppServicePlan", (Object)this.config);
            AzureAppService az = (AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(this.config.subscriptionId());
            AppServicePlan appServicePlan = az.appServicePlan(this.config.servicePlanResourceGroup(), this.config.servicePlanName());
            String servicePlanName = this.config.servicePlanName();
            if (!appServicePlan.exists()) {
                SchemaValidator.getInstance().validateAndThrow("appservice/CreateAppServicePlan", (Object)this.config);
                AzureMessager.getMessager().info(String.format(CREATE_APP_SERVICE_PLAN, servicePlanName));
                AzureTelemetry.getActionContext().setProperty(CREATE_NEW_APP_SERVICE_PLAN, String.valueOf(true));
                new CreateResourceGroupTask(this.config.subscriptionId(), this.config.servicePlanResourceGroup(), this.config.region()).execute();
                appServicePlan.create().withName(servicePlanName).withResourceGroup(this.config.servicePlanResourceGroup()).withPricingTier(this.config.pricingTier()).withRegion(this.config.region()).withOperatingSystem(this.config.os()).commit();
                AzureMessager.getMessager().info(String.format(CREATE_APP_SERVICE_PLAN_DONE, appServicePlan.name()));
            } else {
                if (this.config.region() != null && !Objects.equals(this.config.region(), appServicePlan.getRegion())) {
                    AzureMessager.getMessager().warning(String.format("Skip region update for existing service plan '%s' since it is not allowed.", appServicePlan.name()));
                }
                if (this.config.pricingTier() != null && !Objects.equals(this.config.pricingTier(), appServicePlan.getPricingTier())) {
                    appServicePlan.update().withPricingTier(this.config.pricingTier()).commit();
                }
            }
            AppServicePlan appServicePlan2 = appServicePlan;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServicePlan2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public CreateOrUpdateAppServicePlanTask(AppServicePlanConfig config) {
        this.config = config;
    }

    static {
        CreateOrUpdateAppServicePlanTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CreateOrUpdateAppServicePlanTask.java", CreateOrUpdateAppServicePlanTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateAppServicePlanTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan"), 31);
    }
}

