/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateAppServicePlanTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.entity.CheckNameAvailabilityResultEntity;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;

public class CreateOrUpdateWebAppTask
extends AzureTask<WebApp> {
    private static final String CREATE_NEW_WEB_APP = "createNewWebApp";
    private static final String CREATE_WEBAPP = "Creating web app %s...";
    private static final String CREATE_WEB_APP_DONE = "Successfully created web app %s.";
    private static final String UPDATE_WEBAPP = "Updating target web app %s...";
    private static final String UPDATE_WEBAPP_DONE = "Successfully updated web app %s.";
    private final AppServiceConfig config;
    private final List<AzureTask<?>> subTasks;
    private boolean skipCreateAzureResource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public CreateOrUpdateWebAppTask(AppServiceConfig config) {
        this.config = config;
        this.subTasks = this.initTasks();
    }

    private List<AzureTask<?>> initTasks() {
        ArrayList tasks = new ArrayList();
        AzureString title = AzureString.format((String)"Create new web app({0})", (Object[])new Object[]{this.config.appName()});
        AzureAppService az = (AzureAppService)Azure.az(AzureAppService.class);
        tasks.add(new AzureTask(title, () -> {
            WebApp target = ((AzureAppService)az.subscription(this.config.subscriptionId())).webapp(this.config.resourceGroup(), this.config.appName());
            if (!target.exists()) {
                CheckNameAvailabilityResultEntity result;
                if (this.skipCreateAzureResource) {
                    Utils.throwForbidCreateResourceWarning("Web app", this.config.appName());
                }
                if (!(result = az.checkNameAvailability(this.config.subscriptionId(), this.config.appName())).isAvailable()) {
                    throw new AzureToolkitRuntimeException(AzureString.format((String)"Cannot create webapp {0} due to error: {1}", (Object[])new Object[]{this.config.appName(), result.getUnavailabilityReason()}).getString());
                }
                return this.create();
            }
            return this.update(target);
        }));
        return tasks;
    }

    @AzureOperation(name="webapp.create_app.app", params={"this.config.appName()"}, type=AzureOperation.Type.SERVICE)
    private WebApp create() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTelemetry.getActionContext().setProperty(CREATE_NEW_WEB_APP, String.valueOf(true));
            AzureMessager.getMessager().info(String.format(CREATE_WEBAPP, this.config.appName()));
            Region region = this.config.region();
            new CreateResourceGroupTask(this.config.subscriptionId(), this.config.resourceGroup(), region).execute();
            AzureAppService az = (AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(this.config.subscriptionId());
            WebApp webapp = az.webapp(this.config.resourceGroup(), this.config.appName());
            AppServicePlanConfig servicePlanConfig = this.config.getServicePlanConfig();
            AppServicePlan appServicePlan = new CreateOrUpdateAppServicePlanTask(servicePlanConfig).execute();
            WebApp result = (WebApp)webapp.create().withName(this.config.appName()).withResourceGroup(this.config.resourceGroup()).withPlan(appServicePlan.id()).withRuntime(this.getRuntime(this.config.runtime())).withDockerConfiguration(this.getDockerConfiguration(this.config.runtime())).withAppSettings(this.config.appSettings()).commit();
            AzureMessager.getMessager().info(String.format(CREATE_WEB_APP_DONE, result.name()));
            WebApp webApp = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="webapp.update_app.app", params={"this.config.appName()"}, type=AzureOperation.Type.SERVICE)
    private WebApp update(WebApp webApp) {
        WebApp webApp2 = webApp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)webApp2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureMessager.getMessager().info(String.format(UPDATE_WEBAPP, webApp.name()));
            AppServicePlan currentPlan = webApp.plan();
            AppServicePlanConfig servicePlanConfig = this.config.getServicePlanConfig();
            if (this.skipCreateAzureResource && !((AzureAppService)Azure.az(AzureAppService.class)).appServicePlan(servicePlanConfig.servicePlanResourceGroup(), servicePlanConfig.servicePlanName()).exists()) {
                Utils.throwForbidCreateResourceWarning("Service plan", servicePlanConfig.servicePlanResourceGroup() + "/" + servicePlanConfig.servicePlanName());
            }
            Runtime runtime = this.getRuntime(this.config.runtime());
            AppServicePlan appServicePlan = new CreateOrUpdateAppServicePlanTask(servicePlanConfig).execute();
            WebApp.WebAppUpdater draft = webApp.update();
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.config.servicePlanResourceGroup(), (CharSequence)currentPlan.resourceGroup()) || !StringUtils.equalsIgnoreCase((CharSequence)this.config.servicePlanName(), (CharSequence)currentPlan.name())) {
                draft.withPlan(appServicePlan.id());
            }
            if (!webApp.getRuntime().equals(runtime)) {
                draft.withRuntime(runtime);
            }
            WebApp result = (WebApp)draft.withDockerConfiguration(this.getDockerConfiguration(this.config.runtime())).withAppSettings((Map)ObjectUtils.firstNonNull((Object[])new Map[]{this.config.appSettings(), new HashMap()})).commit();
            AzureMessager.getMessager().info(String.format(UPDATE_WEBAPP_DONE, webApp.name()));
            WebApp webApp3 = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp3;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private DockerConfiguration getDockerConfiguration(RuntimeConfig runtime) {
        if (runtime != null && OperatingSystem.DOCKER == runtime.os()) {
            return ((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)DockerConfiguration.builder().userName(runtime.username())).password(runtime.password())).registryUrl(runtime.registryUrl())).image(runtime.image())).startUpCommand(runtime.startUpCommand())).build();
        }
        return null;
    }

    private Runtime getRuntime(RuntimeConfig runtime) {
        if (runtime != null && OperatingSystem.DOCKER != runtime.os()) {
            return Runtime.getRuntime(runtime.os(), runtime.webContainer(), runtime.javaVersion());
        }
        if (runtime != null && OperatingSystem.DOCKER == runtime.os()) {
            return Runtime.getRuntime(OperatingSystem.DOCKER, WebContainer.JAVA_OFF, JavaVersion.OFF);
        }
        return null;
    }

    @AzureOperation(name="webapp.create_update_app.app", params={"this.config.appName()"}, type=AzureOperation.Type.SERVICE)
    public WebApp execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebApp webApp = (WebApp)Flux.fromStream(this.subTasks.stream().map(t -> t.getSupplier().get())).last().block();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void setSkipCreateAzureResource(boolean skipCreateAzureResource) {
        this.skipCreateAzureResource = skipCreateAzureResource;
    }

    static {
        CreateOrUpdateWebAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CreateOrUpdateWebAppTask.java", CreateOrUpdateWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "create", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "update", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp", "webApp", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp"), 110);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp"), 165);
    }
}

