/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.legacy.appservice.AppServiceUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AppServiceConfigUtils {
    private static final String SETTING_DOCKER_IMAGE = "DOCKER_CUSTOM_IMAGE_NAME";
    private static final String SETTING_REGISTRY_SERVER = "DOCKER_REGISTRY_SERVER_URL";

    public static AppServiceConfig fromAppService(IAppService<?> appService, AppServicePlan servicePlan) {
        AppServiceConfig config = new AppServiceConfig();
        config.appName(appService.name());
        config.resourceGroup(appService.getResourceGroupName());
        config.subscriptionId(Utils.getSubscriptionId(appService.id()));
        config.region(appService.getRegion());
        RuntimeConfig runtimeConfig = new RuntimeConfig();
        if (AppServiceUtils.isDockerAppService(appService)) {
            runtimeConfig.os(OperatingSystem.DOCKER);
            Map<String, String> settings = appService.getAppSettings();
            String imageSetting = settings.get(SETTING_DOCKER_IMAGE);
            if (StringUtils.isNotBlank((CharSequence)imageSetting)) {
                runtimeConfig.image(imageSetting);
            } else {
                runtimeConfig.image(Utils.getDockerImageNameFromLinuxFxVersion(appService.linuxFxVersion()));
            }
            String registryServerSetting = settings.get(SETTING_REGISTRY_SERVER);
            if (StringUtils.isNotBlank((CharSequence)registryServerSetting)) {
                runtimeConfig.registryUrl(registryServerSetting);
            }
        } else {
            runtimeConfig.os(appService.getRuntime().getOperatingSystem());
            runtimeConfig.webContainer(appService.getRuntime().getWebContainer());
            runtimeConfig.javaVersion(appService.getRuntime().getJavaVersion());
        }
        config.runtime(runtimeConfig);
        config.pricingTier(servicePlan.getPricingTier());
        config.servicePlanName(servicePlan.name());
        config.servicePlanResourceGroup(servicePlan.getResourceGroupName());
        return config;
    }

    public static AppServiceConfig buildDefaultWebAppConfig(String subscriptionId, String resourceGroup, String appName, String packaging, JavaVersion javaVersion) {
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultWebAppConfig(resourceGroup, appName, packaging, javaVersion);
        List regions = ((AzureAppService)Azure.az(AzureAppService.class)).listSupportedRegions(subscriptionId);
        appServiceConfig.region((Region)com.microsoft.azure.toolkit.lib.common.utils.Utils.selectFirstOptionIfCurrentInvalid((String)"region", (List)regions, (Object)appServiceConfig.region()));
        return appServiceConfig;
    }

    public static AppServiceConfig buildDefaultFunctionConfig(String subscriptionId, String resourceGroup, String appName, JavaVersion javaVersion) {
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultFunctionConfig(resourceGroup, appName, javaVersion);
        List regions = ((AzureAppService)Azure.az(AzureAppService.class)).listSupportedRegions(subscriptionId);
        appServiceConfig.region((Region)com.microsoft.azure.toolkit.lib.common.utils.Utils.selectFirstOptionIfCurrentInvalid((String)"region", (List)regions, (Object)appServiceConfig.region()));
        return appServiceConfig;
    }

    public static void mergeAppServiceConfig(AppServiceConfig to, AppServiceConfig from) {
        try {
            com.microsoft.azure.toolkit.lib.common.utils.Utils.mergeObjects((Object)to, (Object)from);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("Cannot copy object for class AppServiceConfig.", (Throwable)e);
        }
        if (to.runtime() != from.runtime()) {
            AppServiceConfigUtils.mergeRuntime(to.runtime(), from.runtime());
        }
    }

    private static void mergeRuntime(RuntimeConfig to, RuntimeConfig from) {
        try {
            com.microsoft.azure.toolkit.lib.common.utils.Utils.mergeObjects((Object)to, (Object)from);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("Cannot copy object for class RuntimeConfig.", (Throwable)e);
        }
    }
}

