/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceManager;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AppServiceConfigUtils {
    private static final String SETTING_DOCKER_IMAGE = "DOCKER_CUSTOM_IMAGE_NAME";
    private static final String SETTING_REGISTRY_SERVER = "DOCKER_REGISTRY_SERVER_URL";

    public static AppServiceConfig fromAppService(@Nonnull AppServiceAppBase<?, ?, ?> app, @Nonnull AppServicePlan servicePlan) {
        AppServiceConfig config = new AppServiceConfig();
        config.appName(app.getName());
        config.resourceGroup(app.getResourceGroupName());
        config.subscriptionId(app.getSubscriptionId());
        config.region(app.getRegion());
        Runtime runtime = app.getRuntime();
        RuntimeConfig runtimeConfig = new RuntimeConfig();
        if (runtime != null && runtime.isDocker()) {
            runtimeConfig.os(OperatingSystem.DOCKER);
            Map<String, String> settings = app.getAppSettings();
            String imageSetting = settings.get(SETTING_DOCKER_IMAGE);
            if (StringUtils.isNotBlank((CharSequence)imageSetting)) {
                runtimeConfig.image(imageSetting);
            } else {
                runtimeConfig.image(Utils.getDockerImageNameFromLinuxFxVersion(app.getLinuxFxVersion()));
            }
            String registryServerSetting = settings.get(SETTING_REGISTRY_SERVER);
            if (StringUtils.isNotBlank((CharSequence)registryServerSetting)) {
                runtimeConfig.registryUrl(registryServerSetting);
            }
        } else {
            runtimeConfig.os(runtime.getOperatingSystem());
            runtimeConfig.webContainer(runtime.getWebContainer());
            runtimeConfig.javaVersion(runtime.getJavaVersion());
        }
        config.runtime(runtimeConfig);
        config.pricingTier(servicePlan.getPricingTier());
        config.servicePlanName(servicePlan.name());
        config.servicePlanResourceGroup(servicePlan.getResourceGroupName());
        return config;
    }

    public static AppServiceConfig buildDefaultWebAppConfig(String subscriptionId, String resourceGroup, String appName, String packaging, JavaVersion javaVersion) {
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultWebAppConfig(resourceGroup, appName, packaging, javaVersion);
        List<Region> regions = ((AppServiceResourceManager)((AzureAppService)Azure.az(AzureAppService.class)).forSubscription(subscriptionId)).listSupportedRegions();
        appServiceConfig.region((Region)com.microsoft.azure.toolkit.lib.common.utils.Utils.selectFirstOptionIfCurrentInvalid((String)"region", regions, (Object)appServiceConfig.region()));
        return appServiceConfig;
    }

    public static AppServiceConfig buildDefaultFunctionConfig(String subscriptionId, String resourceGroup, String appName, JavaVersion javaVersion) {
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultFunctionConfig(resourceGroup, appName, javaVersion);
        List<Region> regions = ((AppServiceResourceManager)((AzureAppService)Azure.az(AzureAppService.class)).forSubscription(subscriptionId)).listSupportedRegions();
        appServiceConfig.region((Region)com.microsoft.azure.toolkit.lib.common.utils.Utils.selectFirstOptionIfCurrentInvalid((String)"region", regions, (Object)appServiceConfig.region()));
        return appServiceConfig;
    }

    public static void mergeAppServiceConfig(AppServiceConfig to, AppServiceConfig from) {
        try {
            com.microsoft.azure.toolkit.lib.common.utils.Utils.mergeObjects((Object)to, (Object)from);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("Cannot copy object for class AppServiceConfig.", (Throwable)e);
        }
        if (to.runtime() != from.runtime()) {
            AppServiceConfigUtils.mergeRuntime(to.runtime(), from.runtime());
        }
    }

    private static void mergeRuntime(RuntimeConfig to, RuntimeConfig from) {
        try {
            com.microsoft.azure.toolkit.lib.common.utils.Utils.mergeObjects((Object)to, (Object)from);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("Cannot copy object for class RuntimeConfig.", (Throwable)e);
        }
    }
}

