/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppDeploymentSlotDraft
extends WebAppDeploymentSlot
implements AzResource.Draft<WebAppDeploymentSlot, WebSiteBase> {
    private static final Logger log;
    private static final String CREATE_NEW_DEPLOYMENT_SLOT = "createNewDeploymentSlot";
    public static final String CONFIGURATION_SOURCE_NEW = "new";
    public static final String CONFIGURATION_SOURCE_PARENT = "parent";
    private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current web app";
    private static final String FAILED_TO_GET_CONFIGURATION_SOURCE = "Failed to get configuration source slot";
    @Nullable
    private final WebAppDeploymentSlot origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected WebAppDeploymentSlotDraft(@Nonnull String name, @Nonnull WebAppDeploymentSlotModule module) {
        super(name, module);
        this.origin = null;
    }

    protected WebAppDeploymentSlotDraft(@Nonnull WebAppDeploymentSlot origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Nonnull
    @AzureOperation(name="resource.create_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public DeploymentSlot createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            DeploymentSlot.DefinitionStages.WithCreate withCreate;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTelemetry.getActionContext().setProperty(CREATE_NEW_DEPLOYMENT_SLOT, String.valueOf(true));
            String name = this.getName();
            Map<String, String> newAppSettings = this.getAppSettings();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            String newConfigurationSource = this.getConfigurationSource();
            String source = StringUtils.isBlank((CharSequence)newConfigurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)newConfigurationSource);
            com.azure.resourcemanager.appservice.models.WebApp webApp = Objects.requireNonNull((com.azure.resourcemanager.appservice.models.WebApp)((WebApp)this.getParent()).getFullRemote());
            DeploymentSlot.DefinitionStages.Blank blank = (DeploymentSlot.DefinitionStages.Blank)webApp.deploymentSlots().define(this.getName());
            if (CONFIGURATION_SOURCE_NEW.equals(source)) {
                withCreate = blank.withBrandNewConfiguration();
            } else if (CONFIGURATION_SOURCE_PARENT.equals(source)) {
                withCreate = blank.withConfigurationFromParent();
            } else {
                try {
                    DeploymentSlot sourceSlot = (DeploymentSlot)webApp.deploymentSlots().getByName(newConfigurationSource);
                    Objects.requireNonNull(sourceSlot, CONFIGURATION_SOURCE_DOES_NOT_EXISTS);
                    withCreate = blank.withConfigurationFromDeploymentSlot(sourceSlot);
                }
                catch (ManagementException e) {
                    throw new AzureToolkitRuntimeException(FAILED_TO_GET_CONFIGURATION_SOURCE, (Throwable)e);
                }
            }
            if (MapUtils.isNotEmpty(newAppSettings)) {
                withCreate.withAppSettings(newAppSettings);
            }
            if (Objects.nonNull(newDiagnosticConfig)) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, newDiagnosticConfig);
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Web App deployment slot ({0})...", (Object[])new Object[]{name}));
            DeploymentSlot slot = (DeploymentSlot)Objects.requireNonNull((WebSiteBase)this.doModify(() -> (WebSiteBase)withCreate.create(), "Creating"));
            messager.success(AzureString.format((String)"Web App deployment slot ({0}) is successfully created", (Object[])new Object[]{name}));
            DeploymentSlot deploymentSlot = slot;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return deploymentSlot;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.update_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public DeploymentSlot updateResourceInAzure(@Nonnull WebSiteBase base) {
        WebSiteBase webSiteBase = base;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)webSiteBase);
        try {
            boolean modified;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            DeploymentSlot remote = (DeploymentSlot)base;
            Map<String, String> settingsToAdd = this.getAppSettings();
            Set<String> settingsToRemove = this.getAppSettingsToRemove();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            boolean bl = modified = MapUtils.isNotEmpty(settingsToAdd) || CollectionUtils.isNotEmpty(settingsToRemove) || Objects.nonNull(newDiagnosticConfig);
            if (modified) {
                DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)remote.update();
                Optional.ofNullable(settingsToAdd).ifPresent(arg_0 -> ((DeploymentSlotBase.Update)update).withAppSettings(arg_0));
                Optional.ofNullable(settingsToRemove).ifPresent(s -> s.forEach(arg_0 -> ((DeploymentSlotBase.Update)update).withoutAppSetting(arg_0)));
                Optional.ofNullable(newDiagnosticConfig).ifPresent(c -> AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, newDiagnosticConfig));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating Web App deployment slot({0})...", (Object[])new Object[]{remote.name()}));
                remote = (DeploymentSlot)update.apply();
                messager.success(AzureString.format((String)"Web App deployment slot({0}) is successfully updated", (Object[])new Object[]{remote.name()}));
            }
            DeploymentSlot deploymentSlot = remote;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return deploymentSlot;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void setConfigurationSource(String source) {
        this.ensureConfig().setConfigurationSource(source);
    }

    @Nullable
    public String getConfigurationSource() {
        return Optional.ofNullable(this.config).map(Config::getConfigurationSource).orElse(null);
    }

    public void setAppSettings(Map<String, String> appSettings) {
        this.ensureConfig().setAppSettings(appSettings);
    }

    @Override
    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.config).map(Config::getAppSettings).orElseGet(() -> super.getAppSettings());
    }

    public void removeAppSetting(String key) {
        this.ensureConfig().getAppSettingsToRemove().add(key);
    }

    @Nullable
    public Set<String> getAppSettingsToRemove() {
        return Optional.ofNullable(this.config).map(Config::getAppSettingsToRemove).orElse(new HashSet());
    }

    public void setDiagnosticConfig(DiagnosticConfig config) {
        this.ensureConfig().setDiagnosticConfig(config);
    }

    @Override
    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.config).map(Config::getDiagnosticConfig).orElseGet(() -> super.getDiagnosticConfig());
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || StringUtils.isBlank((CharSequence)this.config.getConfigurationSource()) || Objects.isNull(this.config.getDiagnosticConfig()) || CollectionUtils.isEmpty(this.config.getAppSettingsToRemove()) || Objects.isNull(this.config.getAppSettings()) || Objects.equals(this.config.getAppSettings(), super.getAppSettings());
        return !notModified;
    }

    @Nullable
    public WebAppDeploymentSlot getOrigin() {
        return this.origin;
    }

    static {
        WebAppDeploymentSlotDraft.ajc$preClinit();
        log = LoggerFactory.getLogger(WebAppDeploymentSlotDraft.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebAppDeploymentSlotDraft.java", WebAppDeploymentSlotDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotDraft", "", "", "", "com.azure.resourcemanager.appservice.models.DeploymentSlot"), 80);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotDraft", "com.azure.resourcemanager.appservice.models.WebSiteBase", "base", "", "com.azure.resourcemanager.appservice.models.DeploymentSlot"), 127);
    }

    @Nullable
    private static class Config {
        private String configurationSource;
        private DiagnosticConfig diagnosticConfig = null;
        private Set<String> appSettingsToRemove = new HashSet<String>();
        private Map<String, String> appSettings = null;

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }

        public Set<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public void setConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
        }

        public void setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
        }

        public void setAppSettingsToRemove(Set<String> appSettingsToRemove) {
            this.appSettingsToRemove = appSettingsToRemove;
        }

        public void setAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$configurationSource = this.getConfigurationSource();
            String other$configurationSource = other.getConfigurationSource();
            if (this$configurationSource == null ? other$configurationSource != null : !this$configurationSource.equals(other$configurationSource)) {
                return false;
            }
            DiagnosticConfig this$diagnosticConfig = this.getDiagnosticConfig();
            DiagnosticConfig other$diagnosticConfig = other.getDiagnosticConfig();
            if (this$diagnosticConfig == null ? other$diagnosticConfig != null : !((Object)this$diagnosticConfig).equals(other$diagnosticConfig)) {
                return false;
            }
            Set<String> this$appSettingsToRemove = this.getAppSettingsToRemove();
            Set<String> other$appSettingsToRemove = other.getAppSettingsToRemove();
            if (this$appSettingsToRemove == null ? other$appSettingsToRemove != null : !((Object)this$appSettingsToRemove).equals(other$appSettingsToRemove)) {
                return false;
            }
            Map<String, String> this$appSettings = this.getAppSettings();
            Map<String, String> other$appSettings = other.getAppSettings();
            return !(this$appSettings == null ? other$appSettings != null : !((Object)this$appSettings).equals(other$appSettings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $configurationSource = this.getConfigurationSource();
            result = result * 59 + ($configurationSource == null ? 43 : $configurationSource.hashCode());
            DiagnosticConfig $diagnosticConfig = this.getDiagnosticConfig();
            result = result * 59 + ($diagnosticConfig == null ? 43 : ((Object)$diagnosticConfig).hashCode());
            Set<String> $appSettingsToRemove = this.getAppSettingsToRemove();
            result = result * 59 + ($appSettingsToRemove == null ? 43 : ((Object)$appSettingsToRemove).hashCode());
            Map<String, String> $appSettings = this.getAppSettings();
            result = result * 59 + ($appSettings == null ? 43 : ((Object)$appSettings).hashCode());
            return result;
        }

        public String toString() {
            return "WebAppDeploymentSlotDraft.Config(configurationSource=" + this.getConfigurationSource() + ", diagnosticConfig=" + this.getDiagnosticConfig() + ", appSettingsToRemove=" + this.getAppSettingsToRemove() + ", appSettings=" + this.getAppSettings() + ")";
        }
    }
}

