/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FunctionApp
extends FunctionAppBase<FunctionApp, AppServiceServiceSubscription, com.azure.resourcemanager.appservice.models.FunctionApp>
implements Deletable {
    @Nonnull
    private final FunctionAppDeploymentSlotModule deploymentModule;

    protected FunctionApp(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull FunctionAppModule module) {
        super(name, resourceGroupName, module);
        this.deploymentModule = new FunctionAppDeploymentSlotModule(this);
    }

    protected FunctionApp(@Nonnull FunctionApp origin) {
        super(origin);
        this.deploymentModule = origin.deploymentModule;
    }

    protected FunctionApp(@Nonnull FunctionAppBasic remote, @Nonnull FunctionAppModule module) {
        super(remote.name(), remote.resourceGroupName(), module);
        this.deploymentModule = new FunctionAppDeploymentSlotModule(this);
        this.setRemote(remote);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, FunctionApp, ?>> getSubModules() {
        return Collections.singletonList(this.deploymentModule);
    }

    @Override
    @Nullable
    public String getMasterKey() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).map(com.azure.resourcemanager.appservice.models.FunctionApp::getMasterKey).orElse(null);
    }

    @Nonnull
    public List<FunctionEntity> listFunctions(boolean ... force) {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).map(r -> r.listFunctions().stream().map(envelope -> AppServiceUtils.fromFunctionAppEnvelope(envelope, this.getId())).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public void triggerFunction(String functionName, Object input) {
        Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).ifPresent(r -> r.triggerFunction(functionName, input));
    }

    public void swap(String slotName) {
        Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).ifPresent(r -> r.swap(slotName));
    }

    public void syncTriggers() {
        Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).ifPresent(com.azure.resourcemanager.appservice.models.FunctionApp::syncTriggers);
    }

    @Nonnull
    public Map<String, String> listFunctionKeys(String functionName) {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).map(r -> r.listFunctionKeys(functionName)).orElseGet(HashMap::new);
    }

    @Nonnull
    public FunctionAppDeploymentSlotModule slots() {
        return this.deploymentModule;
    }

    @Nonnull
    public FunctionAppDeploymentSlotModule getDeploymentModule() {
        return this.deploymentModule;
    }
}

