/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.FunctionApps;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAppModule
extends AbstractAzResourceModule<FunctionApp, AppServiceServiceSubscription, WebSiteBase> {
    private static final Logger log;
    public static final String NAME = "sites";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public FunctionAppModule(@Nonnull AppServiceServiceSubscription parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    public FunctionApps getClient() {
        return Optional.ofNullable((AppServiceManager)((AppServiceServiceSubscription)this.parent).getRemote()).map(AppServiceManager::functionApps).orElse(null);
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected FunctionAppDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        String string = name;
        String string2 = resourceGroupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            FunctionAppDraft functionAppDraft = new FunctionAppDraft(name, resourceGroupName, this);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionAppDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected FunctionAppDraft newDraftForUpdate(@Nonnull FunctionApp origin) {
        FunctionApp functionApp = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)((Object)functionApp));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            FunctionAppDraft functionAppDraft = new FunctionAppDraft(origin);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionAppDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected FunctionApp newResource(@Nonnull WebSiteBase remote) {
        return new FunctionApp((FunctionAppBasic)remote, this);
    }

    @Nonnull
    protected FunctionApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new FunctionApp(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Function app";
    }

    @NotNull
    public FunctionApp update(@NotNull AzResource.Draft<FunctionApp, WebSiteBase> draft) {
        log.debug("[{}]:update(draft:{})", (Object)this.getName(), draft);
        FunctionApp resource = (FunctionApp)this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.nonNull((Object)resource) && Objects.nonNull(resource.getRemote())) {
            log.debug("[{}]:update->doModify(draft.updateResourceInAzure({}))", (Object)this.getName(), resource.getRemote());
            resource.doModify(() -> (WebSiteBase)draft.updateResourceInAzure((Object)((WebSiteBase)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)resource.getFullRemote()))), "Updating");
            return resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", draft.getName()));
    }

    static {
        FunctionAppModule.ajc$preClinit();
        log = LoggerFactory.getLogger(FunctionAppModule.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionAppModule.java", FunctionAppModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForCreate", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule", "java.lang.String:java.lang.String", "name:resourceGroupName", "", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForUpdate", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "origin", "", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft"), 54);
    }
}

