/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight;
import com.microsoft.azure.toolkit.lib.applicationinsights.task.GetOrCreateApplicationInsightsTask;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotDraft;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanDraft;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CreateOrUpdateFunctionAppTask
extends AzureTask<FunctionAppBase<?, ?, ?>> {
    public static final String APPINSIGHTS_INSTRUMENTATION_KEY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    private static final String APPLICATION_INSIGHTS_CREATE_FAILED = "Unable to create the Application Insights for the Function App due to error %s. Please use the Azure Portal to manually create and configure the Application Insights if needed.";
    private static final String FUNCTIONS_WORKER_RUNTIME_NAME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String FUNCTIONS_WORKER_RUNTIME_VALUE = "java";
    private static final String SET_FUNCTIONS_WORKER_RUNTIME = "Set function worker runtime to java.";
    private static final String CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING = "App setting `FUNCTIONS_WORKER_RUNTIME` doesn't meet the requirement of Azure Java Functions, the value should be `java`.";
    private static final String FUNCTIONS_EXTENSION_VERSION_NAME = "FUNCTIONS_EXTENSION_VERSION";
    private static final String FUNCTIONS_EXTENSION_VERSION_VALUE = "~3";
    private static final String SET_FUNCTIONS_EXTENSION_VERSION = "Functions extension version isn't configured, setting up the default value.";
    private static final String FUNCTION_APP_NOT_EXIST_FOR_SLOT = "The Function App specified in pom.xml does not exist. Please make sure the Function App name is correct.";
    public static final JavaVersion DEFAULT_FUNCTION_JAVA_VERSION = JavaVersion.JAVA_8;
    private final FunctionAppConfig functionAppConfig;
    private final List<AzureTask<?>> tasks = new ArrayList();
    private ResourceGroup resourceGroup;
    private AppServicePlan appServicePlan;
    private String instrumentationKey;
    private FunctionAppBase<?, ?, ?> functionApp;

    public CreateOrUpdateFunctionAppTask(@Nonnull FunctionAppConfig config) {
        this.functionAppConfig = config;
        this.initTasks();
    }

    private void initTasks() {
        FunctionAppDraft appDraft = (FunctionAppDraft)((AzureFunctions)Azure.az(AzureFunctions.class)).functionApps(this.functionAppConfig.subscriptionId()).updateOrCreate(this.functionAppConfig.appName(), this.functionAppConfig.resourceGroup());
        this.registerSubTask((AzureTask)this.getResourceGroupTask(), result -> {
            this.resourceGroup = result;
        });
        this.registerSubTask(this.getServicePlanTask(), result -> {
            this.appServicePlan = result;
        });
        if (!this.functionAppConfig.disableAppInsights() && !this.functionAppConfig.appSettings().containsKey(APPINSIGHTS_INSTRUMENTATION_KEY)) {
            if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.appInsightsKey())) {
                this.instrumentationKey = this.functionAppConfig.appInsightsKey();
            } else if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.appInsightsInstance()) || !appDraft.exists()) {
                this.registerSubTask(this.getApplicationInsightsTask(), result -> {
                    this.instrumentationKey = Optional.ofNullable(result).map(ApplicationInsight::getInstrumentationKey).orElse(null);
                });
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.functionAppConfig.deploymentSlotName())) {
            AzureTask<FunctionApp> functionTask = appDraft.exists() ? this.getUpdateFunctionAppTask(appDraft) : this.getCreateFunctionAppTask(appDraft);
            this.registerSubTask(functionTask, result -> {
                this.functionApp = result;
            });
        } else {
            FunctionAppDeploymentSlotDraft slotDraft = this.getFunctionDeploymentSlot(appDraft);
            AzureTask<FunctionAppDeploymentSlot> slotTask = slotDraft.exists() ? this.getUpdateFunctionSlotTask(slotDraft) : this.getCreateFunctionSlotTask(slotDraft);
            this.registerSubTask(slotTask, result -> {
                this.functionApp = result;
            });
        }
    }

    private <T> void registerSubTask(AzureTask<T> task, Consumer<T> consumer) {
        if (task != null) {
            this.tasks.add(new AzureTask(() -> {
                Object result = task.getBody().call();
                consumer.accept(result);
                return result;
            }));
        }
    }

    private AzureTask<FunctionApp> getCreateFunctionAppTask(FunctionAppDraft draft) {
        AzureString title = AzureString.format((String)"Create new app({0}) on subscription({1})", (Object[])new Object[]{this.functionAppConfig.appName(), this.functionAppConfig.subscriptionId()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            Optional.ofNullable(this.instrumentationKey).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).ifPresent(key -> appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, (String)key));
            draft.setAppServicePlan(this.appServicePlan);
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setAppSettings(appSettings);
            return (FunctionApp)draft.createIfNotExist();
        });
    }

    private Map<String, String> processAppSettingsWithDefaultValue() {
        Map<String, String> appSettings = this.functionAppConfig.appSettings();
        this.setDefaultAppSetting(appSettings, FUNCTIONS_WORKER_RUNTIME_NAME, SET_FUNCTIONS_WORKER_RUNTIME, FUNCTIONS_WORKER_RUNTIME_VALUE, CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING);
        this.setDefaultAppSetting(appSettings, FUNCTIONS_EXTENSION_VERSION_NAME, SET_FUNCTIONS_EXTENSION_VERSION, FUNCTIONS_EXTENSION_VERSION_VALUE, null);
        return appSettings;
    }

    private void setDefaultAppSetting(Map<String, String> result, String settingName, String settingIsEmptyMessage, String defaultValue, String warningMessage) {
        String setting = result.get(settingName);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            AzureMessager.getMessager().info(settingIsEmptyMessage);
            result.put(settingName, defaultValue);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)setting, (CharSequence)defaultValue) && StringUtils.isNotEmpty((CharSequence)warningMessage)) {
            AzureMessager.getMessager().warning(warningMessage);
        }
    }

    private AzureTask<FunctionApp> getUpdateFunctionAppTask(FunctionAppDraft draft) {
        AzureString title = AzureString.format((String)"Update function app({0})", (Object[])new Object[]{this.functionAppConfig.appName()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            if (this.functionAppConfig.disableAppInsights()) {
                draft.removeAppSetting(APPINSIGHTS_INSTRUMENTATION_KEY);
            } else if (StringUtils.isNotEmpty((CharSequence)this.instrumentationKey)) {
                appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.instrumentationKey);
            }
            draft.setAppServicePlan(this.appServicePlan);
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setAppSettings(appSettings);
            return (FunctionApp)draft.updateIfExist();
        });
    }

    private AzureTask<FunctionAppDeploymentSlot> getCreateFunctionSlotTask(FunctionAppDeploymentSlotDraft draft) {
        AzureString title = AzureString.format((String)"Create new slot({0}) on function app ({1})", (Object[])new Object[]{this.functionAppConfig.deploymentSlotName(), this.functionAppConfig.appName()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            Optional.ofNullable(this.instrumentationKey).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).ifPresent(key -> appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, (String)key));
            draft.setAppSettings(appSettings);
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setConfigurationSource(this.functionAppConfig.deploymentSlotConfigurationSource());
            return (FunctionAppDeploymentSlot)draft.createIfNotExist();
        });
    }

    private AzureTask<FunctionAppDeploymentSlot> getUpdateFunctionSlotTask(FunctionAppDeploymentSlotDraft draft) {
        AzureString title = AzureString.format((String)"Update function deployment slot({0})", (Object[])new Object[]{this.functionAppConfig.deploymentSlotName()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            if (this.functionAppConfig.disableAppInsights()) {
                draft.removeAppSetting(APPINSIGHTS_INSTRUMENTATION_KEY);
            } else if (StringUtils.isNotEmpty((CharSequence)this.instrumentationKey)) {
                appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.instrumentationKey);
            }
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setAppSettings(appSettings);
            return (FunctionAppDeploymentSlot)draft.updateIfExist();
        });
    }

    private FunctionAppDeploymentSlotDraft getFunctionDeploymentSlot(FunctionApp functionApp) {
        if (!functionApp.exists()) {
            throw new AzureToolkitRuntimeException(FUNCTION_APP_NOT_EXIST_FOR_SLOT);
        }
        return (FunctionAppDeploymentSlotDraft)functionApp.slots().updateOrCreate(this.functionAppConfig.deploymentSlotName(), this.functionAppConfig.resourceGroup());
    }

    private AzureTask<ApplicationInsight> getApplicationInsightsTask() {
        return new AzureTask(() -> {
            try {
                String name = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{this.functionAppConfig.appInsightsInstance(), this.functionAppConfig.appName()});
                return (ApplicationInsight)new GetOrCreateApplicationInsightsTask(this.functionAppConfig.subscriptionId(), this.functionAppConfig.resourceGroup(), this.functionAppConfig.region(), name).getBody().call();
            }
            catch (Throwable e) {
                String errorMessage = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)e)).orElse(e).getMessage();
                AzureMessager.getMessager().warning(String.format(APPLICATION_INSIGHTS_CREATE_FAILED, errorMessage));
                return null;
            }
        });
    }

    private CreateResourceGroupTask getResourceGroupTask() {
        return new CreateResourceGroupTask(this.functionAppConfig.subscriptionId(), this.functionAppConfig.resourceGroup(), this.functionAppConfig.region());
    }

    private AzureTask<AppServicePlan> getServicePlanTask() {
        if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.deploymentSlotName())) {
            AzureMessager.getMessager().info("Skip update app service plan for deployment slot");
            return null;
        }
        return new AzureTask(() -> {
            AzureAppService az = (AzureAppService)Azure.az(AzureAppService.class);
            AppServicePlanConfig config = this.functionAppConfig.getServicePlanConfig();
            AppServicePlanDraft draft = (AppServicePlanDraft)az.plans(config.subscriptionId()).updateOrCreate(config.servicePlanName(), config.servicePlanResourceGroup());
            draft.setOperatingSystem(config.os());
            draft.setRegion(config.region());
            draft.setPricingTier(config.pricingTier());
            return (AppServicePlan)draft.commit();
        });
    }

    private Runtime getRuntime(RuntimeConfig runtime) {
        return Runtime.getRuntime(runtime.os(), WebContainer.JAVA_OFF, OperatingSystem.DOCKER != runtime.os() ? runtime.javaVersion() : JavaVersion.OFF);
    }

    private DockerConfiguration getDockerConfiguration(RuntimeConfig runtime) {
        if (OperatingSystem.DOCKER == runtime.os()) {
            return ((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)DockerConfiguration.builder().userName(runtime.username())).password(runtime.password())).registryUrl(runtime.registryUrl())).image(runtime.image())).startUpCommand(runtime.startUpCommand())).build();
        }
        return null;
    }

    public FunctionAppBase<?, ?, ?> doExecute() throws Exception {
        for (AzureTask<?> task : this.tasks) {
            task.getBody().call();
        }
        return this.functionApp;
    }
}

