/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.azure.resourcemanager.appservice.fluent.models.FunctionEnvelopeInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemHttpLogsConfig;
import com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.azure.resourcemanager.appservice.models.FunctionRuntimeStack;
import com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.RuntimeStack;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppDiagnosticLogs;
import com.azure.resourcemanager.appservice.models.WebContainer;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.LogLevel;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AppServiceUtils {
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String ENTRY_POINT = "entryPoint";
    private static final String BINDINGS = "bindings";

    public static Runtime getRuntimeFromAppService(WebAppBase webAppBase) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)webAppBase.linuxFxVersion(), (CharSequence)"docker")) {
            return Runtime.DOCKER;
        }
        return webAppBase.operatingSystem() == OperatingSystem.WINDOWS ? AppServiceUtils.getRuntimeFromWindowsAppService(webAppBase) : AppServiceUtils.getRuntimeFromLinuxAppService(webAppBase);
    }

    private static Runtime getRuntimeFromLinuxAppService(WebAppBase webAppBase) {
        if (StringUtils.isEmpty((CharSequence)webAppBase.linuxFxVersion())) {
            return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.OFF);
        }
        String linuxFxVersion = webAppBase.linuxFxVersion();
        return StringUtils.containsIgnoreCase((CharSequence)((SiteInner)webAppBase.innerModel()).kind(), (CharSequence)"function") ? AppServiceUtils.getRuntimeFromLinuxFunctionApp(linuxFxVersion) : Runtime.getRuntimeFromLinuxFxVersion(linuxFxVersion);
    }

    private static Runtime getRuntimeFromLinuxFunctionApp(String linuxFxVersion) {
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.fromString(linuxFxVersion.replace("|", " "));
        return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF, javaVersion);
    }

    private static Runtime getRuntimeFromWindowsAppService(WebAppBase webAppBase) {
        String javaContainer = String.join((CharSequence)" ", webAppBase.javaContainer(), webAppBase.javaContainerVersion());
        com.microsoft.azure.toolkit.lib.appservice.model.WebContainer webContainer = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{webAppBase.javaContainer(), webAppBase.javaContainerVersion()}) ? com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF : com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.fromString(javaContainer);
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = Optional.ofNullable(webAppBase.javaVersion()).map(version -> com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.fromString(version.toString())).orElse(com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.OFF);
        return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS, webContainer, javaVersion);
    }

    public static RuntimeStack toRuntimeStack(Runtime runtime) {
        return RuntimeStack.getAll().stream().filter(runtimeStack -> {
            String linuxFxVersion = String.format("%s|%s", runtimeStack.stack(), runtimeStack.version());
            Runtime stackRuntime = Runtime.getRuntimeFromLinuxFxVersion(linuxFxVersion);
            return Objects.equals(stackRuntime.getJavaVersion(), runtime.getJavaVersion()) && Objects.equals(stackRuntime.getWebContainer(), runtime.getWebContainer());
        }).findFirst().orElseGet(() -> {
            if (Objects.equals(runtime.getWebContainer(), com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_SE)) {
                return AppServiceUtils.getRuntimeStackForJavaSERuntime(runtime);
            }
            String[] containerInfo = runtime.getWebContainer().getValue().split(" ");
            if (containerInfo.length != 2) {
                throw new AzureToolkitRuntimeException(String.format("Invalid webContainer '%s'.", runtime.getWebContainer()));
            }
            String stack = containerInfo[0].toUpperCase(Locale.ENGLISH);
            String stackVersion = containerInfo[1];
            String javaVersion = AppServiceUtils.getJavaVersionValueForContainerRuntimeStack(runtime.getJavaVersion());
            String version = String.format("%s-%s", stackVersion, javaVersion);
            return new RuntimeStack(stack, version);
        });
    }

    static RuntimeStack getRuntimeStackForJavaSERuntime(Runtime runtime) {
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = runtime.getJavaVersion();
        if (Objects.equals(javaVersion, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_17)) {
            return new RuntimeStack("JAVA", "17-java17");
        }
        return new RuntimeStack("JAVA", AppServiceUtils.getJavaVersionValueForJavaSERuntimeStack(runtime.getJavaVersion()));
    }

    static String getJavaVersionValueForJavaSERuntimeStack(@Nonnull com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion) {
        return javaVersion.getValue().replaceAll("(?i)java|jre", "").trim();
    }

    static String getJavaVersionValueForContainerRuntimeStack(@Nonnull com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion) {
        if (Objects.equals(javaVersion, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_8)) {
            return "jre8";
        }
        if (Objects.equals(javaVersion, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_11)) {
            return "java11";
        }
        if (Objects.equals(javaVersion, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_17)) {
            return "java17";
        }
        if (StringUtils.startsWithAny((CharSequence)javaVersion.getValue().toLowerCase(), (CharSequence[])new CharSequence[]{"java", "jre"})) {
            return javaVersion.getValue();
        }
        return String.format("java%s", javaVersion.getValue());
    }

    public static FunctionRuntimeStack toFunctionRuntimeStack(@Nonnull Runtime runtime, String functionExtensionVersion) {
        if (runtime.getOperatingSystem() != com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX) {
            throw new AzureToolkitRuntimeException(String.format("Can not convert %s runtime to FunctionRuntimeStack", new Object[]{runtime.getOperatingSystem()}));
        }
        String javaVersion = Objects.equals(runtime.getJavaVersion(), com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_8) ? "java|8" : (Objects.equals(runtime.getJavaVersion(), com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_11) ? "java|11" : String.format("java|%s", runtime.getJavaVersion().getValue()));
        return new FunctionRuntimeStack("java", functionExtensionVersion, javaVersion);
    }

    public static WebContainer toWebContainer(Runtime runtime) {
        com.microsoft.azure.toolkit.lib.appservice.model.WebContainer webContainer = runtime.getWebContainer();
        if (webContainer == null || Objects.equals(webContainer, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF)) {
            return null;
        }
        if (Objects.equals(webContainer, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_SE)) {
            return StringUtils.startsWith((CharSequence)runtime.getJavaVersion().getValue(), (CharSequence)com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_8.getValue()) ? WebContainer.JAVA_8 : WebContainer.fromString((String)"java 11");
        }
        return WebContainer.fromString((String)webContainer.getValue());
    }

    public static PublishingProfile fromPublishingProfile(com.azure.resourcemanager.appservice.models.PublishingProfile publishingProfile) {
        return ((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)PublishingProfile.builder().ftpUrl(publishingProfile.ftpUrl())).ftpUsername(publishingProfile.ftpUsername())).ftpPassword(publishingProfile.ftpPassword())).gitUrl(publishingProfile.gitUrl())).gitUsername(publishingProfile.gitUsername())).gitPassword(publishingProfile.gitPassword())).build();
    }

    public static com.azure.resourcemanager.appservice.models.PricingTier toPricingTier(PricingTier pricingTier) {
        SkuDescription skuDescription = new SkuDescription().withTier(pricingTier.getTier()).withSize(pricingTier.getSize());
        return com.azure.resourcemanager.appservice.models.PricingTier.fromSkuDescription((SkuDescription)skuDescription);
    }

    static PricingTier fromPricingTier(@Nonnull com.azure.resourcemanager.appservice.models.PricingTier pricingTier) {
        return PricingTier.fromString(pricingTier.toSkuDescription().tier(), pricingTier.toSkuDescription().size());
    }

    static com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem fromOperatingSystem(OperatingSystem operatingSystem) {
        return com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.fromString(operatingSystem.name());
    }

    public static JavaVersion toJavaVersion(com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion) {
        String value = javaVersion.getValue().replaceFirst("(?i)java|jre", "");
        return JavaVersion.fromString((String)value);
    }

    public static DiagnosticConfig fromWebAppDiagnosticLogs(WebAppDiagnosticLogs webAppDiagnosticLogs) {
        DiagnosticConfig.DiagnosticConfigBuilder builder = DiagnosticConfig.builder();
        com.azure.resourcemanager.appservice.models.LogLevel applicationLogLevel = Optional.ofNullable(webAppDiagnosticLogs).map(HasInnerModel::innerModel).map(SiteLogsConfigInner::applicationLogs).map(ApplicationLogsConfig::fileSystem).map(FileSystemApplicationLogsConfig::level).orElse(null);
        if (applicationLogLevel != null && applicationLogLevel != com.azure.resourcemanager.appservice.models.LogLevel.OFF) {
            builder.enableApplicationLog(true).applicationLogLevel(LogLevel.fromString(applicationLogLevel.toString()));
        } else {
            builder.enableApplicationLog(false);
        }
        FileSystemHttpLogsConfig httpLogsConfig = Optional.ofNullable(webAppDiagnosticLogs).map(HasInnerModel::innerModel).map(SiteLogsConfigInner::httpLogs).map(HttpLogsConfig::fileSystem).orElse(null);
        if (httpLogsConfig != null && httpLogsConfig.enabled().booleanValue()) {
            builder.enableWebServerLogging(true).webServerLogQuota(httpLogsConfig.retentionInMb()).webServerRetentionPeriod(httpLogsConfig.retentionInDays()).enableDetailedErrorMessage(webAppDiagnosticLogs.detailedErrorMessages()).enableFailedRequestTracing(webAppDiagnosticLogs.failedRequestsTracing());
        } else {
            builder.enableWebServerLogging(false);
        }
        return builder.build();
    }

    public static <T extends WebAppBase> void defineDiagnosticConfigurationForWebAppBase(WebAppBase.DefinitionStages.WithCreate<T> withCreate, DiagnosticConfig diagnosticConfig) {
        if (diagnosticConfig.isEnableApplicationLog()) {
            withCreate.defineDiagnosticLogsConfiguration().withApplicationLogging().withLogLevel(com.azure.resourcemanager.appservice.models.LogLevel.fromString((String)diagnosticConfig.getApplicationLogLevel().getValue())).withApplicationLogsStoredOnFileSystem().attach();
        }
        if (diagnosticConfig.isEnableWebServerLogging()) {
            withCreate.defineDiagnosticLogsConfiguration().withWebServerLogging().withWebServerLogsStoredOnFileSystem().withWebServerFileSystemQuotaInMB(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerLogQuota(), 0})).intValue()).withLogRetentionDays(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerRetentionPeriod(), 0})).intValue()).withDetailedErrorMessages(diagnosticConfig.isEnableDetailedErrorMessage()).withFailedRequestTracing(diagnosticConfig.isEnableFailedRequestTracing()).attach();
        }
    }

    public static <T extends WebAppBase> void updateDiagnosticConfigurationForWebAppBase(WebAppBase.Update<T> update, DiagnosticConfig diagnosticConfig) {
        WebAppDiagnosticLogs.UpdateStages.Blank blank = update.updateDiagnosticLogsConfiguration();
        if (diagnosticConfig.isEnableApplicationLog()) {
            blank.withApplicationLogging().withLogLevel(com.azure.resourcemanager.appservice.models.LogLevel.fromString((String)diagnosticConfig.getApplicationLogLevel().getValue())).withApplicationLogsStoredOnFileSystem().parent();
        } else {
            blank.withoutApplicationLogging().parent();
        }
        if (diagnosticConfig.isEnableWebServerLogging()) {
            blank.withWebServerLogging().withWebServerLogsStoredOnFileSystem().withWebServerFileSystemQuotaInMB(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerLogQuota(), 0})).intValue()).withLogRetentionDays(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerRetentionPeriod(), 0})).intValue()).withDetailedErrorMessages(diagnosticConfig.isEnableDetailedErrorMessage()).withFailedRequestTracing(diagnosticConfig.isEnableFailedRequestTracing()).parent();
        } else {
            blank.withoutWebServerLogging().parent();
        }
    }

    public static FunctionEntity fromFunctionAppEnvelope(@Nonnull FunctionEnvelope functionEnvelope, @Nonnull String functionId) {
        Object config = functionEnvelope.config();
        if (!(config instanceof Map)) {
            return null;
        }
        Map envelopeConfigMap = (Map)config;
        String scriptFile = (String)envelopeConfigMap.get(SCRIPT_FILE);
        String entryPoint = (String)envelopeConfigMap.get(ENTRY_POINT);
        Object bindingListObject = envelopeConfigMap.get(BINDINGS);
        List<FunctionEntity.BindingEntity> bindingEntities = Optional.ofNullable(bindingListObject instanceof List ? (List)bindingListObject : null).map(list -> list.stream().filter(item -> item instanceof Map).map(map -> AppServiceUtils.fromJsonBinding((Map)map)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return ((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)FunctionEntity.builder().name(AppServiceUtils.getFunctionTriggerName(functionEnvelope))).entryPoint(entryPoint)).scriptFile(scriptFile)).bindingList(bindingEntities)).functionAppId(functionId)).triggerId(((FunctionEnvelopeInner)functionEnvelope.innerModel()).id())).triggerUrl(((FunctionEnvelopeInner)functionEnvelope.innerModel()).invokeUrlTemplate())).build();
    }

    private static String getFunctionTriggerName(@Nonnull FunctionEnvelope functionEnvelope) {
        String fullName = ((FunctionEnvelopeInner)functionEnvelope.innerModel()).name();
        String[] splitNames = fullName.split("/");
        return splitNames.length > 1 ? splitNames[1] : fullName;
    }

    private static FunctionEntity.BindingEntity fromJsonBinding(Map<String, String> bindingProperties) {
        return ((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)FunctionEntity.BindingEntity.builder().type(bindingProperties.get("type"))).direction(bindingProperties.get("direction"))).name(bindingProperties.get("name"))).properties(bindingProperties)).build();
    }
}

