/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.config;

import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AppServiceConfig {
    private String subscriptionId;
    private String resourceGroup;
    private Region region;
    private PricingTier pricingTier;
    private String appName;
    private String servicePlanResourceGroup;
    private String servicePlanName;
    private RuntimeConfig runtime;
    private Map<String, String> appSettings;
    private Set<String> appSettingsToRemove;
    private String deploymentSlotName;
    private String deploymentSlotConfigurationSource;
    private DiagnosticConfig diagnosticConfig;

    public AppServicePlanConfig getServicePlanConfig() {
        return AppServicePlanConfig.builder().subscriptionId(this.subscriptionId()).resourceGroupName(this.servicePlanResourceGroup()).name(this.servicePlanName()).region(this.region()).os(this.runtime().os()).pricingTier(this.pricingTier()).build();
    }

    public static AppServiceConfig buildDefaultWebAppConfig(String resourceGroup, String appName, String packaging, JavaVersion javaVersion) {
        RuntimeConfig runtimeConfig = new RuntimeConfig().os(OperatingSystem.LINUX).webContainer(StringUtils.equalsIgnoreCase((CharSequence)packaging, (CharSequence)"war") ? WebContainer.TOMCAT_85 : (StringUtils.equalsIgnoreCase((CharSequence)packaging, (CharSequence)"ear") ? WebContainer.JBOSS_7 : WebContainer.JAVA_SE)).javaVersion(javaVersion);
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultAppServiceConfig(resourceGroup, appName);
        appServiceConfig.runtime(runtimeConfig);
        return appServiceConfig;
    }

    public static AppServiceConfig buildDefaultFunctionConfig(String resourceGroup, String appName, JavaVersion javaVersion) {
        RuntimeConfig runtimeConfig = new RuntimeConfig().os(OperatingSystem.WINDOWS).webContainer(WebContainer.JAVA_OFF).javaVersion(javaVersion);
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultAppServiceConfig(resourceGroup, appName);
        appServiceConfig.runtime(runtimeConfig);
        appServiceConfig.pricingTier(PricingTier.CONSUMPTION);
        return appServiceConfig;
    }

    @Nonnull
    private static AppServiceConfig buildDefaultAppServiceConfig(String resourceGroup, String appName) {
        AppServiceConfig appServiceConfig = new AppServiceConfig();
        appServiceConfig.region(Region.US_CENTRAL);
        appServiceConfig.resourceGroup(resourceGroup);
        appServiceConfig.appName(appName);
        appServiceConfig.servicePlanResourceGroup(resourceGroup);
        appServiceConfig.servicePlanName(String.format("asp-%s", appName));
        return appServiceConfig;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Region region() {
        return this.region;
    }

    public PricingTier pricingTier() {
        return this.pricingTier;
    }

    public String appName() {
        return this.appName;
    }

    public String servicePlanResourceGroup() {
        return this.servicePlanResourceGroup;
    }

    public String servicePlanName() {
        return this.servicePlanName;
    }

    public RuntimeConfig runtime() {
        return this.runtime;
    }

    public Map<String, String> appSettings() {
        return this.appSettings;
    }

    public Set<String> appSettingsToRemove() {
        return this.appSettingsToRemove;
    }

    public String deploymentSlotName() {
        return this.deploymentSlotName;
    }

    public String deploymentSlotConfigurationSource() {
        return this.deploymentSlotConfigurationSource;
    }

    public DiagnosticConfig diagnosticConfig() {
        return this.diagnosticConfig;
    }

    public AppServiceConfig subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public AppServiceConfig resourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public AppServiceConfig region(Region region) {
        this.region = region;
        return this;
    }

    public AppServiceConfig pricingTier(PricingTier pricingTier) {
        this.pricingTier = pricingTier;
        return this;
    }

    public AppServiceConfig appName(String appName) {
        this.appName = appName;
        return this;
    }

    public AppServiceConfig servicePlanResourceGroup(String servicePlanResourceGroup) {
        this.servicePlanResourceGroup = servicePlanResourceGroup;
        return this;
    }

    public AppServiceConfig servicePlanName(String servicePlanName) {
        this.servicePlanName = servicePlanName;
        return this;
    }

    public AppServiceConfig runtime(RuntimeConfig runtime) {
        this.runtime = runtime;
        return this;
    }

    public AppServiceConfig appSettings(Map<String, String> appSettings) {
        this.appSettings = appSettings;
        return this;
    }

    public AppServiceConfig appSettingsToRemove(Set<String> appSettingsToRemove) {
        this.appSettingsToRemove = appSettingsToRemove;
        return this;
    }

    public AppServiceConfig deploymentSlotName(String deploymentSlotName) {
        this.deploymentSlotName = deploymentSlotName;
        return this;
    }

    public AppServiceConfig deploymentSlotConfigurationSource(String deploymentSlotConfigurationSource) {
        this.deploymentSlotConfigurationSource = deploymentSlotConfigurationSource;
        return this;
    }

    public AppServiceConfig diagnosticConfig(DiagnosticConfig diagnosticConfig) {
        this.diagnosticConfig = diagnosticConfig;
        return this;
    }
}

