/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.toolkit.lib.appservice.deploy.DeployUtils;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.AzureStorageHelper;
import java.io.File;
import java.net.URISyntaxException;
import java.time.Period;
import org.apache.commons.lang3.StringUtils;

public class RunFromBlobFunctionDeployHandler
implements IFunctionDeployHandler {
    private static final int SAS_EXPIRE_DATE_BY_YEAR = 10;
    private static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-run-from-packages";
    private static final String FAILED_TO_GET_FUNCTION_APP_ARTIFACT_CONTAINER = "Failed to get Function App artifact container";
    private static final String UPDATE_ACCESS_LEVEL_TO_PRIVATE = "The blob container '%s' access level was updated to be private";

    @Override
    public void deploy(File file, WebAppBase target) {
        CloudStorageAccount storageAccount = DeployUtils.getCloudStorageAccount(target);
        try {
            CloudBlockBlob blob = this.deployArtifactToAzureStorage(target, file, storageAccount);
            String sasToken = AzureStorageHelper.getSASToken((CloudBlob)blob, Period.ofYears(10));
            DeployUtils.updateFunctionAppSetting(target, "WEBSITE_RUN_FROM_PACKAGE", sasToken);
        }
        catch (AzureExecutionException e) {
            throw new AzureToolkitRuntimeException("Failed to upload package to azure storage", (Throwable)e);
        }
    }

    private CloudBlockBlob deployArtifactToAzureStorage(WebAppBase deployTarget, File zipPackage, CloudStorageAccount storageAccount) throws AzureExecutionException {
        AzureMessager.getMessager().info(String.format("Trying to deploy artifact to %s...", deployTarget.name()));
        CloudBlobContainer container = this.getOrCreateArtifactContainer(storageAccount);
        String blobName = this.getBlobName(deployTarget, zipPackage);
        CloudBlockBlob blob = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, container.getName(), blobName, BlobContainerPublicAccessType.OFF);
        AzureMessager.getMessager().info(String.format("Successfully deployed the artifact to https://%s", deployTarget.defaultHostname()));
        return blob;
    }

    private CloudBlobContainer getOrCreateArtifactContainer(CloudStorageAccount storageAccount) {
        CloudBlobClient blobContainer = storageAccount.createCloudBlobClient();
        try {
            CloudBlobContainer container = blobContainer.getContainerReference(DEPLOYMENT_PACKAGE_CONTAINER);
            if (!container.exists()) {
                container.createIfNotExists(BlobContainerPublicAccessType.OFF, null, null);
            } else {
                this.updateContainerPublicAccessLevel(container);
            }
            return container;
        }
        catch (StorageException | URISyntaxException e) {
            throw new AzureToolkitRuntimeException(FAILED_TO_GET_FUNCTION_APP_ARTIFACT_CONTAINER, e);
        }
    }

    private void updateContainerPublicAccessLevel(CloudBlobContainer container) throws StorageException {
        BlobContainerPermissions permissions = container.downloadPermissions();
        if (permissions.getPublicAccess() == BlobContainerPublicAccessType.OFF) {
            return;
        }
        permissions.setPublicAccess(BlobContainerPublicAccessType.OFF);
        container.uploadPermissions(permissions);
        AzureMessager.getMessager().info(String.format(UPDATE_ACCESS_LEVEL_TO_PRIVATE, DEPLOYMENT_PACKAGE_CONTAINER));
    }

    private String getBlobName(WebAppBase deployTarget, File zipPackage) {
        String fixedResourceId = StringUtils.replace((String)deployTarget.id(), (String)"/", (String)"-").replaceFirst("-", "");
        return String.format("%s-%s", fixedResourceId, zipPackage.getName());
    }
}

