/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.azure.core.management.exception.ManagementException;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.zeroturnaround.zip.ZipUtil;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class DeployFunctionAppTask
extends AzureTask<FunctionAppBase<?, ?, ?>> {
    private static final int SYNC_FUNCTION_MAX_ATTEMPTS = 5;
    private static final int SYNC_FUNCTION_DELAY = 1;
    private static final int LIST_TRIGGERS_MAX_RETRY = 5;
    private static final int LIST_TRIGGERS_RETRY_PERIOD_IN_SECONDS = 10;
    private static final String RUNNING = "Running";
    private static final String AUTH_LEVEL = "authLevel";
    private static final String HTTP_TRIGGER = "httpTrigger";
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";
    private static final String DEPLOY_START = "Starting deployment...";
    private static final String DEPLOY_FINISH = "Deployment done, you may access your resource through %s";
    private static final String HTTP_TRIGGER_URLS = "HTTP Trigger Urls:";
    private static final String NO_ANONYMOUS_HTTP_TRIGGER = "No anonymous HTTP Triggers found in deployed function app, skip list triggers.";
    private static final String NO_TRIGGERS_FOUNDED = "No triggers found in deployed function app, please try recompile the project by `mvn clean package` and deploy again.";
    private static final String UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS = "Some http trigger urls cannot be displayed because they are non-anonymous. To access the non-anonymous triggers, please refer to https://aka.ms/azure-functions-key.";
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker app service";
    private static final String FAILED_TO_LIST_TRIGGERS = "Deployment succeeded, but failed to list http trigger urls.";
    private static final String SYNC_TRIGGERS = "Syncing triggers and fetching function information";
    private static final String LIST_TRIGGERS = "Querying triggers...";
    private static final String LIST_TRIGGERS_WITH_RETRY = "Querying triggers (Attempt {0}/{1})...";
    private final FunctionAppBase<?, ?, ?> target;
    private final File stagingDirectory;
    private final FunctionDeployType deployType;
    private final IAzureMessager messager;

    public DeployFunctionAppTask(@Nonnull FunctionAppBase<?, ?, ?> target, @Nonnull File stagingFolder, @Nullable FunctionDeployType deployType) {
        this(target, stagingFolder, deployType, AzureMessager.getMessager());
    }

    public DeployFunctionAppTask(@Nonnull FunctionAppBase<?, ?, ?> target, @Nonnull File stagingFolder, @Nullable FunctionDeployType deployType, @Nonnull IAzureMessager messager) {
        this.target = target;
        this.stagingDirectory = stagingFolder;
        this.deployType = deployType;
        this.messager = messager;
    }

    public AzureString getDescription() {
        return AzureString.format((String)"Deploy artifact to function app %s", (Object[])new Object[]{this.target.getName()});
    }

    public FunctionAppBase<?, ?, ?> doExecute() {
        if (Objects.requireNonNull(this.target.getRuntime()).isDocker()) {
            this.messager.info(SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE);
            return this.target;
        }
        this.deployArtifact();
        if (this.target instanceof FunctionApp) {
            this.listHTTPTriggerUrls((FunctionApp)this.target);
        }
        return this.target;
    }

    private void deployArtifact() {
        this.messager.info(DEPLOY_START);
        File file = this.deployType == FunctionDeployType.FTP ? this.stagingDirectory : this.packageStagingDirectory();
        long startTime = System.currentTimeMillis();
        if (this.deployType == null) {
            this.target.deploy(file);
        } else {
            this.target.deploy(file, this.deployType);
        }
        OperationContext.action().setTelemetryProperty("deploy-cost", String.valueOf(System.currentTimeMillis() - startTime));
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.target.getStatus(), (CharSequence)RUNNING)) {
            this.target.start();
        }
        this.messager.info(String.format(DEPLOY_FINISH, this.target.getHostName()));
    }

    private File packageStagingDirectory() {
        try {
            File zipFile = Files.createTempFile("azure-functions", ".zip", new FileAttribute[0]).toFile();
            ZipUtil.pack((File)this.stagingDirectory, (File)zipFile);
            ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
            return zipFile;
        }
        catch (IOException e) {
            throw new AzureToolkitRuntimeException("Failed to package function to deploy", (Throwable)e);
        }
    }

    private void listHTTPTriggerUrls(FunctionApp target) {
        try {
            this.syncTriggers(target);
            List<FunctionEntity> triggers = this.listFunctions(target);
            List httpFunction = triggers.stream().filter(function -> function.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)function.getTrigger().getType(), (CharSequence)HTTP_TRIGGER)).collect(Collectors.toList());
            List<FunctionEntity> anonymousTriggers = httpFunction.stream().filter(bindingResource -> bindingResource.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)bindingResource.getTrigger().getProperty(AUTH_LEVEL), (CharSequence)"ANONYMOUS")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(httpFunction) || CollectionUtils.isEmpty(anonymousTriggers)) {
                this.messager.info(NO_ANONYMOUS_HTTP_TRIGGER);
                return;
            }
            this.messager.info(HTTP_TRIGGER_URLS);
            anonymousTriggers.forEach(trigger -> this.messager.info(String.format("\t %s : %s", trigger.getName(), trigger.getTriggerUrl())));
            if (anonymousTriggers.size() < httpFunction.size()) {
                this.messager.info(UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS);
            }
        }
        catch (InterruptedException | RuntimeException e) {
            this.messager.warning(FAILED_TO_LIST_TRIGGERS);
        }
    }

    private void syncTriggers(FunctionApp functionApp) throws InterruptedException {
        this.messager.info(SYNC_TRIGGERS);
        Thread.sleep(5000L);
        Mono.fromRunnable(() -> {
            block2: {
                try {
                    functionApp.syncTriggers();
                }
                catch (ManagementException e) {
                    if (e.getResponse().getStatusCode() == 200) break block2;
                    throw e;
                }
            }
        }).subscribeOn(Schedulers.boundedElastic()).retryWhen((Retry)Retry.fixedDelay((long)4L, (Duration)Duration.ofSeconds(1L))).block();
    }

    private List<FunctionEntity> listFunctions(FunctionApp functionApp) {
        int[] count = new int[]{0};
        return (List)Mono.fromCallable(() -> {
            int n = count[0];
            count[0] = n + 1;
            AzureString message = n == 0 ? AzureString.fromString((String)LIST_TRIGGERS) : AzureString.format((String)LIST_TRIGGERS_WITH_RETRY, (Object[])new Object[]{count[0], 5});
            this.messager.info(message);
            return Optional.of(functionApp.listFunctions(new boolean[0])).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new AzureToolkitRuntimeException(NO_TRIGGERS_FOUNDED));
        }).subscribeOn(Schedulers.boundedElastic()).retryWhen((Retry)Retry.fixedDelay((long)4L, (Duration)Duration.ofSeconds(10L))).block();
    }
}

