/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureWebApp
extends AzureAppService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Nonnull
    public WebAppModule webApps(@Nonnull String subscriptionId) {
        AppServiceServiceSubscription rm = (AppServiceServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getWebAppModule();
    }

    @Nonnull
    public List<WebApp> webApps() {
        return this.list().stream().flatMap(m -> m.webApps().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public WebApp webApp(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (WebApp)this.webApps(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    @AzureOperation(name="webapp.list_runtimes.os|version", params={"os.getValue()", "version.getValue()"}, type=AzureOperation.Type.REQUEST)
    public List<Runtime> listWebAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        OperatingSystem operatingSystem = os;
        JavaVersion javaVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)((Object)operatingSystem), (Object)javaVersion);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<Runtime> list = Runtime.WEBAPP_RUNTIME.stream().filter(runtime -> Objects.equals((Object)os, (Object)runtime.getOperatingSystem()) && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    protected AppServiceServiceSubscription newResource(@Nonnull AppServiceManager remote) {
        return new WebAppServiceSubscription(remote, (AzureAppService)this);
    }

    static {
        AzureWebApp.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureWebApp.java", AzureWebApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listWebAppRuntimes", "com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp", "com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem:com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion", "os:version", "", "java.util.List"), 46);
    }
}

