/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.appservice.model.CsmDeploymentStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployOptions;
import com.microsoft.azure.toolkit.lib.appservice.model.DeploymentBuildStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.ErrorEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DeployWebAppTask
extends AzureTask<WebAppBase<?, ?, ?>> {
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker webapp, you can navigate to %s to access your docker webapp.";
    private static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    private static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    private static final String START_APP = "Starting Web App after deploying artifacts...";
    private static final String START_APP_DONE = "Successfully started Web App.";
    private static final int DEFAULT_DEPLOYMENT_STATUS_REFRESH_INTERVAL = 10;
    private static final int DEFAULT_DEPLOYMENT_STATUS_MAX_REFRESH_TIMES = 20;
    private final WebAppBase<?, ?, ?> webApp;
    private final List<WebAppArtifact> artifacts;
    private final boolean restartSite;
    private final Boolean waitDeploymentComplete;
    private final IAzureMessager messager;
    private long deploymentStatusRefreshInterval = 10L;
    private long deploymentStatusMaxRefreshTimes = 20L;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts) {
        this(webApp, artifacts, false);
    }

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts, boolean restartSite) {
        this(webApp, artifacts, restartSite, null);
    }

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts, boolean restartSite, Boolean waitDeploymentComplete) {
        this.webApp = webApp;
        this.artifacts = artifacts;
        this.restartSite = restartSite;
        this.waitDeploymentComplete = waitDeploymentComplete;
        this.messager = AzureMessager.getMessager();
    }

    @AzureOperation(name="internal/webapp.deploy_app.app", params={"this.webApp.getName()"})
    public WebAppBase<?, ?, ?> doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            WebAppBase<?, ?, ?> webAppBase;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.webApp.getRuntime().isDocker()) {
                this.messager.info(AzureString.format((String)SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE, (Object[])new Object[]{"https://" + this.webApp.getHostName()}));
                webAppBase = this.webApp;
            } else {
                this.messager.info(String.format(DEPLOY_START, this.webApp.getName()));
                this.deployArtifacts();
                this.messager.info(String.format(DEPLOY_FINISH, this.webApp.getHostName()));
                DeployWebAppTask.startAppService(this.webApp);
                webAppBase = this.webApp;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppBase;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void deployArtifacts() {
        if (this.artifacts.stream().anyMatch(artifact -> artifact.getDeployType() == null)) {
            throw new AzureToolkitRuntimeException("missing deployment type for some artifacts.");
        }
        long startTime = System.currentTimeMillis();
        List<WebAppArtifact> artifactsOneDeploy = this.artifacts.stream().filter(artifact -> artifact.getDeployType() != null).collect(Collectors.toList());
        if (this.isWaitDeploymentComplete()) {
            AtomicReference<KuduDeploymentResult> reference = new AtomicReference<KuduDeploymentResult>();
            artifactsOneDeploy.forEach(resource -> reference.set(this.webApp.pushDeploy(resource.getDeployType(), resource.getFile(), DeployOptions.builder().path(resource.getPath()).restartSite(this.restartSite).trackDeployment(true).build())));
            this.trackDeployment(this.webApp, reference);
        } else {
            artifactsOneDeploy.forEach(resource -> this.webApp.deploy(resource.getDeployType(), resource.getFile(), DeployOptions.builder().path(resource.getPath()).restartSite(this.restartSite).build()));
        }
        OperationContext.action().setTelemetryProperty("deploy-cost", String.valueOf(System.currentTimeMillis() - startTime));
    }

    private boolean isWaitDeploymentComplete() {
        if (this.webApp.getFormalStatus().isStopped()) {
            this.messager.info("Skip waiting deployment status for stopped web app.");
            return false;
        }
        if (this.webApp.getRuntime().isWindows() && BooleanUtils.isTrue((Boolean)this.waitDeploymentComplete)) {
            this.messager.warning("`waitDeploymentComplete` is not supported in Windows runtime, skip waiting for deployment status.");
            return false;
        }
        return Optional.ofNullable(this.waitDeploymentComplete).orElseGet(() -> this.webApp.getRuntime().isLinux());
    }

    private void trackDeployment(WebAppBase<?, ?, ?> target, AtomicReference<KuduDeploymentResult> resultReference) {
        KuduDeploymentResult kuduDeploymentResult = resultReference.get();
        if (kuduDeploymentResult == null) {
            return;
        }
        CsmDeploymentStatus status = (CsmDeploymentStatus)Mono.fromCallable(() -> this.getDeploymentStatus(target, kuduDeploymentResult)).delayElement(Duration.ofSeconds(this.deploymentStatusRefreshInterval)).subscribeOn(Schedulers.boundedElastic()).repeat(this.deploymentStatusMaxRefreshTimes).takeUntil(csmDeploymentStatus -> !csmDeploymentStatus.getStatus().isRunning()).blockLast();
        DeploymentBuildStatus buildStatus = status.getStatus();
        if (buildStatus.isTimeout()) {
            this.messager.warning("Resource deployed, but failed to get the deployment status as timeout");
        } else if (buildStatus.isRunning()) {
            this.messager.warning("Resource deployed, but the deployment is still in process in Azure");
        } else if (buildStatus.isFailed()) {
            String errorMessages = CollectionUtils.isNotEmpty(status.getErrors()) ? status.getErrors().stream().map(ErrorEntity::getMessage).collect(Collectors.joining("\n")) : "";
            String failedInstancesLogs = CollectionUtils.isEmpty(status.getFailedInstancesLogs()) ? StringUtils.join(status.getFailedInstancesLogs(), (String)"\n") : "";
            throw new AzureToolkitRuntimeException(String.format("Failed to deploy the artifact to %s. %s %s", target.getName(), errorMessages, failedInstancesLogs));
        }
    }

    private CsmDeploymentStatus getDeploymentStatus(WebAppBase<?, ?, ?> target, KuduDeploymentResult result) {
        CsmDeploymentStatus deploymentStatus = target.getDeploymentStatus(result.getDeploymentId());
        if (Objects.isNull(deploymentStatus)) {
            return null;
        }
        String statusMessage = String.format("Deployment Status: %s; Successful Instance Count: %s; In-progress Instance Count: %s; Failed Instance Count: %s", deploymentStatus.getStatus().getValue(), deploymentStatus.getNumberOfInstancesSuccessful(), deploymentStatus.getNumberOfInstancesInProgress(), deploymentStatus.getNumberOfInstancesFailed());
        this.messager.info(statusMessage);
        return deploymentStatus;
    }

    private static void startAppService(WebAppBase<?, ?, ?> target) {
        if (!target.getFormalStatus().isRunning()) {
            AzureMessager.getMessager().info(START_APP);
            target.start();
            AzureMessager.getMessager().info(START_APP_DONE);
        }
    }

    public void setDeploymentStatusRefreshInterval(long deploymentStatusRefreshInterval) {
        this.deploymentStatusRefreshInterval = deploymentStatusRefreshInterval;
    }

    public void setDeploymentStatusMaxRefreshTimes(long deploymentStatusMaxRefreshTimes) {
        this.deploymentStatusMaxRefreshTimes = deploymentStatusMaxRefreshTimes;
    }

    static {
        DeployWebAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployWebAppTask.java", DeployWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase"), 76);
    }
}

