/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.FunctionApps;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAppModule
extends AbstractAzResourceModule<FunctionApp, AppServiceServiceSubscription, WebSiteBase> {
    private static final Logger log = LoggerFactory.getLogger(FunctionAppModule.class);
    public static final String NAME = "sites";

    public FunctionAppModule(@Nonnull AppServiceServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    public FunctionApps getClient() {
        return Optional.ofNullable((AppServiceManager)((AppServiceServiceSubscription)this.parent).getRemote(new boolean[0])).map(AppServiceManager::functionApps).orElse(null);
    }

    @Nonnull
    protected FunctionAppDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        return new FunctionAppDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected FunctionAppDraft newDraftForUpdate(@Nonnull FunctionApp origin) {
        return new FunctionAppDraft(origin);
    }

    @Nonnull
    protected FunctionApp newResource(@Nonnull WebSiteBase remote) {
        return new FunctionApp((FunctionAppBasic)remote, this);
    }

    @Nonnull
    protected FunctionApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new FunctionApp(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Function app";
    }

    @Nonnull
    public FunctionApp update(@Nonnull AzResource.Draft<FunctionApp, ?> d) {
        AzResource.Draft draft = (AzResource.Draft)this.cast(d);
        log.debug("[{}]:update(draft:{})", (Object)this.getName(), (Object)draft);
        FunctionApp resource = (FunctionApp)this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.nonNull((Object)resource) && Objects.nonNull(resource.getRemote(new boolean[0]))) {
            log.debug("[{}]:update->doModify(draft.updateResourceInAzure({}))", (Object)this.getName(), resource.getRemote(new boolean[0]));
            resource.doModify(() -> (WebSiteBase)draft.updateResourceInAzure((Object)((WebSiteBase)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)resource.getFullRemote()))), "Updating");
            return resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", draft.getName()));
    }
}

