/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class WebAppDraft
extends WebApp
implements AzResource.Draft<WebApp, WebSiteBase> {
    public static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system for existing app service";
    public static final Runtime DEFAULT_RUNTIME;
    @Nullable
    private final WebApp origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    WebAppDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull WebAppModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    WebAppDraft(@Nonnull WebApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Nonnull
    @AzureOperation(name="azure/webapp.create_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appservice.models.WebApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            WebApp.DefinitionStages.WithCreate withCreate;
            OperatingSystem os;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String name = this.getName();
            Runtime newRuntime = Objects.requireNonNull(this.getRuntime(), "'runtime' is required to create Azure Web App");
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan = Objects.requireNonNull(this.getAppServicePlan(), "'service plan' is required to create Azure Web App");
            OperatingSystem operatingSystem = os = newRuntime.isDocker() ? OperatingSystem.LINUX : newRuntime.getOperatingSystem();
            if (!Objects.equals((Object)os, (Object)newPlan.getOperatingSystem())) {
                throw new AzureToolkitRuntimeException(String.format("Could not create %s app service in %s service plan", new Object[]{newRuntime.getOperatingSystem(), newPlan.getOperatingSystem()}));
            }
            Map<String, String> newAppSettings = this.getAppSettings();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            AppServiceManager manager = Objects.requireNonNull((AppServiceManager)((AppServiceServiceSubscription)this.getParent()).getRemote(new boolean[0]));
            WebApp.DefinitionStages.Blank blank = (WebApp.DefinitionStages.Blank)manager.webApps().define(name);
            if (newRuntime.getOperatingSystem() == OperatingSystem.LINUX) {
                withCreate = blank.withExistingLinuxPlan((AppServicePlan)newPlan.getRemote(new boolean[0])).withExistingResourceGroup(this.getResourceGroupName()).withBuiltInImage(AppServiceUtils.toRuntimeStack(newRuntime));
            } else if (newRuntime.getOperatingSystem() == OperatingSystem.WINDOWS) {
                withCreate = (WebApp.DefinitionStages.WithCreate)blank.withExistingWindowsPlan((AppServicePlan)newPlan.getRemote(new boolean[0])).withExistingResourceGroup(this.getResourceGroupName()).withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(AppServiceUtils.toWebContainer(newRuntime));
            } else if (newRuntime.getOperatingSystem() == OperatingSystem.DOCKER) {
                withCreate = this.createDockerWebApp(blank, newPlan);
            } else {
                throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
            }
            if (MapUtils.isNotEmpty(newAppSettings)) {
                withCreate.withAppSettings(newAppSettings);
            }
            if (Objects.nonNull(newDiagnosticConfig)) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, newDiagnosticConfig);
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Web App({0})...", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.WebApp webApp = (com.azure.resourcemanager.appservice.models.WebApp)Objects.requireNonNull((WebSiteBase)this.doModify(() -> (WebSiteBase)withCreate.create(), "Creating"));
            messager.success(AzureString.format((String)"Web App({0}) is successfully created", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.WebApp webApp2 = webApp;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    WebApp.DefinitionStages.WithCreate createDockerWebApp(@Nonnull WebApp.DefinitionStages.Blank blank, @Nonnull com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
        String message = "Docker configuration is required to create a docker based Azure Web App";
        DockerConfiguration config = Objects.requireNonNull(this.getDockerConfiguration(), "Docker configuration is required to create a docker based Azure Web App");
        WebApp.DefinitionStages.WithLinuxAppFramework withLinuxAppFramework = blank.withExistingLinuxPlan((AppServicePlan)plan.getRemote(new boolean[0])).withExistingResourceGroup(this.getResourceGroupName());
        WebApp.DefinitionStages.WithStartUpCommand draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{config.getUserName(), config.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(config.getImage()) : (StringUtils.isEmpty((CharSequence)config.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(config.getImage()).withCredentials(config.getUserName(), config.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(config.getImage(), config.getRegistryUrl()).withCredentials(config.getUserName(), config.getPassword()));
        return draft.withStartUpCommand(config.getStartUpCommand());
    }

    @Nonnull
    @AzureOperation(name="azure/webapp.update_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appservice.models.WebApp updateResourceInAzure(@Nonnull WebSiteBase base) {
        WebSiteBase webSiteBase = base;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)webSiteBase);
        try {
            boolean modified;
            Map<String, String> settingsToAdd;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            com.azure.resourcemanager.appservice.models.WebApp remote = (com.azure.resourcemanager.appservice.models.WebApp)base;
            assert (this.origin != null) : "updating target is not specified.";
            Map<String, String> oldAppSettings = Objects.requireNonNull(this.origin.getAppSettings());
            if (ObjectUtils.allNotNull((Object[])new Object[]{oldAppSettings, settingsToAdd = this.ensureConfig().getAppSettings()})) {
                settingsToAdd.entrySet().removeAll(oldAppSettings.entrySet());
            }
            Set settingsToRemove = Optional.ofNullable(this.ensureConfig().getAppSettingsToRemove()).map(set -> set.stream().filter(key -> oldAppSettings.containsKey(key)).collect(Collectors.toSet())).orElse(Collections.emptySet());
            DiagnosticConfig newDiagnosticConfig = this.ensureConfig().getDiagnosticConfig();
            Runtime newRuntime = this.ensureConfig().getRuntime();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan = this.ensureConfig().getPlan();
            DockerConfiguration newDockerConfig = this.ensureConfig().getDockerConfiguration();
            Runtime oldRuntime = this.origin.getRuntime();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan oldPlan = this.origin.getAppServicePlan();
            boolean planModified = Objects.nonNull((Object)newPlan) && !Objects.equals((Object)newPlan, (Object)oldPlan);
            boolean runtimeModified = !Objects.requireNonNull(oldRuntime).isDocker() && Objects.nonNull(newRuntime) && !Objects.equals(newRuntime, oldRuntime);
            boolean dockerModified = oldRuntime.isDocker() && Objects.nonNull(newDockerConfig);
            boolean bl = modified = planModified || runtimeModified || dockerModified || MapUtils.isNotEmpty(settingsToAdd) || CollectionUtils.isNotEmpty(settingsToRemove) || Objects.nonNull(newDiagnosticConfig);
            if (modified) {
                WebApp.Update update = (WebApp.Update)remote.update();
                Optional.ofNullable(newPlan).ifPresent(p -> this.updateAppServicePlan(update, (com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan)((Object)p)));
                Optional.ofNullable(newRuntime).ifPresent(p -> this.updateRuntime(update, (Runtime)p));
                Optional.ofNullable(settingsToAdd).ifPresent(arg_0 -> ((WebApp.Update)update).withAppSettings(arg_0));
                Optional.of(settingsToRemove).filter(CollectionUtils::isNotEmpty).ifPresent(s -> s.forEach(arg_0 -> ((WebApp.Update)update).withoutAppSetting(arg_0)));
                Optional.ofNullable(newDockerConfig).ifPresent(p -> this.updateDockerConfiguration(update, (DockerConfiguration)p));
                Optional.ofNullable(newDiagnosticConfig).ifPresent(c -> AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, newDiagnosticConfig));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating Web App({0})...", (Object[])new Object[]{remote.name()}));
                remote = (com.azure.resourcemanager.appservice.models.WebApp)update.apply();
                messager.success(AzureString.format((String)"Web App({0}) is successfully updated", (Object[])new Object[]{remote.name()}));
            }
            com.azure.resourcemanager.appservice.models.WebApp webApp = remote;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void updateAppServicePlan(@Nonnull WebApp.Update update, @Nonnull com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan) {
        OperatingSystem os;
        Objects.requireNonNull((AppServicePlan)newPlan.getRemote(new boolean[0]), "Target app service plan doesn't exist");
        OperatingSystem operatingSystem = os = Objects.requireNonNull(this.getRuntime()).isDocker() ? OperatingSystem.LINUX : this.getRuntime().getOperatingSystem();
        if (!Objects.equals((Object)os, (Object)newPlan.getOperatingSystem())) {
            throw new AzureToolkitRuntimeException(String.format("Could not migrate %s app service to %s service plan", new Object[]{this.getRuntime().getOperatingSystem(), newPlan.getOperatingSystem()}));
        }
        update.withExistingAppServicePlan((AppServicePlan)newPlan.getRemote(new boolean[0]));
    }

    private void updateRuntime(@Nonnull WebApp.Update update, @Nonnull Runtime newRuntime) {
        Runtime oldRuntime = Objects.requireNonNull(Objects.requireNonNull(this.origin).getRuntime());
        if (newRuntime.getOperatingSystem() != null && oldRuntime.isWindows() != newRuntime.isWindows()) {
            throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
        }
        OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), oldRuntime.getOperatingSystem()}));
        if (operatingSystem == OperatingSystem.LINUX) {
            update.withBuiltInImage(AppServiceUtils.toRuntimeStack(newRuntime));
        } else if (operatingSystem == OperatingSystem.WINDOWS) {
            update.withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(AppServiceUtils.toWebContainer(newRuntime));
        } else {
            if (operatingSystem == OperatingSystem.DOCKER) {
                return;
            }
            throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    private void updateDockerConfiguration(@Nonnull WebApp.Update update, @Nonnull DockerConfiguration newConfig) {
        WebApp.UpdateStages.WithStartUpCommand draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{newConfig.getUserName(), newConfig.getPassword()}) ? update.withPublicDockerHubImage(newConfig.getImage()) : (StringUtils.isEmpty((CharSequence)newConfig.getRegistryUrl()) ? update.withPrivateDockerHubImage(newConfig.getImage()).withCredentials(newConfig.getUserName(), newConfig.getPassword()) : update.withPrivateRegistryImage(newConfig.getImage(), newConfig.getRegistryUrl()).withCredentials(newConfig.getUserName(), newConfig.getPassword()));
        draft.withStartUpCommand(newConfig.getStartUpCommand());
    }

    public void setRuntime(Runtime runtime) {
        this.ensureConfig().setRuntime(runtime);
    }

    @Override
    @Nullable
    public Runtime getRuntime() {
        return Optional.ofNullable(this.config).map(Config::getRuntime).orElseGet(() -> super.getRuntime());
    }

    public void setAppServicePlan(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
        this.ensureConfig().setPlan(plan);
    }

    @Override
    @Nullable
    public com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan getAppServicePlan() {
        return Optional.ofNullable(this.config).map(Config::getPlan).orElseGet(() -> super.getAppServicePlan());
    }

    public void setDiagnosticConfig(DiagnosticConfig config) {
        this.ensureConfig().setDiagnosticConfig(config);
    }

    @Override
    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.config).map(Config::getDiagnosticConfig).orElseGet(() -> super.getDiagnosticConfig());
    }

    public void setAppSettings(Map<String, String> appSettings) {
        this.ensureConfig().setAppSettings(appSettings);
    }

    @Override
    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.config).map(Config::getAppSettings).orElseGet(() -> super.getAppSettings());
    }

    public void removeAppSetting(String key) {
        this.ensureConfig().getAppSettingsToRemove().add(key);
    }

    public void removeAppSettings(Set<String> keys) {
        this.ensureConfig().getAppSettingsToRemove().addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{keys, Collections.emptySet()}));
    }

    @Nullable
    public Set<String> getAppSettingsToRemove() {
        return Optional.ofNullable(this.config).map(Config::getAppSettingsToRemove).orElse(new HashSet());
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.ensureConfig().setDockerConfiguration(dockerConfiguration);
    }

    @Nullable
    public DockerConfiguration getDockerConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getDockerConfiguration).orElse(null);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRuntime()) || Objects.equals(this.config.getRuntime(), super.getRuntime()) || Objects.isNull((Object)this.config.getPlan()) || Objects.equals((Object)this.config.getPlan(), (Object)super.getAppServicePlan()) || Objects.isNull(this.config.getDiagnosticConfig()) || CollectionUtils.isEmpty(this.config.getAppSettingsToRemove()) || Objects.isNull(this.config.getAppSettings()) || Objects.equals(this.config.getAppSettings(), super.getAppSettings()) || Objects.isNull(this.config.getDockerConfiguration());
        return !notModified;
    }

    @Nullable
    public WebApp getOrigin() {
        return this.origin;
    }

    static {
        WebAppDraft.ajc$preClinit();
        DEFAULT_RUNTIME = Runtime.LINUX_JAVA17;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebAppDraft.java", WebAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft", "", "", "", "com.azure.resourcemanager.appservice.models.WebApp"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft", "com.azure.resourcemanager.appservice.models.WebSiteBase", "base", "", "com.azure.resourcemanager.appservice.models.WebApp"), 142);
    }

    @Nullable
    private static class Config {
        private Runtime runtime;
        private com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan = null;
        private DiagnosticConfig diagnosticConfig = null;
        private Set<String> appSettingsToRemove = new HashSet<String>();
        private Map<String, String> appSettings = null;
        private DockerConfiguration dockerConfiguration = null;

        public Runtime getRuntime() {
            return this.runtime;
        }

        public com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan getPlan() {
            return this.plan;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }

        public Set<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DockerConfiguration getDockerConfiguration() {
            return this.dockerConfiguration;
        }

        public void setRuntime(Runtime runtime) {
            this.runtime = runtime;
        }

        public void setPlan(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
            this.plan = plan;
        }

        public void setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
        }

        public void setAppSettingsToRemove(Set<String> appSettingsToRemove) {
            this.appSettingsToRemove = appSettingsToRemove;
        }

        public void setAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
        }

        public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
            this.dockerConfiguration = dockerConfiguration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Runtime this$runtime = this.getRuntime();
            Runtime other$runtime = other.getRuntime();
            if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
                return false;
            }
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan this$plan = this.getPlan();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !((Object)((Object)this$plan)).equals((Object)other$plan)) {
                return false;
            }
            DiagnosticConfig this$diagnosticConfig = this.getDiagnosticConfig();
            DiagnosticConfig other$diagnosticConfig = other.getDiagnosticConfig();
            if (this$diagnosticConfig == null ? other$diagnosticConfig != null : !((Object)this$diagnosticConfig).equals(other$diagnosticConfig)) {
                return false;
            }
            Set<String> this$appSettingsToRemove = this.getAppSettingsToRemove();
            Set<String> other$appSettingsToRemove = other.getAppSettingsToRemove();
            if (this$appSettingsToRemove == null ? other$appSettingsToRemove != null : !((Object)this$appSettingsToRemove).equals(other$appSettingsToRemove)) {
                return false;
            }
            Map<String, String> this$appSettings = this.getAppSettings();
            Map<String, String> other$appSettings = other.getAppSettings();
            if (this$appSettings == null ? other$appSettings != null : !((Object)this$appSettings).equals(other$appSettings)) {
                return false;
            }
            DockerConfiguration this$dockerConfiguration = this.getDockerConfiguration();
            DockerConfiguration other$dockerConfiguration = other.getDockerConfiguration();
            return !(this$dockerConfiguration == null ? other$dockerConfiguration != null : !((Object)this$dockerConfiguration).equals(other$dockerConfiguration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Runtime $runtime = this.getRuntime();
            result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : ((Object)((Object)$plan)).hashCode());
            DiagnosticConfig $diagnosticConfig = this.getDiagnosticConfig();
            result = result * 59 + ($diagnosticConfig == null ? 43 : ((Object)$diagnosticConfig).hashCode());
            Set<String> $appSettingsToRemove = this.getAppSettingsToRemove();
            result = result * 59 + ($appSettingsToRemove == null ? 43 : ((Object)$appSettingsToRemove).hashCode());
            Map<String, String> $appSettings = this.getAppSettings();
            result = result * 59 + ($appSettings == null ? 43 : ((Object)$appSettings).hashCode());
            DockerConfiguration $dockerConfiguration = this.getDockerConfiguration();
            result = result * 59 + ($dockerConfiguration == null ? 43 : ((Object)$dockerConfiguration).hashCode());
            return result;
        }

        public String toString() {
            return "WebAppDraft.Config(runtime=" + this.getRuntime() + ", plan=" + (Object)((Object)this.getPlan()) + ", diagnosticConfig=" + this.getDiagnosticConfig() + ", appSettingsToRemove=" + this.getAppSettingsToRemove() + ", appSettings=" + this.getAppSettings() + ", dockerConfiguration=" + this.getDockerConfiguration() + ")";
        }
    }
}

