/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.azure.resourcemanager.appservice.models.WebApps;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppModule
extends AbstractAzResourceModule<WebApp, AppServiceServiceSubscription, WebSiteBase> {
    private static final Logger log = LoggerFactory.getLogger(WebAppModule.class);
    public static final String NAME = "sites";

    public WebAppModule(@Nonnull AppServiceServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    public WebApps getClient() {
        return Optional.ofNullable((AppServiceManager)((AppServiceServiceSubscription)this.parent).getRemote(new boolean[0])).map(AppServiceManager::webApps).orElse(null);
    }

    @Nonnull
    protected WebAppDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        return new WebAppDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected WebAppDraft newDraftForUpdate(@Nonnull WebApp origin) {
        return new WebAppDraft(origin);
    }

    @Nonnull
    protected WebApp newResource(@Nonnull WebSiteBase remote) {
        return new WebApp((WebAppBasic)remote, this);
    }

    @Nonnull
    protected WebApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new WebApp(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Web app";
    }

    @Nonnull
    public WebApp update(@Nonnull AzResource.Draft<WebApp, ?> d) {
        AzResource.Draft draft = (AzResource.Draft)this.cast(d);
        log.debug("[{}]:update(draft:{})", (Object)this.getName(), (Object)draft);
        WebApp resource = (WebApp)this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.nonNull(resource) && Objects.nonNull(resource.getRemote(new boolean[0]))) {
            log.debug("[{}]:update->doModify(draft.updateResourceInAzure({}))", (Object)this.getName(), resource.getRemote(new boolean[0]));
            resource.doModify(() -> (WebSiteBase)draft.updateResourceInAzure((Object)((WebSiteBase)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.WebApp)resource.getFullRemote()))), "Updating");
            return resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", draft.getName()));
    }
}

