/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureAppService
extends AbstractAzService<AppServiceServiceSubscription, AppServiceManager> {
    public AzureAppService() {
        super("Microsoft.Web");
    }

    @Nonnull
    public AppServicePlanModule plans(@Nonnull String subscriptionId) {
        AppServiceServiceSubscription rm = (AppServiceServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getPlanModule();
    }

    @Nonnull
    public List<AppServicePlan> plans() {
        return this.list().stream().flatMap(m -> m.plans().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public AppServicePlan plan(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (AppServicePlan)this.plans(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    protected AppServiceManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(null, subscriptionId, account.getEnvironment());
        return ((AppServiceManager.Configurable)((AppServiceManager.Configurable)((AppServiceManager.Configurable)AppServiceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withLogLevel(logLevel)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    protected AppServiceServiceSubscription newResource(@Nonnull AppServiceManager remote) {
        return new AppServiceServiceSubscription(remote, this);
    }

    @Nullable
    public <E> E getById(@Nonnull String id) {
        boolean isFunctionRelated;
        block4: {
            ResourceId resourceId = ResourceId.fromString((String)id);
            if (resourceId.resourceType().equals("serverfarms")) {
                return (E)super.doGetById(id);
            }
            isFunctionRelated = false;
            try {
                GenericResource resource = ((AzureResources)Azure.az(AzureResources.class)).getGenericResource(id);
                isFunctionRelated = Optional.ofNullable(resource).filter(r -> StringUtils.containsIgnoreCase((CharSequence)r.getKind(), (CharSequence)"function")).isPresent();
            }
            catch (ManagementException e) {
                if (e.getResponse().getStatusCode() == 404) break block4;
                throw e;
            }
        }
        if (isFunctionRelated) {
            return (E)((AzureFunctions)Azure.az(AzureFunctions.class)).doGetById(id);
        }
        return (E)((AzureWebApp)Azure.az(AzureWebApp.class)).doGetById(id);
    }

    @Nullable
    public <E> E getOrInitById(@Nonnull String id) {
        boolean isFunctionRelated;
        block4: {
            ResourceId resourceId = ResourceId.fromString((String)id);
            if (resourceId.resourceType().equals("serverfarms")) {
                return (E)super.doGetOrInitById(id);
            }
            isFunctionRelated = false;
            try {
                GenericResource resource = ((AzureResources)Azure.az(AzureResources.class)).getGenericResource(id);
                isFunctionRelated = Optional.ofNullable(resource).filter(r -> StringUtils.containsIgnoreCase((CharSequence)r.getKind(), (CharSequence)"function")).isPresent();
            }
            catch (ManagementException e) {
                if (e.getResponse().getStatusCode() == 404) break block4;
                throw e;
            }
        }
        if (isFunctionRelated) {
            return (E)((AzureFunctions)Azure.az(AzureFunctions.class)).doGetOrInitById(id);
        }
        return (E)((AzureWebApp)Azure.az(AzureWebApp.class)).doGetOrInitById(id);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "App Services";
    }
}

