/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.azure.resourcemanager.appservice.models.AppSetting;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class DeployUtils {
    private static final String INTERNAL_STORAGE_NOT_FOUND = "Application setting 'AzureWebJobsStorage' is not found, please check the application setting and try again later.";
    public static final String INVALID_STORAGE_CONNECTION_STRING = "Storage connection string in 'AzureWebJobsStorage' is invalid, please check the application setting and try again later.";
    private static final String INTERNAL_STORAGE_KEY = "AzureWebJobsStorage";
    private static final String UNSUPPORTED_DEPLOYMENT_TARGET = "Unsupported deployment target, only function is supported";

    DeployUtils() {
    }

    static BlobServiceClient getBlobServiceClient(WebAppBase functionApp) {
        String connectionString = Optional.ofNullable(functionApp.getSiteAppSettings()).map(map -> (String)map.get(INTERNAL_STORAGE_KEY)).filter(StringUtils::isNotEmpty).orElseGet(() -> Optional.ofNullable(functionApp.getAppSettings()).map(map -> (AppSetting)map.get(INTERNAL_STORAGE_KEY)).map(AppSetting::value).orElse(null));
        if (StringUtils.isEmpty((CharSequence)connectionString)) {
            throw new AzureToolkitRuntimeException(INTERNAL_STORAGE_NOT_FOUND);
        }
        return new BlobServiceClientBuilder().connectionString(connectionString).buildClient();
    }

    static void updateFunctionAppSetting(WebAppBase deployTarget, String key, String value) {
        if (deployTarget instanceof FunctionApp) {
            ((FunctionApp.Update)((FunctionApp)deployTarget).update()).withAppSetting(key, value).apply();
        } else if (deployTarget instanceof FunctionDeploymentSlot) {
            ((DeploymentSlotBase.Update)((FunctionDeploymentSlot)deployTarget).update()).withAppSetting(key, value).apply();
        } else {
            throw new AzureToolkitRuntimeException(UNSUPPORTED_DEPLOYMENT_TARGET);
        }
    }
}

