/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.file.AppServiceKuduClient;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FlexFunctionDeployHandler
implements IFunctionDeployHandler {
    public static final String FAILED_TO_DEPLOY = "Failed to deploy to Azure Function (%s) : ";

    @Override
    @Deprecated
    public void deploy(@Nonnull File file, @Nonnull WebAppBase webAppBase) {
        this.deploy(file, (FunctionAppBase)((Object)Objects.requireNonNull(((AzureFunctions)Azure.az(AzureFunctions.class)).getById(webAppBase.id()))));
    }

    @Override
    public void deploy(@Nonnull File file, @Nonnull FunctionAppBase<?, ?, ?> functionAppBase) {
        AppServiceKuduClient kuduManager = functionAppBase.getKuduManager();
        try {
            Objects.requireNonNull(kuduManager).flexZipDeploy(file);
        }
        catch (Exception e) {
            throw new AzureToolkitRuntimeException(String.format(FAILED_TO_DEPLOY, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
        AzureMessager.getMessager().info(String.format("Successfully deployed the artifact to https://%s", functionAppBase.getHostName()));
    }
}

