/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import java.util.Optional;
import javax.annotation.Nonnull;

public class FlexConsumptionConfiguration {
    public static final int DEFAULT_INSTANCE_SIZE = 2048;
    public static final FlexConsumptionConfiguration DEFAULT = FlexConsumptionConfiguration.builder().instanceSize(2048).build();
    private Integer instanceSize;
    private Integer alwaysReadyInstances;
    private Integer maximumInstances;

    public static FlexConsumptionConfiguration fromWebAppBase(@Nonnull WebAppBase app) {
        return FlexConsumptionConfiguration.builder().instanceSize(app.containerSize()).alwaysReadyInstances(Optional.ofNullable((SiteInner)app.innerModel()).map(SiteInner::siteConfig).map(SiteConfigInner::minimumElasticInstanceCount).orElse(null)).maximumInstances(Optional.ofNullable((SiteInner)app.innerModel()).map(SiteInner::siteConfig).map(SiteConfigInner::functionAppScaleLimit).orElse(null)).build();
    }

    public static FlexConsumptionConfigurationBuilder builder() {
        return new FlexConsumptionConfigurationBuilder();
    }

    public Integer getInstanceSize() {
        return this.instanceSize;
    }

    public Integer getAlwaysReadyInstances() {
        return this.alwaysReadyInstances;
    }

    public Integer getMaximumInstances() {
        return this.maximumInstances;
    }

    public void setInstanceSize(Integer instanceSize) {
        this.instanceSize = instanceSize;
    }

    public void setAlwaysReadyInstances(Integer alwaysReadyInstances) {
        this.alwaysReadyInstances = alwaysReadyInstances;
    }

    public void setMaximumInstances(Integer maximumInstances) {
        this.maximumInstances = maximumInstances;
    }

    public FlexConsumptionConfiguration() {
    }

    public FlexConsumptionConfiguration(Integer instanceSize, Integer alwaysReadyInstances, Integer maximumInstances) {
        this.instanceSize = instanceSize;
        this.alwaysReadyInstances = alwaysReadyInstances;
        this.maximumInstances = maximumInstances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlexConsumptionConfiguration)) {
            return false;
        }
        FlexConsumptionConfiguration other = (FlexConsumptionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$instanceSize = this.getInstanceSize();
        Integer other$instanceSize = other.getInstanceSize();
        if (this$instanceSize == null ? other$instanceSize != null : !((Object)this$instanceSize).equals(other$instanceSize)) {
            return false;
        }
        Integer this$alwaysReadyInstances = this.getAlwaysReadyInstances();
        Integer other$alwaysReadyInstances = other.getAlwaysReadyInstances();
        if (this$alwaysReadyInstances == null ? other$alwaysReadyInstances != null : !((Object)this$alwaysReadyInstances).equals(other$alwaysReadyInstances)) {
            return false;
        }
        Integer this$maximumInstances = this.getMaximumInstances();
        Integer other$maximumInstances = other.getMaximumInstances();
        return !(this$maximumInstances == null ? other$maximumInstances != null : !((Object)this$maximumInstances).equals(other$maximumInstances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlexConsumptionConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $instanceSize = this.getInstanceSize();
        result = result * 59 + ($instanceSize == null ? 43 : ((Object)$instanceSize).hashCode());
        Integer $alwaysReadyInstances = this.getAlwaysReadyInstances();
        result = result * 59 + ($alwaysReadyInstances == null ? 43 : ((Object)$alwaysReadyInstances).hashCode());
        Integer $maximumInstances = this.getMaximumInstances();
        result = result * 59 + ($maximumInstances == null ? 43 : ((Object)$maximumInstances).hashCode());
        return result;
    }

    public static class FlexConsumptionConfigurationBuilder {
        private Integer instanceSize;
        private Integer alwaysReadyInstances;
        private Integer maximumInstances;

        FlexConsumptionConfigurationBuilder() {
        }

        public FlexConsumptionConfigurationBuilder instanceSize(Integer instanceSize) {
            this.instanceSize = instanceSize;
            return this;
        }

        public FlexConsumptionConfigurationBuilder alwaysReadyInstances(Integer alwaysReadyInstances) {
            this.alwaysReadyInstances = alwaysReadyInstances;
            return this;
        }

        public FlexConsumptionConfigurationBuilder maximumInstances(Integer maximumInstances) {
            this.maximumInstances = maximumInstances;
            return this;
        }

        public FlexConsumptionConfiguration build() {
            return new FlexConsumptionConfiguration(this.instanceSize, this.alwaysReadyInstances, this.maximumInstances);
        }

        public String toString() {
            return "FlexConsumptionConfiguration.FlexConsumptionConfigurationBuilder(instanceSize=" + this.instanceSize + ", alwaysReadyInstances=" + this.alwaysReadyInstances + ", maximumInstances=" + this.maximumInstances + ")";
        }
    }
}

