/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;

public class StreamingLogTask
extends AzureTask<AppServiceAppBase<?, ?, ?>> {
    private final AppServiceAppBase<?, ?, ?> webApp;
    private Disposable subscription;

    public StreamingLogTask(AppServiceAppBase<?, ?, ?> webApp) {
        this.webApp = webApp;
    }

    protected AppServiceAppBase<?, ?, ?> doExecute() {
        this.startStreamingLog();
        return this.webApp;
    }

    private void startStreamingLog() {
        if (!this.webApp.isStreamingLogSupported()) {
            return;
        }
        IAzureMessager messager = AzureMessager.getMessager();
        messager.info(AzureString.format((String)"Opening streaming log of app({0})...", (Object[])new Object[]{this.webApp.getName()}));
        messager.debug("###############STREAMING LOG BEGIN##################");
        this.subscription = this.webApp.streamingLogs(true).doFinally(type -> messager.debug("###############STREAMING LOG END##################")).subscribe(arg_0 -> ((IAzureMessager)messager).debug(arg_0));
        try {
            TimeUnit.MINUTES.sleep(1L);
        }
        catch (Exception exception) {
        }
        finally {
            this.stopStreamingLog();
        }
    }

    private synchronized void stopStreamingLog() {
        if (this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

