/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppServiceSubscription;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureWebApp
extends AzureAppService {
    @Nonnull
    public WebAppModule webApps(@Nonnull String subscriptionId) {
        AppServiceServiceSubscription rm = (AppServiceServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getWebAppModule();
    }

    @Nonnull
    public List<WebApp> webApps() {
        return this.list().stream().flatMap(m -> m.webApps().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public WebApp webApp(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (WebApp)this.webApps(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    public List<Runtime> listWebAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        return Runtime.WEBAPP_RUNTIME.stream().filter(runtime -> os == runtime.getOperatingSystem() && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    protected AppServiceServiceSubscription newResource(@Nonnull AppServiceManager remote) {
        return new WebAppServiceSubscription(remote, (AzureAppService)this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Web Apps";
    }

    @Override
    public String getServiceNameForTelemetry() {
        return "webapp";
    }
}

