/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.FunctionAppStackInner;
import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class FunctionsServiceSubscription
extends AppServiceServiceSubscription {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};

    protected FunctionsServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureAppService service) {
        super(subscriptionId, service);
    }

    protected FunctionsServiceSubscription(@Nonnull AppServiceManager remote, @Nonnull AzureAppService service) {
        super(remote, service);
    }

    @Override
    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.getFunctionAppModule());
    }

    @Nonnull
    public List<FunctionAppRuntime> listFunctionAppMajorRuntimes() {
        if (!FunctionAppWindowsRuntime.isLoaded() && !FunctionAppLinuxRuntime.isLoaded()) {
            this.loadRuntimes();
        }
        return Stream.concat(FunctionAppWindowsRuntime.getMajorRuntimes().stream(), FunctionAppLinuxRuntime.getMajorRuntimes().stream()).collect(Collectors.toList());
    }

    public synchronized void loadRuntimes() {
        this.loadRuntimesUsingHttpPipeline();
    }

    public synchronized void loadRuntimesUsingSdk() {
        AppServiceManager remote = (AppServiceManager)this.getRemote();
        if (Objects.isNull(remote)) {
            return;
        }
        if (FunctionAppWindowsRuntime.isLoaded() && FunctionAppLinuxRuntime.isLoaded()) {
            return;
        }
        List<FunctionAppMajorVersion> javaStacks = ((WebSiteManagementClient)remote.serviceClient()).getProviders().getFunctionAppStacksAsync().toStream().filter(stack -> StringUtils.equalsIgnoreCase((CharSequence)stack.name(), (CharSequence)"java")).findFirst().map(FunctionAppStackInner::majorVersions).orElse(Collections.emptyList());
        FunctionAppLinuxRuntime.loadAllFunctionAppLinuxRuntimes(javaStacks);
        FunctionAppWindowsRuntime.loadAllFunctionAppWindowsRuntimes(javaStacks);
    }

    public synchronized void loadRuntimesUsingHttpPipeline() {
        AppServiceManager remote = (AppServiceManager)this.getRemote();
        if (Objects.isNull(remote)) {
            return;
        }
        if (FunctionAppWindowsRuntime.isLoaded() && FunctionAppLinuxRuntime.isLoaded()) {
            return;
        }
        Map<String, Object> result = this.getRuntimesUsingHttpPipeline(remote);
        if (result.isEmpty()) {
            return;
        }
        List stacksList = (List)Utils.get(result, (String)"$.value");
        List<Map<String, Object>> javaStacks = Objects.requireNonNull(stacksList).stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)Utils.get((Map)s, (String)"$.name")), (CharSequence)"java")).findFirst().map(j -> Utils.get((Map)j, (String)"$.properties.majorVersions")).orElse(Collections.emptyList());
        FunctionAppLinuxRuntime.loadAllFunctionAppLinuxRuntimesFromMap(javaStacks);
        FunctionAppWindowsRuntime.loadAllFunctionAppWindowsRuntimesFromMap(javaStacks);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getRuntimesUsingHttpPipeline(AppServiceManager appServiceManager) {
        HttpPipeline pipeline = appServiceManager.httpPipeline();
        String apiVersion = ((WebSiteManagementClient)appServiceManager.serviceClient()).getApiVersion();
        HttpRequest request = new HttpRequest(HttpMethod.GET, String.format("%s/providers/Microsoft.Web/functionAppStacks?api-version=%s", ((WebSiteManagementClient)appServiceManager.serviceClient()).getEndpoint(), apiVersion));
        try (HttpResponse response = (HttpResponse)pipeline.send(request).block();){
            if (!Objects.nonNull(response)) return Collections.emptyMap();
            if (response.getStatusCode() != 200) return Collections.emptyMap();
            String responseBodyString = (String)response.getBodyAsString().block();
            Map map = (Map)mapper.readValue(responseBodyString, typeRef);
            return map;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

