/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public interface FunctionAppRuntime
extends Runtime {
    public static final String DEFAULT_JAVA = "Java 17";

    @Override
    default public String getDisplayName() {
        if (this.isDocker()) {
            return "Docker";
        }
        return String.format("%s-%s", this.getOperatingSystem().toString(), this.getJavaVersionUserText());
    }

    @Override
    default public boolean isMinorVersion() {
        if (this.isDocker()) {
            return false;
        }
        Pattern EXCLUDE_PATTERN = Pattern.compile("\\..*\\.");
        return EXCLUDE_PATTERN.matcher(this.getJavaVersionNumber()).matches();
    }

    public static FunctionAppRuntime getDefault() {
        return FunctionAppWindowsRuntime.FUNCTION_JAVA17;
    }

    public static List<FunctionAppRuntime> getMajorRuntimes() {
        return Stream.concat(Stream.concat(FunctionAppLinuxRuntime.getMajorRuntimes().stream(), FunctionAppWindowsRuntime.getMajorRuntimes().stream()), Stream.of(FunctionAppDockerRuntime.INSTANCE)).collect(Collectors.toList());
    }

    public static List<FunctionAppRuntime> getAllRuntimes() {
        return Stream.concat(Stream.concat(FunctionAppLinuxRuntime.getAllRuntimes().stream(), FunctionAppWindowsRuntime.getAllRuntimes().stream()), Stream.of(FunctionAppDockerRuntime.INSTANCE)).collect(Collectors.toList());
    }

    public static FunctionAppRuntime fromUserText(String os, String javaVersionUserText) {
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"docker")) {
            return FunctionAppDockerRuntime.INSTANCE;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"windows")) {
            return FunctionAppWindowsRuntime.fromJavaVersionUserText(javaVersionUserText);
        }
        return FunctionAppLinuxRuntime.fromJavaVersionUserText(javaVersionUserText);
    }
}

