/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public interface Runtime {
    public OperatingSystem getOperatingSystem();

    public String getDisplayName();

    @Nonnull
    public String getJavaVersionNumber();

    default public String getJavaVersionUserText() {
        if (this.isDocker()) {
            return "";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.getJavaVersionNumber(), (CharSequence[])new CharSequence[]{"1.8", "8"})) {
            return "Java 8";
        }
        return String.format("Java %s", this.getJavaVersionNumber());
    }

    default public JavaVersion getJavaVersion() {
        if (this.isDocker()) {
            return JavaVersion.fromString((String)"docker");
        }
        return JavaVersion.fromString((String)this.getJavaVersionNumber());
    }

    default public int getJavaMajorVersionNumber() {
        if (this.isDocker()) {
            return 0;
        }
        String v = this.getJavaVersionNumber();
        return Runtime.getJavaMajorVersionNumber(v);
    }

    default public boolean isDeprecatedOrHidden() {
        return false;
    }

    default public boolean isMinorVersion() {
        return false;
    }

    default public boolean isWindows() {
        return this.getOperatingSystem() == OperatingSystem.WINDOWS;
    }

    default public boolean isLinux() {
        return this.getOperatingSystem() == OperatingSystem.LINUX;
    }

    default public boolean isDocker() {
        return this.getOperatingSystem() == OperatingSystem.DOCKER;
    }

    public static int getJavaMajorVersionNumber(String javaVersionUserText) {
        String v = StringUtils.replaceIgnoreCase((String)javaVersionUserText, (String)"java", (String)"").trim();
        String[] parts = v.split("\\.", 3);
        return Integer.parseInt(StringUtils.startsWithIgnoreCase((CharSequence)v, (CharSequence)"1.") ? parts[1] : parts[0]);
    }

    public static String extractAndFormalizeJavaVersionNumber(String javaVersion) {
        javaVersion = StringUtils.replaceIgnoreCase((String)javaVersion, (String)"java", (String)"").trim();
        String string = javaVersion = StringUtils.equalsAny((CharSequence)javaVersion, (CharSequence[])new CharSequence[]{"8", "7"}) ? "1." + javaVersion : javaVersion;
        if (javaVersion.contains("u")) {
            String[] parts = javaVersion.split("u", 2);
            return String.format("1.%s.0_%s", parts[0], parts[1]);
        }
        return javaVersion;
    }
}

