/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.FunctionApps;
import com.azure.resourcemanager.appservice.models.SkuName;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceModule;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionsServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAppModule
extends AppServiceResourceModule<FunctionApp, AppServiceServiceSubscription, com.azure.resourcemanager.appservice.models.FunctionApp> {
    private static final Logger log = LoggerFactory.getLogger(FunctionAppModule.class);
    public static final String NAME = "sites";

    public FunctionAppModule(@Nonnull AppServiceServiceSubscription parent) {
        super(NAME, parent);
    }

    public FunctionApps getClient() {
        return Optional.ofNullable(((AppServiceServiceSubscription)this.parent).getRemote()).map(AppServiceManager::functionApps).orElse(null);
    }

    @Nonnull
    protected FunctionAppDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        return new FunctionAppDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected FunctionAppDraft newDraftForUpdate(@Nonnull FunctionApp origin) {
        return new FunctionAppDraft(origin);
    }

    @Nonnull
    protected FunctionApp newResource(@Nonnull com.azure.resourcemanager.appservice.models.FunctionApp remote) {
        return new FunctionApp((FunctionAppBasic)remote, this);
    }

    @Nonnull
    protected FunctionApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new FunctionApp(name, Objects.requireNonNull(resourceGroupName), this);
    }

    public void delete(@Nonnull String name, @Nullable String rgName) {
        FunctionApp resource = (FunctionApp)this.get(name, rgName);
        ContainerAppsEnvironment environment = Optional.ofNullable(resource).map(FunctionApp::getEnvironment).orElse(null);
        super.delete(name, rgName);
        Optional.ofNullable(environment).ifPresent(ContainerAppsEnvironment::refresh);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Function app";
    }

    @Override
    protected List<String> loadResourceIdsFromAzure() {
        return Optional.ofNullable(this.getClient()).map(client -> client.list().stream().map(HasId::id).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<Region> listRegions(PricingTier pricingTier) {
        SkuName sku = SkuName.fromString((String)pricingTier.getTier());
        FunctionApps client = this.getClient();
        if (Objects.isNull(client)) {
            return Collections.emptyList();
        }
        return ((WebSiteManagementClient)((AppServiceManager)client.manager()).serviceClient()).getResourceProviders().listGeoRegions(sku, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Context.NONE).stream().map(geoRegionInner -> Region.fromName((String)geoRegionInner.name())).collect(Collectors.toList());
    }

    public List<? extends FunctionAppRuntime> listFlexConsumptionRuntimes(@Nonnull Region region) {
        Map<String, Object> result = this.getFlexConsumptionRuntimesUsingHttpPipeline(region.getName());
        List stacksList = (List)Utils.get(result, (String)"$.value");
        if (CollectionUtils.isEmpty((Collection)stacksList)) {
            return Collections.emptyList();
        }
        List javaStacks = stacksList.stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)Utils.get((Map)s, (String)"$.name")), (CharSequence)"java")).findFirst().map(j -> Utils.get((Map)j, (String)"$.properties.majorVersions")).orElse(Collections.emptyList());
        List<Map<String, Object>> flexStacks = javaStacks.stream().filter(raw -> {
            List minorVersions = (List)Utils.get((Map)raw, (String)"$.minorVersions");
            return !CollectionUtils.isEmpty((Collection)minorVersions) && minorVersions.stream().map(v -> (List)Utils.get((Map)v, (String)"$.stackSettings.linuxRuntimeSettings.Sku")).filter(Objects::nonNull).anyMatch(map -> map.stream().anyMatch(m -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)Utils.get((Map)m, (String)"$.skuCode")), (CharSequence)PricingTier.FLEX_CONSUMPTION.getSize())));
        }).collect(Collectors.toList());
        List<FunctionAppLinuxRuntime> linuxRuntimes = FunctionAppLinuxRuntime.getLinuxRuntimeFromMap(flexStacks);
        return linuxRuntimes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getFlexConsumptionRuntimesUsingHttpPipeline(@Nonnull String region) {
        AppServiceManager appServiceManager = (AppServiceManager)Objects.requireNonNull(((AppServiceServiceSubscription)this.getParent()).getRemote());
        HttpPipeline pipeline = appServiceManager.httpPipeline();
        HttpRequest request = new HttpRequest(HttpMethod.GET, String.format("%s/providers/Microsoft.Web/locations/%s/functionAppStacks?api-version=2020-10-01&stack=java", ((WebSiteManagementClient)appServiceManager.serviceClient()).getEndpoint(), region));
        try (HttpResponse response = (HttpResponse)pipeline.send(request).block();){
            if (!Objects.nonNull(response)) return Collections.emptyMap();
            if (response.getStatusCode() != 200) return Collections.emptyMap();
            String responseBodyString = (String)response.getBodyAsString().block();
            Map map = (Map)FunctionsServiceSubscription.mapper.readValue(responseBodyString, FunctionsServiceSubscription.typeRef);
            return map;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

