/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.StorageAuthenticationMethod;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FunctionAppConfig {
    public static final FunctionAppConfig DEFAULT_CONFIG = FunctionAppConfig.builder().deployment(FunctionsDeployment.DEFAULT_DEPLOYMENT).runtime(FunctionsRuntime.DEFAULT_RUNTIME).scaleAndConcurrency(FunctionScaleAndConcurrency.DEFAULT_SCALE_CONFIGURATION).build();
    private FunctionsDeployment deployment;
    private FunctionsRuntime runtime;
    private FunctionScaleAndConcurrency scaleAndConcurrency;

    public static FunctionAppConfigBuilder builder() {
        return new FunctionAppConfigBuilder();
    }

    public FunctionsDeployment getDeployment() {
        return this.deployment;
    }

    public FunctionsRuntime getRuntime() {
        return this.runtime;
    }

    public FunctionScaleAndConcurrency getScaleAndConcurrency() {
        return this.scaleAndConcurrency;
    }

    public void setDeployment(FunctionsDeployment deployment) {
        this.deployment = deployment;
    }

    public void setRuntime(FunctionsRuntime runtime) {
        this.runtime = runtime;
    }

    public void setScaleAndConcurrency(FunctionScaleAndConcurrency scaleAndConcurrency) {
        this.scaleAndConcurrency = scaleAndConcurrency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionAppConfig)) {
            return false;
        }
        FunctionAppConfig other = (FunctionAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionsDeployment this$deployment = this.getDeployment();
        FunctionsDeployment other$deployment = other.getDeployment();
        if (this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment)) {
            return false;
        }
        FunctionsRuntime this$runtime = this.getRuntime();
        FunctionsRuntime other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        FunctionScaleAndConcurrency this$scaleAndConcurrency = this.getScaleAndConcurrency();
        FunctionScaleAndConcurrency other$scaleAndConcurrency = other.getScaleAndConcurrency();
        return !(this$scaleAndConcurrency == null ? other$scaleAndConcurrency != null : !((Object)this$scaleAndConcurrency).equals(other$scaleAndConcurrency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionAppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionsDeployment $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        FunctionsRuntime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        FunctionScaleAndConcurrency $scaleAndConcurrency = this.getScaleAndConcurrency();
        result = result * 59 + ($scaleAndConcurrency == null ? 43 : ((Object)$scaleAndConcurrency).hashCode());
        return result;
    }

    public String toString() {
        return "FunctionAppConfig(deployment=" + this.getDeployment() + ", runtime=" + this.getRuntime() + ", scaleAndConcurrency=" + this.getScaleAndConcurrency() + ")";
    }

    public FunctionAppConfig() {
    }

    public FunctionAppConfig(FunctionsDeployment deployment, FunctionsRuntime runtime, FunctionScaleAndConcurrency scaleAndConcurrency) {
        this.deployment = deployment;
        this.runtime = runtime;
        this.scaleAndConcurrency = scaleAndConcurrency;
    }

    public static class FunctionAppConfigBuilder {
        private FunctionsDeployment deployment;
        private FunctionsRuntime runtime;
        private FunctionScaleAndConcurrency scaleAndConcurrency;

        FunctionAppConfigBuilder() {
        }

        public FunctionAppConfigBuilder deployment(FunctionsDeployment deployment) {
            this.deployment = deployment;
            return this;
        }

        public FunctionAppConfigBuilder runtime(FunctionsRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public FunctionAppConfigBuilder scaleAndConcurrency(FunctionScaleAndConcurrency scaleAndConcurrency) {
            this.scaleAndConcurrency = scaleAndConcurrency;
            return this;
        }

        public FunctionAppConfig build() {
            return new FunctionAppConfig(this.deployment, this.runtime, this.scaleAndConcurrency);
        }

        public String toString() {
            return "FunctionAppConfig.FunctionAppConfigBuilder(deployment=" + this.deployment + ", runtime=" + this.runtime + ", scaleAndConcurrency=" + this.scaleAndConcurrency + ")";
        }
    }

    public static class FunctionAlwaysReadyConfig {
        private String name;
        private Integer instanceCount;

        public static FunctionAlwaysReadyConfigBuilder builder() {
            return new FunctionAlwaysReadyConfigBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Integer getInstanceCount() {
            return this.instanceCount;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionAlwaysReadyConfig)) {
                return false;
            }
            FunctionAlwaysReadyConfig other = (FunctionAlwaysReadyConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$instanceCount = this.getInstanceCount();
            Integer other$instanceCount = other.getInstanceCount();
            if (this$instanceCount == null ? other$instanceCount != null : !((Object)this$instanceCount).equals(other$instanceCount)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionAlwaysReadyConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $instanceCount = this.getInstanceCount();
            result = result * 59 + ($instanceCount == null ? 43 : ((Object)$instanceCount).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.FunctionAlwaysReadyConfig(name=" + this.getName() + ", instanceCount=" + this.getInstanceCount() + ")";
        }

        public FunctionAlwaysReadyConfig() {
        }

        public FunctionAlwaysReadyConfig(String name, Integer instanceCount) {
            this.name = name;
            this.instanceCount = instanceCount;
        }

        public static class FunctionAlwaysReadyConfigBuilder {
            private String name;
            private Integer instanceCount;

            FunctionAlwaysReadyConfigBuilder() {
            }

            public FunctionAlwaysReadyConfigBuilder name(String name) {
                this.name = name;
                return this;
            }

            public FunctionAlwaysReadyConfigBuilder instanceCount(Integer instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public FunctionAlwaysReadyConfig build() {
                return new FunctionAlwaysReadyConfig(this.name, this.instanceCount);
            }

            public String toString() {
                return "FunctionAppConfig.FunctionAlwaysReadyConfig.FunctionAlwaysReadyConfigBuilder(name=" + this.name + ", instanceCount=" + this.instanceCount + ")";
            }
        }
    }

    public static class FunctionHttpTriggers {
        private Integer perInstanceConcurrency;

        public static FunctionHttpTriggersBuilder builder() {
            return new FunctionHttpTriggersBuilder();
        }

        public Integer getPerInstanceConcurrency() {
            return this.perInstanceConcurrency;
        }

        public void setPerInstanceConcurrency(Integer perInstanceConcurrency) {
            this.perInstanceConcurrency = perInstanceConcurrency;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionHttpTriggers)) {
                return false;
            }
            FunctionHttpTriggers other = (FunctionHttpTriggers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$perInstanceConcurrency = this.getPerInstanceConcurrency();
            Integer other$perInstanceConcurrency = other.getPerInstanceConcurrency();
            return !(this$perInstanceConcurrency == null ? other$perInstanceConcurrency != null : !((Object)this$perInstanceConcurrency).equals(other$perInstanceConcurrency));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionHttpTriggers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $perInstanceConcurrency = this.getPerInstanceConcurrency();
            result = result * 59 + ($perInstanceConcurrency == null ? 43 : ((Object)$perInstanceConcurrency).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.FunctionHttpTriggers(perInstanceConcurrency=" + this.getPerInstanceConcurrency() + ")";
        }

        public FunctionHttpTriggers() {
        }

        public FunctionHttpTriggers(Integer perInstanceConcurrency) {
            this.perInstanceConcurrency = perInstanceConcurrency;
        }

        public static class FunctionHttpTriggersBuilder {
            private Integer perInstanceConcurrency;

            FunctionHttpTriggersBuilder() {
            }

            public FunctionHttpTriggersBuilder perInstanceConcurrency(Integer perInstanceConcurrency) {
                this.perInstanceConcurrency = perInstanceConcurrency;
                return this;
            }

            public FunctionHttpTriggers build() {
                return new FunctionHttpTriggers(this.perInstanceConcurrency);
            }

            public String toString() {
                return "FunctionAppConfig.FunctionHttpTriggers.FunctionHttpTriggersBuilder(perInstanceConcurrency=" + this.perInstanceConcurrency + ")";
            }
        }
    }

    public static class FunctionTriggers {
        private FunctionHttpTriggers http;

        public FunctionTriggers(@Nonnull Integer httpInstanceConcurrency) {
            this.http = new FunctionHttpTriggers(httpInstanceConcurrency);
        }

        public static FunctionTriggersBuilder builder() {
            return new FunctionTriggersBuilder();
        }

        public FunctionHttpTriggers getHttp() {
            return this.http;
        }

        public void setHttp(FunctionHttpTriggers http) {
            this.http = http;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionTriggers)) {
                return false;
            }
            FunctionTriggers other = (FunctionTriggers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FunctionHttpTriggers this$http = this.getHttp();
            FunctionHttpTriggers other$http = other.getHttp();
            return !(this$http == null ? other$http != null : !((Object)this$http).equals(other$http));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionTriggers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionHttpTriggers $http = this.getHttp();
            result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.FunctionTriggers(http=" + this.getHttp() + ")";
        }

        public FunctionTriggers() {
        }

        public FunctionTriggers(FunctionHttpTriggers http) {
            this.http = http;
        }

        public static class FunctionTriggersBuilder {
            private FunctionHttpTriggers http;

            FunctionTriggersBuilder() {
            }

            public FunctionTriggersBuilder http(FunctionHttpTriggers http) {
                this.http = http;
                return this;
            }

            public FunctionTriggers build() {
                return new FunctionTriggers(this.http);
            }

            public String toString() {
                return "FunctionAppConfig.FunctionTriggers.FunctionTriggersBuilder(http=" + this.http + ")";
            }
        }
    }

    public static class FunctionScaleAndConcurrency {
        public static final int DEFAULT_INSTANCE_SIZE = 2048;
        public static final int DEFAULT_MAXIMUM_INSTANCE_COUNT = 100;
        public static final FunctionScaleAndConcurrency DEFAULT_SCALE_CONFIGURATION = FunctionScaleAndConcurrency.builder().instanceMemoryMB(2048).maximumInstanceCount(100).build();
        private FunctionAlwaysReadyConfig[] alwaysReady;
        private Integer maximumInstanceCount;
        private Integer instanceMemoryMB;
        private FunctionTriggers triggers;

        public static FunctionScaleAndConcurrencyBuilder builder() {
            return new FunctionScaleAndConcurrencyBuilder();
        }

        public FunctionAlwaysReadyConfig[] getAlwaysReady() {
            return this.alwaysReady;
        }

        public Integer getMaximumInstanceCount() {
            return this.maximumInstanceCount;
        }

        public Integer getInstanceMemoryMB() {
            return this.instanceMemoryMB;
        }

        public FunctionTriggers getTriggers() {
            return this.triggers;
        }

        public void setAlwaysReady(FunctionAlwaysReadyConfig[] alwaysReady) {
            this.alwaysReady = alwaysReady;
        }

        public void setMaximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
        }

        public void setInstanceMemoryMB(Integer instanceMemoryMB) {
            this.instanceMemoryMB = instanceMemoryMB;
        }

        public void setTriggers(FunctionTriggers triggers) {
            this.triggers = triggers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionScaleAndConcurrency)) {
                return false;
            }
            FunctionScaleAndConcurrency other = (FunctionScaleAndConcurrency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maximumInstanceCount = this.getMaximumInstanceCount();
            Integer other$maximumInstanceCount = other.getMaximumInstanceCount();
            if (this$maximumInstanceCount == null ? other$maximumInstanceCount != null : !((Object)this$maximumInstanceCount).equals(other$maximumInstanceCount)) {
                return false;
            }
            Integer this$instanceMemoryMB = this.getInstanceMemoryMB();
            Integer other$instanceMemoryMB = other.getInstanceMemoryMB();
            if (this$instanceMemoryMB == null ? other$instanceMemoryMB != null : !((Object)this$instanceMemoryMB).equals(other$instanceMemoryMB)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAlwaysReady(), other.getAlwaysReady())) {
                return false;
            }
            FunctionTriggers this$triggers = this.getTriggers();
            FunctionTriggers other$triggers = other.getTriggers();
            return !(this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionScaleAndConcurrency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maximumInstanceCount = this.getMaximumInstanceCount();
            result = result * 59 + ($maximumInstanceCount == null ? 43 : ((Object)$maximumInstanceCount).hashCode());
            Integer $instanceMemoryMB = this.getInstanceMemoryMB();
            result = result * 59 + ($instanceMemoryMB == null ? 43 : ((Object)$instanceMemoryMB).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAlwaysReady());
            FunctionTriggers $triggers = this.getTriggers();
            result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.FunctionScaleAndConcurrency(alwaysReady=" + Arrays.deepToString(this.getAlwaysReady()) + ", maximumInstanceCount=" + this.getMaximumInstanceCount() + ", instanceMemoryMB=" + this.getInstanceMemoryMB() + ", triggers=" + this.getTriggers() + ")";
        }

        public FunctionScaleAndConcurrency() {
        }

        public FunctionScaleAndConcurrency(FunctionAlwaysReadyConfig[] alwaysReady, Integer maximumInstanceCount, Integer instanceMemoryMB, FunctionTriggers triggers) {
            this.alwaysReady = alwaysReady;
            this.maximumInstanceCount = maximumInstanceCount;
            this.instanceMemoryMB = instanceMemoryMB;
            this.triggers = triggers;
        }

        public static class FunctionScaleAndConcurrencyBuilder {
            private FunctionAlwaysReadyConfig[] alwaysReady;
            private Integer maximumInstanceCount;
            private Integer instanceMemoryMB;
            private FunctionTriggers triggers;

            FunctionScaleAndConcurrencyBuilder() {
            }

            public FunctionScaleAndConcurrencyBuilder alwaysReady(FunctionAlwaysReadyConfig[] alwaysReady) {
                this.alwaysReady = alwaysReady;
                return this;
            }

            public FunctionScaleAndConcurrencyBuilder maximumInstanceCount(Integer maximumInstanceCount) {
                this.maximumInstanceCount = maximumInstanceCount;
                return this;
            }

            public FunctionScaleAndConcurrencyBuilder instanceMemoryMB(Integer instanceMemoryMB) {
                this.instanceMemoryMB = instanceMemoryMB;
                return this;
            }

            public FunctionScaleAndConcurrencyBuilder triggers(FunctionTriggers triggers) {
                this.triggers = triggers;
                return this;
            }

            public FunctionScaleAndConcurrency build() {
                return new FunctionScaleAndConcurrency(this.alwaysReady, this.maximumInstanceCount, this.instanceMemoryMB, this.triggers);
            }

            public String toString() {
                return "FunctionAppConfig.FunctionScaleAndConcurrency.FunctionScaleAndConcurrencyBuilder(alwaysReady=" + Arrays.deepToString(this.alwaysReady) + ", maximumInstanceCount=" + this.maximumInstanceCount + ", instanceMemoryMB=" + this.instanceMemoryMB + ", triggers=" + this.triggers + ")";
            }
        }
    }

    public static class FunctionsRuntime {
        public static final FunctionsRuntime DEFAULT_RUNTIME = FunctionsRuntime.builder().name("java").version("17").build();
        private String name;
        private String version;

        private static String $default$name() {
            return "java";
        }

        public static FunctionsRuntimeBuilder builder() {
            return new FunctionsRuntimeBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionsRuntime)) {
                return false;
            }
            FunctionsRuntime other = (FunctionsRuntime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionsRuntime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.FunctionsRuntime(name=" + this.getName() + ", version=" + this.getVersion() + ")";
        }

        public FunctionsRuntime() {
            this.name = FunctionsRuntime.$default$name();
        }

        public FunctionsRuntime(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public static class FunctionsRuntimeBuilder {
            private boolean name$set;
            private String name$value;
            private String version;

            FunctionsRuntimeBuilder() {
            }

            public FunctionsRuntimeBuilder name(String name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            public FunctionsRuntimeBuilder version(String version) {
                this.version = version;
                return this;
            }

            public FunctionsRuntime build() {
                String name$value = this.name$value;
                if (!this.name$set) {
                    name$value = FunctionsRuntime.$default$name();
                }
                return new FunctionsRuntime(name$value, this.version);
            }

            public String toString() {
                return "FunctionAppConfig.FunctionsRuntime.FunctionsRuntimeBuilder(name$value=" + this.name$value + ", version=" + this.version + ")";
            }
        }
    }

    public static class Storage {
        public static final Storage DEFAULT_STORAGE = Storage.builder().authentication(Authentication.DEFAULT_AUTHENTICATION).build();
        private Type type;
        private String value;
        private Authentication authentication;

        private static Type $default$type() {
            return Type.blobContainer;
        }

        public static StorageBuilder builder() {
            return new StorageBuilder();
        }

        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Storage)) {
                return false;
            }
            Storage other = (Storage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Authentication this$authentication = this.getAuthentication();
            Authentication other$authentication = other.getAuthentication();
            return !(this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Storage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Authentication $authentication = this.getAuthentication();
            result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.Storage(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ", authentication=" + this.getAuthentication() + ")";
        }

        public Storage() {
            this.type = Storage.$default$type();
        }

        public Storage(Type type, String value, Authentication authentication) {
            this.type = type;
            this.value = value;
            this.authentication = authentication;
        }

        public static class StorageBuilder {
            private boolean type$set;
            private Type type$value;
            private String value;
            private Authentication authentication;

            StorageBuilder() {
            }

            public StorageBuilder type(Type type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            public StorageBuilder value(String value) {
                this.value = value;
                return this;
            }

            public StorageBuilder authentication(Authentication authentication) {
                this.authentication = authentication;
                return this;
            }

            public Storage build() {
                Type type$value = this.type$value;
                if (!this.type$set) {
                    type$value = Storage.$default$type();
                }
                return new Storage(type$value, this.value, this.authentication);
            }

            public String toString() {
                return "FunctionAppConfig.Storage.StorageBuilder(type$value=" + (Object)((Object)this.type$value) + ", value=" + this.value + ", authentication=" + this.authentication + ")";
            }
        }

        public static enum Type {
            blobContainer;

        }

        public static class Authentication {
            public static final String DEPLOYMENT_STORAGE_CONNECTION_STRING = "DEPLOYMENT_STORAGE_CONNECTION_STRING";
            public static final Authentication DEFAULT_AUTHENTICATION = Authentication.builder().type(StorageAuthenticationMethod.StorageAccountConnectionString).storageAccountConnectionStringName("DEPLOYMENT_STORAGE_CONNECTION_STRING").build();
            private StorageAuthenticationMethod type;
            private String userAssignedIdentityResourceId;
            private String storageAccountConnectionStringName;

            @Nullable
            public static Authentication fromConfiguration(FlexConsumptionConfiguration configuration) {
                if (Objects.isNull((Object)configuration.getAuthenticationMethod())) {
                    return null;
                }
                switch (configuration.getAuthenticationMethod()) {
                    case StorageAccountConnectionString: {
                        return Authentication.builder().type(StorageAuthenticationMethod.StorageAccountConnectionString).userAssignedIdentityResourceId(null).storageAccountConnectionStringName(configuration.getStorageAccountConnectionString()).build();
                    }
                    case UserAssignedIdentity: {
                        return Authentication.builder().type(StorageAuthenticationMethod.UserAssignedIdentity).userAssignedIdentityResourceId(configuration.getUserAssignedIdentityResourceId()).storageAccountConnectionStringName(null).build();
                    }
                    case SystemAssignedIdentity: {
                        return Authentication.builder().type(StorageAuthenticationMethod.SystemAssignedIdentity).userAssignedIdentityResourceId(null).storageAccountConnectionStringName(null).build();
                    }
                }
                throw new AzureToolkitRuntimeException("Unsupported authentication method: " + (Object)((Object)configuration.getAuthenticationMethod()));
            }

            private static StorageAuthenticationMethod $default$type() {
                return StorageAuthenticationMethod.StorageAccountConnectionString;
            }

            private static String $default$storageAccountConnectionStringName() {
                return DEPLOYMENT_STORAGE_CONNECTION_STRING;
            }

            public static AuthenticationBuilder builder() {
                return new AuthenticationBuilder();
            }

            public StorageAuthenticationMethod getType() {
                return this.type;
            }

            public String getUserAssignedIdentityResourceId() {
                return this.userAssignedIdentityResourceId;
            }

            public String getStorageAccountConnectionStringName() {
                return this.storageAccountConnectionStringName;
            }

            public void setType(StorageAuthenticationMethod type) {
                this.type = type;
            }

            public void setUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
                this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
            }

            public void setStorageAccountConnectionStringName(String storageAccountConnectionStringName) {
                this.storageAccountConnectionStringName = storageAccountConnectionStringName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Authentication)) {
                    return false;
                }
                Authentication other = (Authentication)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StorageAuthenticationMethod this$type = this.getType();
                StorageAuthenticationMethod other$type = other.getType();
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$userAssignedIdentityResourceId = this.getUserAssignedIdentityResourceId();
                String other$userAssignedIdentityResourceId = other.getUserAssignedIdentityResourceId();
                if (this$userAssignedIdentityResourceId == null ? other$userAssignedIdentityResourceId != null : !this$userAssignedIdentityResourceId.equals(other$userAssignedIdentityResourceId)) {
                    return false;
                }
                String this$storageAccountConnectionStringName = this.getStorageAccountConnectionStringName();
                String other$storageAccountConnectionStringName = other.getStorageAccountConnectionStringName();
                return !(this$storageAccountConnectionStringName == null ? other$storageAccountConnectionStringName != null : !this$storageAccountConnectionStringName.equals(other$storageAccountConnectionStringName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Authentication;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StorageAuthenticationMethod $type = this.getType();
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $userAssignedIdentityResourceId = this.getUserAssignedIdentityResourceId();
                result = result * 59 + ($userAssignedIdentityResourceId == null ? 43 : $userAssignedIdentityResourceId.hashCode());
                String $storageAccountConnectionStringName = this.getStorageAccountConnectionStringName();
                result = result * 59 + ($storageAccountConnectionStringName == null ? 43 : $storageAccountConnectionStringName.hashCode());
                return result;
            }

            public String toString() {
                return "FunctionAppConfig.Storage.Authentication(type=" + (Object)((Object)this.getType()) + ", userAssignedIdentityResourceId=" + this.getUserAssignedIdentityResourceId() + ", storageAccountConnectionStringName=" + this.getStorageAccountConnectionStringName() + ")";
            }

            public Authentication() {
                this.type = Authentication.$default$type();
                this.storageAccountConnectionStringName = Authentication.$default$storageAccountConnectionStringName();
            }

            public Authentication(StorageAuthenticationMethod type, String userAssignedIdentityResourceId, String storageAccountConnectionStringName) {
                this.type = type;
                this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
                this.storageAccountConnectionStringName = storageAccountConnectionStringName;
            }

            public static class AuthenticationBuilder {
                private boolean type$set;
                private StorageAuthenticationMethod type$value;
                private String userAssignedIdentityResourceId;
                private boolean storageAccountConnectionStringName$set;
                private String storageAccountConnectionStringName$value;

                AuthenticationBuilder() {
                }

                public AuthenticationBuilder type(StorageAuthenticationMethod type) {
                    this.type$value = type;
                    this.type$set = true;
                    return this;
                }

                public AuthenticationBuilder userAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
                    this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
                    return this;
                }

                public AuthenticationBuilder storageAccountConnectionStringName(String storageAccountConnectionStringName) {
                    this.storageAccountConnectionStringName$value = storageAccountConnectionStringName;
                    this.storageAccountConnectionStringName$set = true;
                    return this;
                }

                public Authentication build() {
                    StorageAuthenticationMethod type$value = this.type$value;
                    if (!this.type$set) {
                        type$value = Authentication.$default$type();
                    }
                    String storageAccountConnectionStringName$value = this.storageAccountConnectionStringName$value;
                    if (!this.storageAccountConnectionStringName$set) {
                        storageAccountConnectionStringName$value = Authentication.$default$storageAccountConnectionStringName();
                    }
                    return new Authentication(type$value, this.userAssignedIdentityResourceId, storageAccountConnectionStringName$value);
                }

                public String toString() {
                    return "FunctionAppConfig.Storage.Authentication.AuthenticationBuilder(type$value=" + (Object)((Object)this.type$value) + ", userAssignedIdentityResourceId=" + this.userAssignedIdentityResourceId + ", storageAccountConnectionStringName$value=" + this.storageAccountConnectionStringName$value + ")";
                }
            }
        }
    }

    public static class FunctionsDeployment {
        public static final FunctionsDeployment DEFAULT_DEPLOYMENT = FunctionsDeployment.builder().storage(Storage.DEFAULT_STORAGE).build();
        private Storage storage;

        public static FunctionsDeploymentBuilder builder() {
            return new FunctionsDeploymentBuilder();
        }

        public Storage getStorage() {
            return this.storage;
        }

        public void setStorage(Storage storage) {
            this.storage = storage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionsDeployment)) {
                return false;
            }
            FunctionsDeployment other = (FunctionsDeployment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Storage this$storage = this.getStorage();
            Storage other$storage = other.getStorage();
            return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionsDeployment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Storage $storage = this.getStorage();
            result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppConfig.FunctionsDeployment(storage=" + this.getStorage() + ")";
        }

        public FunctionsDeployment() {
        }

        public FunctionsDeployment(Storage storage) {
            this.storage = storage;
        }

        public static class FunctionsDeploymentBuilder {
            private Storage storage;

            FunctionsDeploymentBuilder() {
            }

            public FunctionsDeploymentBuilder storage(Storage storage) {
                this.storage = storage;
                return this;
            }

            public FunctionsDeployment build() {
                return new FunctionsDeployment(this.storage);
            }

            public String toString() {
                return "FunctionAppConfig.FunctionsDeployment.FunctionsDeploymentBuilder(storage=" + this.storage + ")";
            }
        }
    }
}

