/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.entity;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionEntity {
    public static final Action.Id<FunctionEntity> TRIGGER_FUNCTION = Action.Id.of((String)"user/function.trigger_func.trigger");
    public static final Action.Id<FunctionEntity> TRIGGER_FUNCTION_IN_BROWSER = Action.Id.of((String)"user/function.trigger_func_in_browser.trigger");
    public static final String HTTP_TRIGGER = "httptrigger";
    private final String triggerId;
    private final String functionAppId;
    private final String name;
    private final String scriptFile;
    private final String entryPoint;
    private final String triggerUrl;
    private final List<BindingEntity> bindingList;

    @Nullable
    public BindingEntity getTrigger() {
        if (CollectionUtils.isEmpty(this.bindingList)) {
            return null;
        }
        return this.bindingList.stream().filter(bindingResource -> StringUtils.equalsIgnoreCase((CharSequence)bindingResource.getDirection(), (CharSequence)"in") && StringUtils.containsIgnoreCase((CharSequence)bindingResource.getType(), (CharSequence)"trigger")).findFirst().orElse(null);
    }

    public boolean isHttpTrigger() {
        String triggerType = Optional.ofNullable(this.getTrigger()).map(functionTrigger -> functionTrigger.getProperty("type")).orElse(null);
        return StringUtils.equalsIgnoreCase((CharSequence)triggerType, (CharSequence)HTTP_TRIGGER);
    }

    protected FunctionEntity(FunctionEntityBuilder<?, ?> b) {
        this.triggerId = ((FunctionEntityBuilder)b).triggerId;
        this.functionAppId = ((FunctionEntityBuilder)b).functionAppId;
        this.name = ((FunctionEntityBuilder)b).name;
        this.scriptFile = ((FunctionEntityBuilder)b).scriptFile;
        this.entryPoint = ((FunctionEntityBuilder)b).entryPoint;
        this.triggerUrl = ((FunctionEntityBuilder)b).triggerUrl;
        this.bindingList = ((FunctionEntityBuilder)b).bindingList;
    }

    public static FunctionEntityBuilder<?, ?> builder() {
        return new FunctionEntityBuilderImpl();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getFunctionAppId() {
        return this.functionAppId;
    }

    public String getName() {
        return this.name;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String getTriggerUrl() {
        return this.triggerUrl;
    }

    public List<BindingEntity> getBindingList() {
        return this.bindingList;
    }

    private static final class FunctionEntityBuilderImpl
    extends FunctionEntityBuilder<FunctionEntity, FunctionEntityBuilderImpl> {
        private FunctionEntityBuilderImpl() {
        }

        @Override
        protected FunctionEntityBuilderImpl self() {
            return this;
        }

        @Override
        public FunctionEntity build() {
            return new FunctionEntity(this);
        }
    }

    public static abstract class FunctionEntityBuilder<C extends FunctionEntity, B extends FunctionEntityBuilder<C, B>> {
        private String triggerId;
        private String functionAppId;
        private String name;
        private String scriptFile;
        private String entryPoint;
        private String triggerUrl;
        private List<BindingEntity> bindingList;

        protected abstract B self();

        public abstract C build();

        public B triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this.self();
        }

        public B functionAppId(String functionAppId) {
            this.functionAppId = functionAppId;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B scriptFile(String scriptFile) {
            this.scriptFile = scriptFile;
            return this.self();
        }

        public B entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this.self();
        }

        public B triggerUrl(String triggerUrl) {
            this.triggerUrl = triggerUrl;
            return this.self();
        }

        public B bindingList(List<BindingEntity> bindingList) {
            this.bindingList = bindingList;
            return this.self();
        }

        public String toString() {
            return "FunctionEntity.FunctionEntityBuilder(triggerId=" + this.triggerId + ", functionAppId=" + this.functionAppId + ", name=" + this.name + ", scriptFile=" + this.scriptFile + ", entryPoint=" + this.entryPoint + ", triggerUrl=" + this.triggerUrl + ", bindingList=" + this.bindingList + ")";
        }
    }

    public static class BindingEntity {
        private final String type;
        private final String direction;
        private final String name;
        private final Map<String, String> properties;

        public String getProperty(String key) {
            return Optional.ofNullable(this.properties).map(map -> (String)map.get(key)).orElse(null);
        }

        protected BindingEntity(BindingEntityBuilder<?, ?> b) {
            this.type = ((BindingEntityBuilder)b).type;
            this.direction = ((BindingEntityBuilder)b).direction;
            this.name = ((BindingEntityBuilder)b).name;
            this.properties = ((BindingEntityBuilder)b).properties;
        }

        public static BindingEntityBuilder<?, ?> builder() {
            return new BindingEntityBuilderImpl();
        }

        public BindingEntityBuilder<?, ?> toBuilder() {
            return new BindingEntityBuilderImpl().$fillValuesFrom(this);
        }

        public String getType() {
            return this.type;
        }

        public String getDirection() {
            return this.direction;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        private static final class BindingEntityBuilderImpl
        extends BindingEntityBuilder<BindingEntity, BindingEntityBuilderImpl> {
            private BindingEntityBuilderImpl() {
            }

            @Override
            protected BindingEntityBuilderImpl self() {
                return this;
            }

            @Override
            public BindingEntity build() {
                return new BindingEntity(this);
            }
        }

        public static abstract class BindingEntityBuilder<C extends BindingEntity, B extends BindingEntityBuilder<C, B>> {
            private String type;
            private String direction;
            private String name;
            private Map<String, String> properties;

            protected B $fillValuesFrom(C instance) {
                BindingEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            private static void $fillValuesFromInstanceIntoBuilder(BindingEntity instance, BindingEntityBuilder<?, ?> b) {
                b.type(instance.type);
                b.direction(instance.direction);
                b.name(instance.name);
                b.properties(instance.properties);
            }

            protected abstract B self();

            public abstract C build();

            public B type(String type) {
                this.type = type;
                return this.self();
            }

            public B direction(String direction) {
                this.direction = direction;
                return this.self();
            }

            public B name(String name) {
                this.name = name;
                return this.self();
            }

            public B properties(Map<String, String> properties) {
                this.properties = properties;
                return this.self();
            }

            public String toString() {
                return "FunctionEntity.BindingEntity.BindingEntityBuilder(type=" + this.type + ", direction=" + this.direction + ", name=" + this.name + ", properties=" + this.properties + ")";
            }
        }
    }
}

