/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.time.Period;

public class AzureStorageHelper {
    private static final int SAS_START_RESERVE_MINUTE = 5;
    private static final String FAIL_TO_DELETE_BLOB = "Fail to delete blob";
    private static final String FAIL_TO_UPLOAD_BLOB = "Fail to upload file as blob";
    private static final String FAIL_TO_GENERATE_BLOB_SAS_TOKEN = "Fail to generate blob sas token";

    public static BlobClient uploadFileAsBlob(File fileToUpload, BlobServiceClient blobServiceClient, String containerName, String blobName) {
        try {
            BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(containerName);
            blobContainer.createIfNotExists();
            BlobClient blob = blobContainer.getBlobClient(blobName);
            blob.upload((InputStream)new FileInputStream(fileToUpload), fileToUpload.length());
            return blob;
        }
        catch (IOException e) {
            throw new AzureToolkitRuntimeException(FAIL_TO_UPLOAD_BLOB, (Throwable)e);
        }
    }

    public static void deleteBlob(BlobServiceClient blobServiceClient, String containerName, String blobName) {
        BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(containerName);
        if (blobContainer.exists()) {
            BlobClient blob = blobContainer.getBlobClient(blobName);
            blob.deleteIfExists();
        }
    }

    public static String getSASToken(BlobClient blob, Period period) {
        BlobServiceSasSignatureValues policy = new BlobServiceSasSignatureValues();
        policy.setPermissions(new BlobSasPermission().setReadPermission(true));
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime sasStartTime = now.minusMinutes(5L);
        OffsetDateTime sasExpireTime = now.plus(period);
        policy.setStartTime(sasStartTime);
        policy.setExpiryTime(sasExpireTime);
        String sas = blob.generateSas(policy);
        String url = blob.getBlobUrl().toString();
        return String.format("%s?%s", url, sas);
    }
}

