/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight;
import com.microsoft.azure.toolkit.lib.applicationinsights.task.GetOrCreateApplicationInsightsTask;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotDraft;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanDraft;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule;
import com.microsoft.azure.toolkit.lib.containerapps.model.EnvironmentType;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import com.microsoft.azure.toolkit.lib.storage.AzureStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountDraft;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountModule;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainer;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerDraft;
import com.microsoft.azure.toolkit.lib.storage.model.Kind;
import com.microsoft.azure.toolkit.lib.storage.model.Redundancy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CreateOrUpdateFunctionAppTask
extends AzureTask<FunctionAppBase<?, ?, ?>> {
    public static final String APPINSIGHTS_INSTRUMENTATION_KEY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    private static final String APPLICATION_INSIGHTS_CREATE_FAILED = "Unable to create the Application Insights for the Function App due to error %s. Please use the Azure Portal to manually create and configure the Application Insights if needed.";
    private static final String FUNCTIONS_WORKER_RUNTIME_NAME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String FUNCTIONS_WORKER_RUNTIME_VALUE = "java";
    private static final String SET_FUNCTIONS_WORKER_RUNTIME = "Set function worker runtime to java.";
    private static final String CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING = "App setting `FUNCTIONS_WORKER_RUNTIME` doesn't meet the requirement of Azure Java Functions, the value should be `java`.";
    private static final String FUNCTIONS_EXTENSION_VERSION_NAME = "FUNCTIONS_EXTENSION_VERSION";
    private static final String FUNCTIONS_EXTENSION_VERSION_VALUE = "~4";
    private static final String SET_FUNCTIONS_EXTENSION_VERSION = "Functions extension version isn't configured, setting up the default value.";
    private static final String FUNCTION_APP_NOT_EXIST_FOR_SLOT = "The Function App specified in pom.xml does not exist. Please make sure the Function App name is correct.";
    public static final String FLEX_CONSUMPTION_SLOT_NOT_SUPPORT = "Deployment slot is not supported for function app with flex consumption plan.";
    public static final String DEPLOYMENT_CONTAINER_NAME_MISSED = "Failed to get deployment container from app %s, please either set it manually in tooling or correct the value in Azure";
    private final FunctionAppConfig functionAppConfig;
    private final List<AzureTask<?>> tasks = new ArrayList();
    private ResourceGroup resourceGroup;
    private AppServicePlan appServicePlan;
    private StorageAccount storageAccount;
    private StorageAccount deploymentStorageAccount;
    private BlobContainer deploymentContainer;
    private ContainerAppsEnvironment environment;
    private String instrumentationKey;
    private ApplicationInsight applicationInsight;
    private FunctionAppBase<?, ?, ?> functionApp;

    public CreateOrUpdateFunctionAppTask(@Nonnull FunctionAppConfig config) {
        this.functionAppConfig = config;
        this.initTasks();
    }

    private void initTasks() {
        boolean isInstrumentKeyConfigured;
        FunctionAppDraft appDraft = (FunctionAppDraft)((AzureFunctions)Azure.az(AzureFunctions.class)).functionApps(this.functionAppConfig.subscriptionId()).updateOrCreate(this.functionAppConfig.appName(), this.functionAppConfig.resourceGroup());
        this.registerSubTask((AzureTask)this.getResourceGroupTask(), result -> {
            this.resourceGroup = result;
        });
        if (appDraft.isDraftForCreating()) {
            String storageAccountName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.functionAppConfig.storageAccountName(), this.getDefaultStorageAccountName(this.functionAppConfig.appName())});
            String storageResourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.functionAppConfig.storageAccountResourceGroup(), this.functionAppConfig.resourceGroup()});
            this.registerSubTask(this.getStorageAccountTask(storageAccountName, storageResourceGroup), result -> {
                this.storageAccount = result;
            });
        }
        boolean bl = isInstrumentKeyConfigured = MapUtils.isNotEmpty(this.functionAppConfig.appSettings()) && this.functionAppConfig.appSettings().containsKey(APPINSIGHTS_INSTRUMENTATION_KEY);
        if (!this.functionAppConfig.disableAppInsights() && !isInstrumentKeyConfigured) {
            if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.appInsightsKey())) {
                this.instrumentationKey = this.functionAppConfig.appInsightsKey();
            } else if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.appInsightsInstance()) || !appDraft.exists()) {
                this.registerSubTask(this.getApplicationInsightsTask(), result -> {
                    this.applicationInsight = result;
                    this.instrumentationKey = Optional.ofNullable(result).map(ApplicationInsight::getInstrumentationKey).orElse(null);
                });
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.functionAppConfig.environment())) {
            this.registerSubTask(this.getContainerAppEnvironmentTask(), result -> {
                this.environment = result;
            });
        } else {
            this.registerSubTask(this.getServicePlanTask(), result -> {
                this.appServicePlan = result;
            });
        }
        if (this.isFlexConsumptionFunctionApp(appDraft)) {
            this.registerSubTask(this.getDeploymentStorageAccount(appDraft), result -> {
                this.deploymentStorageAccount = result;
            });
            this.registerSubTask(this.getDeploymentStorageContainer(appDraft), result -> {
                this.deploymentContainer = result;
            });
        }
        if (StringUtils.isEmpty((CharSequence)this.functionAppConfig.deploymentSlotName())) {
            AzureTask<FunctionApp> functionTask = appDraft.exists() ? this.getUpdateFunctionAppTask(appDraft) : this.getCreateFunctionAppTask(appDraft);
            this.registerSubTask(functionTask, result -> {
                this.functionApp = result;
            });
        } else {
            FunctionAppDeploymentSlotDraft slotDraft = this.getFunctionDeploymentSlot(appDraft);
            AzureTask<FunctionAppDeploymentSlot> slotTask = slotDraft.exists() ? this.getUpdateFunctionSlotTask(slotDraft) : this.getCreateFunctionSlotTask(slotDraft);
            this.registerSubTask(slotTask, result -> {
                this.functionApp = result;
            });
        }
    }

    private AzureTask<BlobContainer> getDeploymentStorageContainer(FunctionAppDraft appDraft) {
        return new AzureTask(() -> {
            FlexConsumptionConfiguration flexConfiguration = this.functionAppConfig.flexConsumptionConfiguration();
            String containerName = Optional.ofNullable(flexConfiguration).map(FlexConsumptionConfiguration::getDeploymentContainer).orElseGet(() -> this.getDeploymentContainerNameFromApp(appDraft));
            BlobContainer container = (BlobContainer)this.deploymentStorageAccount.getBlobContainerModule().getOrDraft(containerName, this.functionAppConfig.resourceGroup());
            if (container.isDraftForCreating()) {
                ((BlobContainerDraft)container).commit();
            }
            return container;
        });
    }

    private String getDeploymentContainerNameFromApp(FunctionAppDraft appDraft) {
        if (appDraft.isDraftForCreating()) {
            String prefix = "app-package";
            String appName = StringUtils.substringBefore((String)this.functionAppConfig.appName().replaceAll("[^a-zA-Z0-9]", ""), (int)32);
            String randomNum = String.valueOf(new Random().nextInt(1000000));
            return "app-package-" + appName + "-" + randomNum;
        }
        return Optional.ofNullable(appDraft.getFlexConsumptionConfiguration()).map(FlexConsumptionConfiguration::getDeploymentContainer).orElseThrow(() -> new AzureToolkitRuntimeException(String.format(DEPLOYMENT_CONTAINER_NAME_MISSED, this.functionAppConfig.appName())));
    }

    private AzureTask<StorageAccount> getDeploymentStorageAccount(FunctionAppDraft appDraft) {
        FlexConsumptionConfiguration flexConsumptionConfiguration = this.functionAppConfig.flexConsumptionConfiguration();
        String accountName = Optional.ofNullable(flexConsumptionConfiguration).map(FlexConsumptionConfiguration::getDeploymentAccount).orElse(null);
        String resourceGroupName = Optional.ofNullable(flexConsumptionConfiguration).map(FlexConsumptionConfiguration::getDeploymentResourceGroup).orElse(this.functionAppConfig.resourceGroup());
        if (StringUtils.isBlank((CharSequence)accountName)) {
            return new AzureTask(() -> this.getDeploymentStorageFromApp(appDraft));
        }
        ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(this.functionAppConfig.subscriptionId()).getOrDraft(resourceGroupName, resourceGroupName);
        if (!resourceGroup.exists()) {
            Region region = CreateOrUpdateFunctionAppTask.getNonStageRegion(this.functionAppConfig.region());
            this.registerSubTask((AzureTask)new CreateResourceGroupTask(this.functionAppConfig.subscriptionId(), resourceGroupName, region), result -> {
                this.resourceGroup = result;
            });
        }
        return this.getStorageAccountTask(accountName, resourceGroupName);
    }

    private StorageAccount getDeploymentStorageFromApp(FunctionAppDraft appDraft) {
        if (appDraft.isDraftForCreating()) {
            return this.storageAccount;
        }
        FlexConsumptionConfiguration flexConsumptionConfiguration = appDraft.getFlexConsumptionConfiguration();
        if (flexConsumptionConfiguration == null) {
            return this.storageAccount;
        }
        return (StorageAccount)((StorageServiceSubscription)((AzureStorageAccount)Azure.az(AzureStorageAccount.class)).forSubscription(appDraft.getSubscriptionId())).storageAccounts().get(flexConsumptionConfiguration.getDeploymentAccount(), flexConsumptionConfiguration.getDeploymentResourceGroup());
    }

    private boolean isFlexConsumptionFunctionApp(FunctionAppDraft appDraft) {
        if (appDraft.isDraftForCreating()) {
            return Optional.ofNullable(this.functionAppConfig.getPricingTier()).map(PricingTier::isFlexConsumption).orElse(false);
        }
        return Optional.ofNullable(appDraft.getAppServicePlan()).map(AppServicePlan::getPricingTier).map(PricingTier::isFlexConsumption).orElse(false);
    }

    private AzureTask<ContainerAppsEnvironment> getContainerAppEnvironmentTask() {
        return new AzureTask(() -> {
            String environmentName = this.functionAppConfig.environment();
            String resourceGroupName = this.functionAppConfig.resourceGroup();
            ContainerAppsEnvironmentModule environments = ((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(this.functionAppConfig.subscriptionId());
            ContainerAppsEnvironment environment = (ContainerAppsEnvironment)environments.get(environmentName, resourceGroupName);
            if (environment != null && environment.exists()) {
                return environment;
            }
            ContainerAppsEnvironmentDraft draft = (ContainerAppsEnvironmentDraft)environments.create(environmentName, resourceGroupName);
            ContainerAppsEnvironmentDraft.Config config = this.functionAppConfig.environmentConfig();
            config.setName((String)ObjectUtils.firstNonNull((Object[])new String[]{config.getName(), environmentName}));
            config.setRegion((Region)ObjectUtils.firstNonNull((Object[])new Region[]{config.getRegion(), CreateOrUpdateFunctionAppTask.getNonStageRegion(this.functionAppConfig.region())}));
            config.setResourceGroup((ResourceGroup)ObjectUtils.firstNonNull((Object[])new ResourceGroup[]{config.getResourceGroup(), this.resourceGroup}));
            LogAnalyticsWorkspace logAnalyticsWorkspace = Optional.ofNullable(this.applicationInsight).map(ApplicationInsight::getWorkspace).orElse(null);
            config.setLogAnalyticsWorkspace((LogAnalyticsWorkspace)ObjectUtils.firstNonNull((Object[])new LogAnalyticsWorkspace[]{config.getLogAnalyticsWorkspace(), logAnalyticsWorkspace}));
            config.setEnvironmentType((EnvironmentType)ObjectUtils.firstNonNull((Object[])new EnvironmentType[]{config.getEnvironmentType(), EnvironmentType.WorkloadProfiles}));
            draft.setConfig(config);
            return (ContainerAppsEnvironment)draft.commit();
        });
    }

    private AzureTask<StorageAccount> getStorageAccountTask(String storageAccountName, String storageResourceGroup) {
        return new AzureTask(() -> {
            StorageAccountModule accounts = ((AzureStorageAccount)Azure.az(AzureStorageAccount.class)).accounts(this.functionAppConfig.subscriptionId());
            StorageAccount existingAccount = (StorageAccount)accounts.get(storageAccountName, storageResourceGroup);
            if (existingAccount != null && existingAccount.exists()) {
                return existingAccount;
            }
            StorageAccountDraft draft = (StorageAccountDraft)accounts.create(storageAccountName, storageResourceGroup);
            draft.setRegion(CreateOrUpdateFunctionAppTask.getNonStageRegion(this.functionAppConfig.region()));
            draft.setKind(Kind.STORAGE_V2);
            draft.setRedundancy(Redundancy.STANDARD_LRS);
            return (StorageAccount)draft.commit();
        });
    }

    private String getDefaultStorageAccountName(@Nonnull String functionAppName) {
        ResourceManagerUtils.InternalRuntimeContext context = new ResourceManagerUtils.InternalRuntimeContext();
        return context.randomResourceName(functionAppName.replaceAll("[^a-zA-Z0-9]", ""), 20);
    }

    private static Region getNonStageRegion(@Nonnull Region region) {
        String regionName = region.getName();
        if (!StringUtils.containsIgnoreCase((CharSequence)regionName, (CharSequence)"stage")) {
            return region;
        }
        return Optional.of(regionName).map(name -> StringUtils.removeIgnoreCase((String)name, (String)"(stage)")).map(name -> StringUtils.removeIgnoreCase((String)name, (String)"stage")).map(StringUtils::trim).map(Region::fromName).orElse(region);
    }

    private <T> void registerSubTask(AzureTask<T> task, Consumer<T> consumer) {
        if (task != null) {
            this.tasks.add(new AzureTask(() -> {
                Object result = task.getBody().call();
                consumer.accept(result);
                return result;
            }));
        }
    }

    private AzureTask<FunctionApp> getCreateFunctionAppTask(FunctionAppDraft draft) {
        AzureString title = AzureString.format((String)"Create new app({0}) on subscription({1})", (Object[])new Object[]{this.functionAppConfig.appName(), this.functionAppConfig.subscriptionId()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            Optional.ofNullable(this.instrumentationKey).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).ifPresent(key -> appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, (String)key));
            draft.setAppServicePlan(this.appServicePlan);
            draft.setRegion(this.functionAppConfig.region());
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setAppSettings(appSettings);
            draft.setDiagnosticConfig(this.functionAppConfig.diagnosticConfig());
            draft.setEnableDistributedTracing(this.functionAppConfig.enableDistributedTracing());
            draft.setFlexConsumptionConfiguration(this.functionAppConfig.flexConsumptionConfiguration());
            draft.setDeploymentAccount(this.deploymentStorageAccount);
            draft.setDeploymentContainer(this.deploymentContainer);
            draft.setStorageAccount(this.storageAccount);
            draft.setEnvironment(this.environment);
            draft.setContainerConfiguration(this.functionAppConfig.containerConfiguration());
            draft.setSkipEndOfLifeValidation(this.functionAppConfig.getSkipEndOfLifeValidation());
            FunctionApp result = (FunctionApp)draft.createIfNotExist();
            Thread.sleep(10000L);
            return result;
        });
    }

    private Map<String, String> processAppSettingsWithDefaultValue() {
        Map appSettings = Optional.ofNullable(this.functionAppConfig.appSettings()).orElseGet(HashMap::new);
        this.setDefaultAppSetting(appSettings, FUNCTIONS_EXTENSION_VERSION_NAME, SET_FUNCTIONS_EXTENSION_VERSION, FUNCTIONS_EXTENSION_VERSION_VALUE, null);
        OperatingSystem os = Optional.ofNullable(this.functionAppConfig.runtime()).map(RuntimeConfig::getOs).orElse(null);
        if (os != OperatingSystem.DOCKER) {
            this.setDefaultAppSetting(appSettings, FUNCTIONS_WORKER_RUNTIME_NAME, SET_FUNCTIONS_WORKER_RUNTIME, FUNCTIONS_WORKER_RUNTIME_VALUE, CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING);
        }
        return appSettings;
    }

    private void setDefaultAppSetting(@Nonnull Map<String, String> result, @Nonnull String settingName, @Nonnull String emptyMessage, @Nonnull String defaultValue, @Nullable String warningMessage) {
        String setting = result.get(settingName);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            AzureMessager.getMessager().info(emptyMessage);
            result.put(settingName, defaultValue);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)setting, (CharSequence)defaultValue) && StringUtils.isNotEmpty((CharSequence)warningMessage)) {
            AzureMessager.getMessager().warning(warningMessage);
        }
    }

    private AzureTask<FunctionApp> getUpdateFunctionAppTask(FunctionAppDraft draft) {
        AzureString title = AzureString.format((String)"Update function app({0})", (Object[])new Object[]{this.functionAppConfig.appName()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            if (this.functionAppConfig.disableAppInsights()) {
                draft.removeAppSetting(APPINSIGHTS_INSTRUMENTATION_KEY);
            } else if (StringUtils.isNotEmpty((CharSequence)this.instrumentationKey)) {
                appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.instrumentationKey);
            }
            draft.setAppServicePlan(this.appServicePlan);
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setAppSettings(appSettings);
            draft.setDiagnosticConfig(this.functionAppConfig.diagnosticConfig());
            draft.removeAppSettings(this.functionAppConfig.appSettingsToRemove());
            draft.setFlexConsumptionConfiguration(this.functionAppConfig.flexConsumptionConfiguration());
            draft.setDeploymentAccount(this.deploymentStorageAccount);
            draft.setDeploymentContainer(this.deploymentContainer);
            draft.setEnableDistributedTracing(this.functionAppConfig.enableDistributedTracing());
            draft.setStorageAccount(this.storageAccount);
            draft.setContainerConfiguration(this.functionAppConfig.containerConfiguration());
            return (FunctionApp)draft.updateIfExist();
        });
    }

    private AzureTask<FunctionAppDeploymentSlot> getCreateFunctionSlotTask(FunctionAppDeploymentSlotDraft draft) {
        AzureString title = AzureString.format((String)"Create new slot({0}) on function app ({1})", (Object[])new Object[]{this.functionAppConfig.deploymentSlotName(), this.functionAppConfig.appName()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            Optional.ofNullable(this.instrumentationKey).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).ifPresent(key -> appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, (String)key));
            draft.setAppSettings(appSettings);
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDiagnosticConfig(this.functionAppConfig.diagnosticConfig());
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setConfigurationSource(this.functionAppConfig.deploymentSlotConfigurationSource());
            draft.removeAppSettings(this.functionAppConfig.appSettingsToRemove());
            return (FunctionAppDeploymentSlot)draft.commit();
        });
    }

    private AzureTask<FunctionAppDeploymentSlot> getUpdateFunctionSlotTask(FunctionAppDeploymentSlotDraft draft) {
        AzureString title = AzureString.format((String)"Update function deployment slot({0})", (Object[])new Object[]{this.functionAppConfig.deploymentSlotName()});
        return new AzureTask(title, () -> {
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            if (this.functionAppConfig.disableAppInsights()) {
                draft.removeAppSetting(APPINSIGHTS_INSTRUMENTATION_KEY);
            } else if (StringUtils.isNotEmpty((CharSequence)this.instrumentationKey)) {
                appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.instrumentationKey);
            }
            draft.setRuntime(this.getRuntime(this.functionAppConfig.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime()));
            draft.setDiagnosticConfig(this.functionAppConfig.diagnosticConfig());
            draft.setAppSettings(appSettings);
            draft.removeAppSettings(this.functionAppConfig.appSettingsToRemove());
            return (FunctionAppDeploymentSlot)draft.commit();
        });
    }

    private FunctionAppDeploymentSlotDraft getFunctionDeploymentSlot(FunctionApp functionApp) {
        if (!functionApp.exists()) {
            throw new AzureToolkitRuntimeException(FUNCTION_APP_NOT_EXIST_FOR_SLOT);
        }
        if (Objects.requireNonNull(functionApp.getAppServicePlan()).getPricingTier().isFlexConsumption()) {
            throw new AzureToolkitRuntimeException(FLEX_CONSUMPTION_SLOT_NOT_SUPPORT);
        }
        return (FunctionAppDeploymentSlotDraft)functionApp.slots().updateOrCreate(this.functionAppConfig.deploymentSlotName(), this.functionAppConfig.resourceGroup());
    }

    private AzureTask<ApplicationInsight> getApplicationInsightsTask() {
        return new AzureTask(() -> {
            try {
                String name = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{this.functionAppConfig.appInsightsInstance(), this.functionAppConfig.appName()});
                return (ApplicationInsight)new GetOrCreateApplicationInsightsTask(this.functionAppConfig.subscriptionId(), this.functionAppConfig.resourceGroup(), CreateOrUpdateFunctionAppTask.getNonStageRegion(this.functionAppConfig.region()), name, this.functionAppConfig.workspaceConfig()).getBody().call();
            }
            catch (Throwable e) {
                String errorMessage = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)e)).orElse(e).getMessage();
                AzureMessager.getMessager().warning(String.format(APPLICATION_INSIGHTS_CREATE_FAILED, errorMessage));
                return null;
            }
        });
    }

    private CreateResourceGroupTask getResourceGroupTask() {
        Region region = this.functionAppConfig.region();
        Region resourceGroupRegion = StringUtils.endsWith((CharSequence)region.getAbbreviation(), (CharSequence)"(stage)") ? Region.fromName((String)StringUtils.removeIgnoreCase((String)region.getName(), (String)"(stage)")) : region;
        return new CreateResourceGroupTask(this.functionAppConfig.subscriptionId(), this.functionAppConfig.resourceGroup(), resourceGroupRegion);
    }

    private AzureTask<AppServicePlan> getServicePlanTask() {
        if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.deploymentSlotName())) {
            AzureMessager.getMessager().info("Skip update app service plan for deployment slot");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.functionAppConfig.getServicePlanName())) {
            return null;
        }
        return new AzureTask(() -> {
            AzureAppService az = (AzureAppService)Azure.az(AzureAppService.class);
            AppServicePlanConfig config = FunctionAppConfig.getServicePlanConfig(this.functionAppConfig);
            AppServicePlanDraft draft = (AppServicePlanDraft)az.plans(config.getSubscriptionId()).updateOrCreate(config.getName(), config.getResourceGroupName());
            draft.setOperatingSystem(config.getOs());
            draft.setRegion(config.getRegion());
            draft.setPricingTier(config.getPricingTier());
            return (AppServicePlan)draft.commit();
        });
    }

    private FunctionAppRuntime getRuntime(RuntimeConfig runtimeConfig) {
        if (runtimeConfig == null) {
            return null;
        }
        OperatingSystem os = Optional.ofNullable(runtimeConfig.os()).orElse(OperatingSystem.LINUX);
        FunctionAppRuntime runtime = null;
        if (os == OperatingSystem.DOCKER) {
            runtime = FunctionAppDockerRuntime.INSTANCE;
        } else if (os == OperatingSystem.LINUX) {
            runtime = FunctionAppLinuxRuntime.fromJavaVersionUserText(runtimeConfig.javaVersion());
        } else if (os == OperatingSystem.WINDOWS) {
            runtime = FunctionAppWindowsRuntime.fromJavaVersionUserText(runtimeConfig.javaVersion());
        }
        if (Objects.isNull(runtime) && (Objects.nonNull((Object)runtimeConfig.os()) || StringUtils.isNotBlank((CharSequence)runtimeConfig.javaVersion()))) {
            throw new AzureToolkitRuntimeException("invalid runtime configuration, please refer to https://aka.ms/maven_function_configuration#supported-runtime for valid values");
        }
        return runtime;
    }

    private DockerConfiguration getDockerConfiguration(RuntimeConfig runtime) {
        if (OperatingSystem.DOCKER == runtime.os()) {
            return ((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)DockerConfiguration.builder().userName(runtime.username())).password(runtime.password())).registryUrl(runtime.registryUrl())).image(runtime.image())).startUpCommand(runtime.startUpCommand())).build();
        }
        return null;
    }

    public FunctionAppBase<?, ?, ?> doExecute() throws Exception {
        for (AzureTask<?> task : this.tasks) {
            task.getBody().call();
        }
        return this.functionApp;
    }
}

