/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.LinuxJavaContainerSettings;
import com.azure.resourcemanager.appservice.models.RuntimeStack;
import com.azure.resourcemanager.appservice.models.WebAppMajorVersion;
import com.azure.resourcemanager.appservice.models.WebAppMinorVersion;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class WebAppLinuxRuntime
implements WebAppRuntime {
    public static final WebAppLinuxRuntime JAVASE_JAVA21 = new WebAppLinuxRuntime("JAVA|21-java21", "Java 21");
    public static final WebAppLinuxRuntime JAVASE_JAVA17 = new WebAppLinuxRuntime("JAVA|17-java17", "Java 17");
    public static final WebAppLinuxRuntime JAVASE_JAVA11 = new WebAppLinuxRuntime("JAVA|11-java11", "Java 11");
    public static final WebAppLinuxRuntime JAVASE_JAVA8 = new WebAppLinuxRuntime("JAVA|8-jre8", "Java 1.8");
    public static final WebAppLinuxRuntime TOMCAT101_JAVA21 = new WebAppLinuxRuntime("TOMCAT|10.1-java21", "Java 21");
    public static final WebAppLinuxRuntime TOMCAT101_JAVA17 = new WebAppLinuxRuntime("TOMCAT|10.1-java17", "Java 17");
    public static final WebAppLinuxRuntime TOMCAT101_JAVA11 = new WebAppLinuxRuntime("TOMCAT|10.1-java11", "Java 11");
    public static final WebAppLinuxRuntime TOMCAT10_JAVA17 = new WebAppLinuxRuntime("TOMCAT|10.0-java17", "Java 17");
    public static final WebAppLinuxRuntime TOMCAT10_JAVA11 = new WebAppLinuxRuntime("TOMCAT|10.0-java11", "Java 11");
    public static final WebAppLinuxRuntime TOMCAT10_JAVA8 = new WebAppLinuxRuntime("TOMCAT|10.0-jre8", "Java 1.8");
    public static final WebAppLinuxRuntime TOMCAT9_JAVA21 = new WebAppLinuxRuntime("TOMCAT|9.0-java21", "Java 17");
    public static final WebAppLinuxRuntime TOMCAT9_JAVA17 = new WebAppLinuxRuntime("TOMCAT|9.0-java17", "Java 17");
    public static final WebAppLinuxRuntime TOMCAT9_JAVA11 = new WebAppLinuxRuntime("TOMCAT|9.0-java11", "Java 11");
    public static final WebAppLinuxRuntime TOMCAT9_JAVA8 = new WebAppLinuxRuntime("TOMCAT|9.0-jre8", "Java 1.8");
    public static final WebAppLinuxRuntime TOMCAT85_JAVA11 = new WebAppLinuxRuntime("TOMCAT|8.5-java11", "Java 11");
    public static final WebAppLinuxRuntime TOMCAT85_JAVA8 = new WebAppLinuxRuntime("TOMCAT|8.5-jre8", "Java 1.8");
    public static final WebAppLinuxRuntime JBOSS7_JAVA17 = new WebAppLinuxRuntime("JBOSSEAP|7-java17", "Java 17");
    public static final WebAppLinuxRuntime JBOSS7_JAVA11 = new WebAppLinuxRuntime("JBOSSEAP|7-java11", "Java 11");
    public static final WebAppLinuxRuntime JBOSS7_JAVA8 = new WebAppLinuxRuntime("JBOSSEAP|7-java8", "Java 1.8");
    public static final WebAppLinuxRuntime JBOSS8_JAVA17 = new WebAppLinuxRuntime("JBOSSEAP|8-java17", "Java 17");
    public static final WebAppLinuxRuntime JBOSS8_JAVA11 = new WebAppLinuxRuntime("JBOSSEAP|8-java11", "Java 11");
    private static final AtomicReference<Boolean> loaded = new AtomicReference<Boolean>(Boolean.FALSE);
    private static final LinkedHashSet<WebAppLinuxRuntime> RUNTIMES = Sets.newLinkedHashSet(Arrays.asList(JAVASE_JAVA21, JAVASE_JAVA17, JAVASE_JAVA11, JAVASE_JAVA8, TOMCAT101_JAVA21, TOMCAT101_JAVA17, TOMCAT101_JAVA11, TOMCAT10_JAVA17, TOMCAT10_JAVA11, TOMCAT10_JAVA8, TOMCAT9_JAVA17, TOMCAT9_JAVA11, TOMCAT9_JAVA8, TOMCAT9_JAVA21, TOMCAT85_JAVA11, TOMCAT85_JAVA8, JBOSS7_JAVA17, JBOSS7_JAVA11, JBOSS7_JAVA8, JBOSS8_JAVA11, JBOSS8_JAVA17));
    private final OperatingSystem operatingSystem = OperatingSystem.LINUX;
    private final String containerName;
    private final String containerVersionNumber;
    private final String javaVersionNumber;
    @Nonnull
    private final String fxString;
    private final boolean deprecated;
    private final boolean hidden;
    private final boolean earlyAccess;
    private final boolean autoUpdate;
    private final boolean preview;
    @Nullable
    private final OffsetDateTime endOfLifeDate;

    private WebAppLinuxRuntime(@Nonnull WebAppMinorVersion container, @Nonnull WebAppMajorVersion javaVersion, @Nonnull String fxString) {
        LinuxJavaContainerSettings containerSettings = container.stackSettings().linuxContainerSettings();
        String[] parts = fxString.split("\\|", 2);
        this.fxString = fxString;
        this.deprecated = BooleanUtils.isTrue((Boolean)containerSettings.isDeprecated());
        this.hidden = BooleanUtils.isTrue((Boolean)containerSettings.isHidden());
        this.earlyAccess = BooleanUtils.isTrue((Boolean)containerSettings.isEarlyAccess());
        this.autoUpdate = BooleanUtils.isTrue((Boolean)containerSettings.isAutoUpdate());
        this.preview = BooleanUtils.isTrue((Boolean)containerSettings.isPreview());
        this.endOfLifeDate = containerSettings.endOfLifeDate();
        this.containerName = parts[0].toUpperCase();
        this.containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") ? "SE" : container.value().toUpperCase();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") && !StringUtils.equalsIgnoreCase((CharSequence)container.value(), (CharSequence)"SE") ? parts[1] : javaVersion.value().toUpperCase());
    }

    private WebAppLinuxRuntime(Map<String, Object> container, Map<String, Object> javaVersion, String fxString) {
        Map containerSettings = (Map)Utils.get(container, (String)"$.stackSettings.linuxContainerSettings");
        String[] parts = fxString.split("\\|", 2);
        this.fxString = fxString;
        this.deprecated = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isDeprecated")));
        this.hidden = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isHidden")));
        this.earlyAccess = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isEarlyAccess")));
        this.autoUpdate = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isAutoUpdate")));
        this.preview = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isPreview")));
        CharSequence endOfLifeDateStr = (CharSequence)Utils.get((Map)containerSettings, (String)"$.endOfLifeDate");
        this.endOfLifeDate = StringUtils.isBlank((CharSequence)endOfLifeDateStr) ? null : OffsetDateTime.parse(endOfLifeDateStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.containerName = parts[0].toUpperCase();
        this.containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") ? "SE" : ((String)Utils.get(container, (String)"$.value")).toUpperCase();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") && !StringUtils.equalsIgnoreCase((CharSequence)((String)container.get("value")), (CharSequence)"SE") ? parts[1] : ((String)javaVersion.get("value")).toUpperCase());
    }

    private WebAppLinuxRuntime(String fxString, String javaVersionUserText) {
        this.fxString = fxString;
        String[] fxStringParts = fxString.split("[|-]", 3);
        String[] javaParts = javaVersionUserText.split(" ");
        this.deprecated = false;
        this.hidden = false;
        this.earlyAccess = false;
        this.autoUpdate = false;
        this.preview = false;
        this.endOfLifeDate = null;
        this.containerName = fxStringParts[0].toUpperCase();
        this.containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") ? "SE" : fxStringParts[1].toUpperCase();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(javaParts[1].toUpperCase());
    }

    public RuntimeStack toRuntimeStack() {
        String[] parts = this.fxString.split("\\|", 2);
        return new RuntimeStack(parts[0], parts[1]);
    }

    @Nullable
    public static WebAppLinuxRuntime fromFxString(String fxString) {
        return WebAppLinuxRuntime.getAllRuntimes().stream().filter(runtime -> StringUtils.equals((CharSequence)runtime.fxString, (CharSequence)fxString)).findFirst().orElse(null);
    }

    @Nullable
    public static WebAppLinuxRuntime fromContainerAndJavaVersionUserText(String pContainerUserText, String pJavaVersionUserText) {
        if (StringUtils.isBlank((CharSequence)pJavaVersionUserText)) {
            pJavaVersionUserText = "Java 17";
            AzureMessager.getMessager().warning(AzureString.format((String)"The java version is not specified, use default version '%s'", (Object[])new Object[]{"Java 17"}));
        }
        String javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(pJavaVersionUserText);
        String containerUserText = StringUtils.startsWithIgnoreCase((CharSequence)pContainerUserText, (CharSequence)"java ") ? "Java SE" : pContainerUserText;
        return WebAppLinuxRuntime.getAllRuntimes().stream().filter(r -> StringUtils.equalsAnyIgnoreCase((CharSequence)javaVersionNumber, (CharSequence[])new CharSequence[]{r.javaVersionNumber}) && StringUtils.equalsIgnoreCase((CharSequence)containerUserText, (CharSequence)String.format("%s %s", r.containerName, r.containerVersionNumber))).findFirst().orElse(null);
    }

    public static List<WebAppLinuxRuntime> getAllRuntimes() {
        WebAppRuntime.tryLoadingAllRuntimes();
        return new ArrayList<WebAppLinuxRuntime>(RUNTIMES);
    }

    @Nonnull
    public static List<WebAppLinuxRuntime> getMajorRuntimes() {
        return WebAppLinuxRuntime.getAllRuntimes().stream().filter(r -> !r.isDeprecated() && !r.isHidden() && r.isMajorVersion()).collect(Collectors.toList());
    }

    public static boolean isLoaded() {
        return loaded.get() == Boolean.TRUE;
    }

    public static boolean isLoading() {
        return loaded.get() == null;
    }

    public static void loadAllWebAppLinuxRuntimes(List<WebAppMajorVersion> javaMajorVersions, List<WebAppMajorVersion> containerMajorVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        RUNTIMES.clear();
        for (WebAppMajorVersion containerMajorVersion : containerMajorVersions) {
            for (WebAppMinorVersion containerMinorVersion : containerMajorVersion.minorVersions()) {
                LinuxJavaContainerSettings containerSettings = containerMinorVersion.stackSettings().linuxContainerSettings();
                if (!Objects.nonNull(containerSettings)) continue;
                for (WebAppMajorVersion javaMajorVersion : javaMajorVersions) {
                    if (!StringUtils.isNotBlank((CharSequence)javaMajorVersion.value())) continue;
                    try {
                        String fxString = (String)MethodUtils.invokeMethod((Object)containerSettings, (String)String.format("java%sRuntime", javaMajorVersion.value()));
                        if (!StringUtils.isNotBlank((CharSequence)fxString)) continue;
                        RUNTIMES.add(new WebAppLinuxRuntime(containerMinorVersion, javaMajorVersion, fxString));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
                }
            }
        }
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public static void loadAllWebAppLinuxRuntimesFromMap(List<Map<String, Object>> javaMajorVersions, List<Map<String, Object>> containerMajorVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        RUNTIMES.clear();
        for (Map<String, Object> containerMajorVersion : containerMajorVersions) {
            for (Map containerMinorVersion : (List)Utils.get(containerMajorVersion, (String)"$.minorVersions")) {
                Map containerSettings = (Map)Utils.get((Map)containerMinorVersion, (String)"$.stackSettings.linuxContainerSettings");
                if (!Objects.nonNull(containerSettings)) continue;
                for (Map<String, Object> javaMajorVersion : javaMajorVersions) {
                    String fxString;
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)javaMajorVersion.get("value"))) || !StringUtils.isNotBlank((CharSequence)(fxString = (String)containerSettings.get(String.format("java%sRuntime", javaMajorVersion.get("value").toString()))))) continue;
                    RUNTIMES.add(new WebAppLinuxRuntime(containerMinorVersion, javaMajorVersion, fxString));
                }
            }
        }
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public String toString() {
        return String.format("Linux | %s | %s", this.getContainerUserText(), this.getJavaVersionUserText());
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public String getContainerVersionNumber() {
        return this.containerVersionNumber;
    }

    @Override
    public String getJavaVersionNumber() {
        return this.javaVersionNumber;
    }

    @Nonnull
    public String getFxString() {
        return this.fxString;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isEarlyAccess() {
        return this.earlyAccess;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    @Nullable
    public OffsetDateTime getEndOfLifeDate() {
        return this.endOfLifeDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebAppLinuxRuntime)) {
            return false;
        }
        WebAppLinuxRuntime other = (WebAppLinuxRuntime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)((Object)this$operatingSystem)).equals((Object)other$operatingSystem)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        String this$containerVersionNumber = this.getContainerVersionNumber();
        String other$containerVersionNumber = other.getContainerVersionNumber();
        if (this$containerVersionNumber == null ? other$containerVersionNumber != null : !this$containerVersionNumber.equals(other$containerVersionNumber)) {
            return false;
        }
        String this$javaVersionNumber = this.getJavaVersionNumber();
        String other$javaVersionNumber = other.getJavaVersionNumber();
        return !(this$javaVersionNumber == null ? other$javaVersionNumber != null : !this$javaVersionNumber.equals(other$javaVersionNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebAppLinuxRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)((Object)$operatingSystem)).hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        String $containerVersionNumber = this.getContainerVersionNumber();
        result = result * 59 + ($containerVersionNumber == null ? 43 : $containerVersionNumber.hashCode());
        String $javaVersionNumber = this.getJavaVersionNumber();
        result = result * 59 + ($javaVersionNumber == null ? 43 : $javaVersionNumber.hashCode());
        return result;
    }
}

