/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.ResourceConfig;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ContainerAppFunctionConfiguration {
    protected Integer minReplicas;
    protected Integer maxReplicas;
    protected Double cpu;
    protected String memory;
    protected String workloadProfileMame;

    public static ContainerAppFunctionConfiguration fromFunctionApp(@Nonnull FunctionApp app) {
        String workloadProfile = Optional.ofNullable(app.innerModel()).map(SiteInner::workloadProfileName).orElse(null);
        ResourceConfig resourceConfig = Optional.ofNullable(app.innerModel()).map(SiteInner::resourceConfig).orElse(null);
        Double cpu = Optional.ofNullable(resourceConfig).map(ResourceConfig::cpu).orElse(null);
        String memory = Optional.ofNullable(resourceConfig).map(ResourceConfig::memory).orElse(null);
        return ContainerAppFunctionConfiguration.builder().minReplicas(app.minReplicas()).minReplicas(app.maxReplicas()).workloadProfileMame(workloadProfile).cpu(cpu).memory(memory).build();
    }

    public static ContainerAppFunctionConfigurationBuilder builder() {
        return new ContainerAppFunctionConfigurationBuilder();
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public Double getCpu() {
        return this.cpu;
    }

    public String getMemory() {
        return this.memory;
    }

    public String getWorkloadProfileMame() {
        return this.workloadProfileMame;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public void setCpu(Double cpu) {
        this.cpu = cpu;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public void setWorkloadProfileMame(String workloadProfileMame) {
        this.workloadProfileMame = workloadProfileMame;
    }

    public ContainerAppFunctionConfiguration() {
    }

    public ContainerAppFunctionConfiguration(Integer minReplicas, Integer maxReplicas, Double cpu, String memory, String workloadProfileMame) {
        this.minReplicas = minReplicas;
        this.maxReplicas = maxReplicas;
        this.cpu = cpu;
        this.memory = memory;
        this.workloadProfileMame = workloadProfileMame;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerAppFunctionConfiguration)) {
            return false;
        }
        ContainerAppFunctionConfiguration other = (ContainerAppFunctionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minReplicas = this.getMinReplicas();
        Integer other$minReplicas = other.getMinReplicas();
        if (this$minReplicas == null ? other$minReplicas != null : !((Object)this$minReplicas).equals(other$minReplicas)) {
            return false;
        }
        Integer this$maxReplicas = this.getMaxReplicas();
        Integer other$maxReplicas = other.getMaxReplicas();
        if (this$maxReplicas == null ? other$maxReplicas != null : !((Object)this$maxReplicas).equals(other$maxReplicas)) {
            return false;
        }
        Double this$cpu = this.getCpu();
        Double other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        String this$memory = this.getMemory();
        String other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        String this$workloadProfileMame = this.getWorkloadProfileMame();
        String other$workloadProfileMame = other.getWorkloadProfileMame();
        return !(this$workloadProfileMame == null ? other$workloadProfileMame != null : !this$workloadProfileMame.equals(other$workloadProfileMame));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerAppFunctionConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minReplicas = this.getMinReplicas();
        result = result * 59 + ($minReplicas == null ? 43 : ((Object)$minReplicas).hashCode());
        Integer $maxReplicas = this.getMaxReplicas();
        result = result * 59 + ($maxReplicas == null ? 43 : ((Object)$maxReplicas).hashCode());
        Double $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        String $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        String $workloadProfileMame = this.getWorkloadProfileMame();
        result = result * 59 + ($workloadProfileMame == null ? 43 : $workloadProfileMame.hashCode());
        return result;
    }

    public static class ContainerAppFunctionConfigurationBuilder {
        private Integer minReplicas;
        private Integer maxReplicas;
        private Double cpu;
        private String memory;
        private String workloadProfileMame;

        ContainerAppFunctionConfigurationBuilder() {
        }

        public ContainerAppFunctionConfigurationBuilder minReplicas(Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        public ContainerAppFunctionConfigurationBuilder maxReplicas(Integer maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        public ContainerAppFunctionConfigurationBuilder cpu(Double cpu) {
            this.cpu = cpu;
            return this;
        }

        public ContainerAppFunctionConfigurationBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public ContainerAppFunctionConfigurationBuilder workloadProfileMame(String workloadProfileMame) {
            this.workloadProfileMame = workloadProfileMame;
            return this;
        }

        public ContainerAppFunctionConfiguration build() {
            return new ContainerAppFunctionConfiguration(this.minReplicas, this.maxReplicas, this.cpu, this.memory, this.workloadProfileMame);
        }

        public String toString() {
            return "ContainerAppFunctionConfiguration.ContainerAppFunctionConfigurationBuilder(minReplicas=" + this.minReplicas + ", maxReplicas=" + this.maxReplicas + ", cpu=" + this.cpu + ", memory=" + this.memory + ", workloadProfileMame=" + this.workloadProfileMame + ")";
        }
    }
}

