/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.WebContainer;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppServiceSubscription;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public interface WebAppRuntime
extends Runtime {
    public static final String DEFAULT_JAVA = "Java 17";
    public static final WebContainer JAVA_SE = WebContainer.fromString((String)"Java SE");

    @Nonnull
    public String getContainerName();

    @Nonnull
    public String getContainerVersionNumber();

    default public WebContainer getWebContainer() {
        if (this.isDocker()) {
            return WebContainer.fromString((String)"docker");
        }
        return WebContainer.fromString((String)String.format("%s %s", this.getContainerName().toLowerCase(), this.getContainerVersionNumber()));
    }

    @Override
    default public boolean isMajorVersion() {
        if (this.isDocker()) {
            return true;
        }
        Pattern EXCLUDE_PATTERN = Pattern.compile(".*\\..*\\..*");
        return !EXCLUDE_PATTERN.matcher(this.getJavaVersionNumber()).matches() && !EXCLUDE_PATTERN.matcher(this.getContainerVersionNumber()).matches();
    }

    default public boolean isJavaSE() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.getContainerName(), (CharSequence)"java");
    }

    default public boolean isJBoss() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.getContainerName(), (CharSequence)"jboss");
    }

    default public boolean isTomcat() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.getContainerName(), (CharSequence)"tomcat");
    }

    @Override
    default public String getDisplayName() {
        if (this.isDocker()) {
            return "Docker";
        }
        return String.format("%s-%s-%s", this.getOperatingSystem().toString(), this.getJavaVersionUserText(), this.getContainerUserText());
    }

    default public String getContainerUserText() {
        if (this.isDocker()) {
            return "Docker";
        }
        return String.format("%s %s", StringUtils.capitalize((String)this.getContainerName().toLowerCase()), this.getContainerVersionNumber());
    }

    default public List<PricingTier> getPricingTiers() {
        return WebAppRuntime.getPricingTiers(this.getOperatingSystem(), this.getContainerUserText());
    }

    public static WebAppRuntime fromUserText(String os, String containerUserText, String javaVersionUserText) {
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"docker")) {
            return WebAppDockerRuntime.INSTANCE;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"windows")) {
            return WebAppWindowsRuntime.fromContainerAndJavaVersionUserText(containerUserText, javaVersionUserText);
        }
        return WebAppLinuxRuntime.fromContainerAndJavaVersionUserText(containerUserText, javaVersionUserText);
    }

    public static WebAppRuntime getDefaultTomcatRuntime() {
        return WebAppLinuxRuntime.TOMCAT10_JAVA17;
    }

    public static WebAppRuntime getDefaultJavaseRuntime() {
        return WebAppLinuxRuntime.JAVASE_JAVA17;
    }

    public static WebAppRuntime getDefaultJbossRuntime() {
        return WebAppLinuxRuntime.JBOSS7_JAVA17;
    }

    public static List<WebAppRuntime> getMajorRuntimes() {
        return Stream.concat(Stream.concat(WebAppLinuxRuntime.getMajorRuntimes().stream(), WebAppWindowsRuntime.getMajorRuntimes().stream()), Stream.of(WebAppDockerRuntime.INSTANCE)).collect(Collectors.toList());
    }

    public static List<WebAppRuntime> getAllRuntimes() {
        return Stream.concat(Stream.concat(WebAppLinuxRuntime.getAllRuntimes().stream(), WebAppWindowsRuntime.getAllRuntimes().stream()), Stream.of(WebAppDockerRuntime.INSTANCE)).collect(Collectors.toList());
    }

    public static List<PricingTier> getPricingTiers(OperatingSystem os, String containerUserText) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)containerUserText, (CharSequence)"jboss")) {
            return Arrays.asList(PricingTier.PREMIUM_P1V3, PricingTier.PREMIUM_P2V3, PricingTier.PREMIUM_P3V3);
        }
        ArrayList<PricingTier> tiers = new ArrayList<PricingTier>(PricingTier.values());
        if (os == OperatingSystem.LINUX || os == OperatingSystem.DOCKER) {
            tiers.remove(PricingTier.PREMIUM_P1);
            tiers.remove(PricingTier.PREMIUM_P2);
            tiers.remove(PricingTier.PREMIUM_P3);
        }
        return tiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadingAllRuntimes() {
        Class<WebAppRuntime> clazz = WebAppRuntime.class;
        synchronized (WebAppRuntime.class) {
            Account account = ((AzureAccount)Azure.az(AzureAccount.class)).getAccount();
            if (Objects.nonNull(account) && account.isLoggedIn() && !WebAppWindowsRuntime.isLoaded() && !WebAppWindowsRuntime.isLoading() && !WebAppLinuxRuntime.isLoaded() && !WebAppLinuxRuntime.isLoading()) {
                Subscription subscription = (Subscription)account.getSelectedSubscriptions().get(0);
                ((WebAppServiceSubscription)Objects.requireNonNull(((AzureWebApp)Azure.az(AzureWebApp.class)).get(subscription.getId(), null), "You are not signed-in")).loadRuntimes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

