/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.template;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class TemplateResources {
    private static final String VARIABLES_PREFIX = "variables_";
    private static final Pattern PATTERN = Pattern.compile("\\[variables\\('(.*)'\\)\\]");
    private static Map<String, String> map;

    public static String getResourceByNameWithDollar(String name) {
        return map == null ? null : map.get(name.substring(1));
    }

    public static String getResourceByVariableName(String variableName) {
        return map.get(VARIABLES_PREFIX + variableName);
    }

    public static String getResource(String name) {
        Matcher matcher = PATTERN.matcher(name);
        if (matcher.find()) {
            return TemplateResources.getResourceByVariableName(matcher.group(1));
        }
        return TemplateResources.getResourceByNameWithDollar(name);
    }

    static {
        try (InputStream is = TemplateResources.class.getResourceAsStream("/resources.json");){
            ObjectMapper mapper = new ObjectMapper();
            String resourceJsonStr = IOUtils.toString((InputStream)is, (String)"utf8");
            JsonNode node = mapper.readTree(resourceJsonStr);
            map = (Map)mapper.convertValue((Object)node.get("en"), Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

