/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.HostType;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.PublishingProfileFormat;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.file.AppServiceKuduClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IProcessClient;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Startable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentity;
import com.microsoft.azure.toolkit.lib.identities.Identity;
import com.microsoft.azure.toolkit.lib.identities.ManagedIdentitySupport;
import com.microsoft.azure.toolkit.lib.identities.model.IdentityConfiguration;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class AppServiceAppBase<T extends AppServiceAppBase<T, P, F>, P extends AbstractAzResource<P, ?, ?>, F extends WebAppBase>
extends AbstractAzResource<T, P, F>
implements Startable,
Deletable,
StreamingLogSupport,
ManagedIdentitySupport {
    private static final Logger log;
    public static final String SETTING_DOCKER_IMAGE = "DOCKER_CUSTOM_IMAGE_NAME";
    public static final String SETTING_REGISTRY_SERVER = "DOCKER_REGISTRY_SERVER_URL";
    protected AppServiceKuduClient kuduManager;
    public static final Action.Id<AppServiceAppBase<?, ?, ?>> OPEN_IN_BROWSER;
    public static final Action.Id<AppServiceAppBase<?, ?, ?>> START_STREAM_LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected AppServiceAppBase(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, F> module) {
        super(name, resourceGroupName, module);
    }

    protected AppServiceAppBase(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, F> module) {
        super(name, module);
    }

    protected AppServiceAppBase(@Nonnull T origin) {
        super(origin);
        this.kuduManager = ((AppServiceAppBase)((Object)origin)).kuduManager;
    }

    @AzureOperation(name="azure/$appservice.start_app.name", params={"this.getName()"})
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((WebAppBase)Objects.requireNonNull(this.getRemote())).start(), "Starting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/$appservice.stop_app.name", params={"this.getName()"})
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((WebAppBase)Objects.requireNonNull(this.getRemote())).stop(), "Stopping");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/$appservice.restart_app.name", params={"this.getName()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((WebAppBase)Objects.requireNonNull(this.getRemote())).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public String getHostName() {
        return this.remoteOptional().map(WebSiteBase::defaultHostname).orElse(null);
    }

    @Nullable
    public String getKuduHostName() {
        return this.remoteOptional().flatMap(siteBase -> siteBase.hostnameSslStates().values().stream().filter(sslState -> sslState.hostType() == HostType.REPOSITORY).map(HostnameSslState::name).findFirst()).orElse(null);
    }

    @Nullable
    public String getLinuxFxVersion() {
        return Optional.ofNullable(this.getRemote()).map(WebAppBase::linuxFxVersion).orElse(null);
    }

    @Nullable
    public PublishingProfile getPublishingProfile() {
        return Optional.ofNullable(this.getRemote()).map(WebAppBase::getPublishingProfile).map(AppServiceUtils::fromPublishingProfile).orElse(null);
    }

    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.getRemote()).map(WebAppBase::diagnosticLogsConfig).map(AppServiceUtils::fromWebAppDiagnosticLogs).orElse(null);
    }

    public Flux<String> streamingLogs(boolean follow, @Nonnull Map<String, String> params) {
        return Optional.ofNullable(this.getRemote()).map(WebAppBase::streamAllLogsAsync).orElseGet(Flux::empty);
    }

    @Nonnull
    public Flux<ByteBuffer> getFileContent(String path) {
        return Optional.ofNullable(this.getFileClient()).map(c -> c.getFileContent(path)).orElseGet(Flux::empty);
    }

    @Nonnull
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return Optional.ofNullable(this.getFileClient()).map(c -> c.getFilesInDirectory(dir)).orElseGet(Collections::emptyList);
    }

    @Nullable
    public AppServiceFile getFileByPath(String path) {
        return Optional.ofNullable(this.getFileClient()).map(c -> c.getFileByPath(path)).orElse(null);
    }

    public void uploadFileToPath(String content, String path) {
        Optional.ofNullable(this.getFileClient()).ifPresent(c -> c.uploadFileToPath(content, path));
    }

    public void createDirectory(String path) {
        Optional.ofNullable(this.getFileClient()).ifPresent(c -> c.createDirectory(path));
    }

    public void deleteFile(String path) {
        Optional.ofNullable(this.getFileClient()).ifPresent(c -> c.deleteFile(path));
    }

    @Nonnull
    public List<ProcessInfo> listProcess() {
        return Optional.ofNullable(this.getProcessClient()).map(IProcessClient::listProcess).orElseGet(Collections::emptyList);
    }

    @Nullable
    public CommandOutput execute(String command, String dir) {
        return Optional.ofNullable(this.getProcessClient()).map(c -> c.execute(command, dir)).orElse(null);
    }

    public InputStream listPublishingProfileXmlWithSecrets() {
        ResourceId resourceId = ResourceId.fromString((String)this.getId());
        String resourceName = StringUtils.equals((CharSequence)resourceId.resourceType(), (CharSequence)"slots") ? String.format("%s/slots/%s", resourceId.parent().name(), resourceId.name()) : resourceId.name();
        CsmPublishingProfileOptions csmPublishingProfileOptions = new CsmPublishingProfileOptions().withFormat(PublishingProfileFormat.FTP);
        return ((WebSiteManagementClient)((AppServiceManager)((WebAppBase)Objects.requireNonNull(this.getRemote())).manager()).serviceClient()).getWebApps().listPublishingProfileXmlWithSecrets(resourceId.resourceGroupName(), resourceName, csmPublishingProfileOptions).toStream();
    }

    @Nullable
    public TunnelStatus getAppServiceTunnelStatus() {
        return Optional.ofNullable(this.getProcessClient()).map(IProcessClient::getAppServiceTunnelStatus).orElse(null);
    }

    @Nullable
    public AppServicePlan getAppServicePlan() {
        AppServicePlanModule plans = ((AzureAppService)Azure.az(AzureAppService.class)).plans(this.getSubscriptionId());
        return this.remoteOptional().map(WebSiteBase::appServicePlanId).map(arg_0 -> ((AppServicePlanModule)plans).get(arg_0)).orElse(null);
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(Resource::regionName).map(Region::fromName).orElse(null);
    }

    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.getRemote()).map(WebAppBase::getAppSettings).map(Utils::normalizeAppSettings).orElse(null);
    }

    @Nullable
    public abstract Runtime getRuntime();

    @Nullable
    public RuntimeConfig getDockerRuntimeConfig() {
        String linuxFxVersion = this.getLinuxFxVersion();
        if (!StringUtils.startsWithIgnoreCase((CharSequence)linuxFxVersion, (CharSequence)"docker")) {
            return null;
        }
        RuntimeConfig runtimeConfig = new RuntimeConfig();
        runtimeConfig.os(OperatingSystem.DOCKER);
        Map settings = Optional.ofNullable(this.getAppSettings()).orElse(Collections.emptyMap());
        String imageSetting = Optional.ofNullable(settings.get(SETTING_DOCKER_IMAGE)).filter(StringUtils::isNotBlank).orElseGet(() -> Utils.getDockerImageNameFromLinuxFxVersion(Objects.requireNonNull(linuxFxVersion)));
        String registryServerSetting = Optional.ofNullable(settings.get(SETTING_REGISTRY_SERVER)).filter(StringUtils::isNotBlank).orElse(null);
        return runtimeConfig.image(imageSetting).registryUrl(registryServerSetting);
    }

    @Nonnull
    protected String loadStatus(@Nonnull WebAppBase remote) {
        return remote.state();
    }

    @Nullable
    protected IFileClient getFileClient() {
        return this.getKuduManager();
    }

    @Nullable
    protected IProcessClient getProcessClient() {
        return this.getKuduManager();
    }

    @Nullable
    public AppServiceKuduClient getKuduManager() {
        if (this.kuduManager == null) {
            this.kuduManager = Optional.ofNullable(this.getRemote()).map(r -> AppServiceKuduClient.getClient(r, this)).orElse(null);
        }
        return this.kuduManager;
    }

    public boolean isStreamingLogSupported() {
        return false;
    }

    protected void setRemote(F remote) {
        super.setRemote(remote);
    }

    @Nullable
    public IdentityConfiguration getIdentityConfiguration() {
        ManagedServiceIdentity identity = this.remoteOptional().map(WebSiteBase::identity).orElse(null);
        if (Objects.isNull(identity)) {
            return null;
        }
        boolean enableSystemAssignedIdentity = StringUtils.containsIgnoreCase((CharSequence)identity.type().toString(), (CharSequence)"SystemAssigned");
        List identities = Objects.isNull(identity.userAssignedIdentities()) ? Collections.emptyList() : identity.userAssignedIdentities().keySet().stream().map(id -> (Identity)((AzureManagedIdentity)Azure.az(AzureManagedIdentity.class)).getById(id)).collect(Collectors.toList());
        return IdentityConfiguration.builder().enableSystemAssignedManagedIdentity(enableSystemAssignedIdentity).principalId(identity.principalId()).tenantId(identity.tenantId()).userAssignedManagedIdentities(identities).build();
    }

    public void updateIdentityConfiguration(@Nonnull IdentityConfiguration configuration) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    static {
        AppServiceAppBase.ajc$preClinit();
        log = LoggerFactory.getLogger(AppServiceAppBase.class);
        OPEN_IN_BROWSER = Action.Id.of((String)"user/webapp.open_in_browser.app");
        START_STREAM_LOG = Action.Id.of((String)"user/$appservice.open_log_stream.app");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppServiceAppBase.java", AppServiceAppBase.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase", "", "", "", "void"), 95);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase", "", "", "", "void"), 100);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase", "", "", "", "void"), 105);
    }
}

