/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.file.AppServiceKuduClient;
import com.microsoft.azure.toolkit.lib.appservice.file.AzureFunctionsAdminClient;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FlexFunctionDeployHandler
implements IFunctionDeployHandler {
    public static final String FAILED_TO_DEPLOY = "Failed to deploy to Azure Function (%s) : ";
    public static final Duration HOST_STATUS_DELAY = Duration.ofSeconds(2L);
    public static final int HOST_STATUS_REPEAT = 15;
    public static final String INVALID_STATUS = "Deployment was successful but the app appears to be unhealthy. Please check the app logs.";
    public static final int DEPLOYMENT_REPEAT_TIMES = 450;
    public static final Duration DEPLOYMENT_STATUS_DELAY = Duration.ofMillis(500L);

    @Override
    @Deprecated
    public void deploy(@Nonnull File file, @Nonnull WebAppBase webAppBase) {
        this.deploy(file, (FunctionAppBase)((Object)Objects.requireNonNull(((AzureFunctions)Azure.az(AzureFunctions.class)).getById(webAppBase.id()))));
    }

    @Override
    public void deploy(@Nonnull File file, @Nonnull FunctionAppBase<?, ?, ?> functionAppBase) {
        AppServiceKuduClient kuduManager = functionAppBase.getKuduManager();
        try {
            Objects.requireNonNull(kuduManager).flexZipDeploy(file);
            kuduManager.checkLatestDeploymentStatus(DEPLOYMENT_STATUS_DELAY, 450);
            this.checkFlexAppAfterDeployment(functionAppBase);
        }
        catch (IOException | InterruptedException e) {
            throw new AzureToolkitRuntimeException(String.format(FAILED_TO_DEPLOY, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
        AzureMessager.getMessager().info(String.format("Successfully deployed the artifact to https://%s", functionAppBase.getHostName()));
    }

    private void checkFlexAppAfterDeployment(@Nonnull FunctionAppBase<?, ?, ?> functionAppBase) throws InterruptedException {
        AzureMessager.getMessager().info("Waiting for sync triggers, it may take some moments...");
        Thread.sleep(60000L);
        AzureFunctionsAdminClient adminClient = functionAppBase.getAdminClient();
        if (Objects.isNull(adminClient)) {
            return;
        }
        AzureMessager.getMessager().info("Checking the health of the function app...");
        Boolean result = adminClient.getHostStatus(HOST_STATUS_DELAY, 15);
        if (BooleanUtils.isNotTrue((Boolean)result)) {
            throw new AzureToolkitRuntimeException(INVALID_STATUS);
        }
    }
}

