/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentityType;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ResourceConfig;
import com.azure.resourcemanager.appservice.models.UserAssignedIdentity;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.msi.MsiManager;
import com.azure.resourcemanager.msi.models.Identity;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.model.ContainerAppFunctionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.StorageAuthenticationMethod;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.model.EnvironmentType;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class FunctionAppDraft
extends FunctionApp
implements AzResource.Draft<FunctionApp, com.azure.resourcemanager.appservice.models.FunctionApp> {
    private static final String CREATE_NEW_FUNCTION_APP = "isCreateNewFunctionApp";
    public static final String FUNCTIONS_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    public static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system of an existing app";
    public static final String APP_SETTING_MACHINEKEY_DECRYPTION_KEY = "MACHINEKEY_DecryptionKey";
    public static final String APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE = "WEBSITES_ENABLE_APP_SERVICE_STORAGE";
    public static final String APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE = "false";
    public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE = "FUNCTION_APP_EDIT_MODE";
    public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY = "readOnly";
    public static final String APPLICATIONINSIGHTS_ENABLE_AGENT = "APPLICATIONINSIGHTS_ENABLE_AGENT";
    public static final String SERVICE_PLAN_MISSING_MESSAGE = "'service plan' is required to create a Function App";
    public static final String UNSUPPORTED_OPERATING_SYSTEM_FOR_CONTAINER_APP = "Unsupported operating system %s for function app on container app";
    public static final String STORAGE_BLOB_DATA_CONTRIBUTOR_ROLE_ID = "ba92f5b4-2d11-453d-a403-e96b0029c9fe";
    public static final String ROLE_NOT_AFFECT = "The role '%s' has been assigned to the managed identity '%s'. This process may take several minutes to take effect. If you encounter any exceptions during deployment, please try again later.";
    @Nullable
    private final FunctionApp origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    FunctionAppDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull FunctionAppModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    FunctionAppDraft(@Nonnull FunctionApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Nonnull
    @AzureOperation(name="azure/function.create_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appservice.models.FunctionApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            Boolean enableDistributedTracing;
            FunctionApp.DefinitionStages.WithCreate withCreate;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Runtime.tryWarningDeprecation(this);
            OperationContext.action().setTelemetryProperty(CREATE_NEW_FUNCTION_APP, String.valueOf(true));
            OperationContext.action().setTelemetryProperty("subscriptionId", this.getSubscriptionId());
            OperationContext.action().setTelemetryProperty("useEnvironment", String.valueOf(Objects.nonNull(this.getEnvironment())));
            Optional.ofNullable(this.getRegion()).ifPresent(region -> OperationContext.action().setTelemetryProperty("region", region.getLabel()));
            Optional.ofNullable(this.getRuntime()).ifPresent(runtime -> OperationContext.action().setTelemetryProperty("runtime", runtime.getDisplayName()));
            Optional.ofNullable(this.getRuntime()).map(Runtime::getOperatingSystem).ifPresent(os -> OperationContext.action().setTelemetryProperty("os", os.getValue()));
            Optional.ofNullable(this.getRuntime()).map(Runtime::getJavaVersionUserText).ifPresent(javaVersion -> OperationContext.action().setTelemetryProperty("javaVersion", javaVersion));
            boolean isFlexConsumption = Optional.ofNullable(this.getAppServicePlan()).map(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan::getPricingTier).map(PricingTier::isFlexConsumption).orElse(false);
            String name = this.getName();
            FunctionAppRuntime newRuntime = Objects.requireNonNull(this.getRuntime(), "'runtime' is required to create a Function App");
            OffsetDateTime endOfLifeDate = newRuntime.getEndOfLifeDate();
            if (BooleanUtils.isNotTrue((Boolean)this.getSkipEndOfLifeValidation()) && Objects.nonNull(endOfLifeDate) && OffsetDateTime.now().isAfter(endOfLifeDate)) {
                String message = String.format("The runtime '%s' has reached end of life. Please upgrade to a newer version. Learn more: %s", newRuntime.getDisplayName(), "https://aka.ms/javatooling/function.upgrade_runtime");
                throw new AzureToolkitRuntimeException(message);
            }
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan = this.getAppServicePlan();
            ContainerAppsEnvironment environment = this.getEnvironment();
            Map<String, String> newAppSettings = this.getAppSettings();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            String funcExtVersion = Optional.ofNullable(newAppSettings).map(map -> (String)map.get(FUNCTIONS_EXTENSION_VERSION)).orElse(null);
            StorageAccount storageAccount = this.getStorageAccount();
            AppServiceManager manager = (AppServiceManager)Objects.requireNonNull(((AppServiceServiceSubscription)this.getParent()).getRemote());
            FunctionApp.DefinitionStages.Blank blank = (FunctionApp.DefinitionStages.Blank)manager.functionApps().define(name);
            if (Objects.nonNull(environment)) {
                ContainerAppFunctionConfiguration containerConfiguration = this.getContainerConfiguration();
                Region region2 = Objects.requireNonNull(this.getRegion(), "'region' is required to create a container based function app");
                String strRegion = StringUtils.endsWith((CharSequence)region2.getAbbreviation(), (CharSequence)"(stage)") ? region2.getAbbreviation() : region2.getName();
                FunctionApp.DefinitionStages.WithScaleRulesOrDockerContainerImage withImage = ((FunctionApp.DefinitionStages.NewAppServicePlanWithGroup)blank.withRegion(strRegion)).withExistingResourceGroup(this.getResourceGroupName()).withManagedEnvironmentId(environment.getId());
                Optional.ofNullable(containerConfiguration).map(ContainerAppFunctionConfiguration::getMaxReplicas).ifPresent(arg_0 -> ((FunctionApp.DefinitionStages.WithScaleRulesOrDockerContainerImage)withImage).withMaxReplicas(arg_0));
                Optional.ofNullable(containerConfiguration).map(ContainerAppFunctionConfiguration::getMinReplicas).ifPresent(arg_0 -> ((FunctionApp.DefinitionStages.WithScaleRulesOrDockerContainerImage)withImage).withMinReplicas(arg_0));
                if (newRuntime.getOperatingSystem() != OperatingSystem.DOCKER && newRuntime.getOperatingSystem() != OperatingSystem.LINUX) {
                    throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM_FOR_CONTAINER_APP, new Object[]{newRuntime.getOperatingSystem()}));
                }
                FunctionApp.DefinitionStages.WithCreate withCreate2 = withCreate = newRuntime.getOperatingSystem() == OperatingSystem.DOCKER ? this.defineDockerContainerImage((FunctionApp.DefinitionStages.WithDockerContainerImage)withImage) : withImage.withBuiltInImage(((FunctionAppLinuxRuntime)newRuntime).toFunctionRuntimeStack(funcExtVersion));
                if (environment.getEnvironmentType() == EnvironmentType.WorkloadProfiles) {
                    String profile = Optional.ofNullable(containerConfiguration).map(ContainerAppFunctionConfiguration::getWorkloadProfileMame).orElse(null);
                    SiteInner siteInner = (SiteInner)((com.azure.resourcemanager.appservice.models.FunctionApp)withCreate).innerModel();
                    siteInner.withWorkloadProfileName(StringUtils.isBlank((CharSequence)profile) ? "Consumption" : profile);
                    if (Objects.nonNull(containerConfiguration) && ObjectUtils.anyNotNull((Object[])new Object[]{containerConfiguration.getCpu(), containerConfiguration.getMemory()})) {
                        ResourceConfig resourceConfig = new ResourceConfig();
                        resourceConfig.withCpu(containerConfiguration.getCpu());
                        resourceConfig.withMemory(containerConfiguration.getMemory());
                        siteInner.withResourceConfig(resourceConfig);
                    }
                }
            } else {
                OperatingSystem os2;
                OperatingSystem operatingSystem = os2 = newRuntime.isDocker() ? OperatingSystem.LINUX : newRuntime.getOperatingSystem();
                if (os2 != Objects.requireNonNull(newPlan, SERVICE_PLAN_MISSING_MESSAGE).getOperatingSystem()) {
                    throw new AzureToolkitRuntimeException(String.format("Could not create %s app service in %s service plan", new Object[]{newRuntime.getOperatingSystem(), newPlan.getOperatingSystem()}));
                }
                if (newRuntime.getOperatingSystem() == OperatingSystem.LINUX) {
                    withCreate = blank.withExistingLinuxAppServicePlan((AppServicePlan)newPlan.getRemote()).withExistingResourceGroup(this.getResourceGroupName()).withBuiltInImage(((FunctionAppLinuxRuntime)newRuntime).toFunctionRuntimeStack(funcExtVersion));
                } else if (newRuntime.getOperatingSystem() == OperatingSystem.WINDOWS) {
                    withCreate = (FunctionApp.DefinitionStages.WithCreate)((FunctionApp.DefinitionStages.WithCreate)blank.withExistingAppServicePlan((AppServicePlan)newPlan.getRemote()).withExistingResourceGroup(this.getResourceGroupName())).withJavaVersion(newRuntime.getJavaVersion()).withWebContainer(null);
                } else if (newRuntime.getOperatingSystem() == OperatingSystem.DOCKER) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)newPlan.getPricingTier().getTier(), (CharSequence)"Dynamic")) {
                        throw new AzureToolkitRuntimeException("Docker function is not supported in consumption service plan");
                    }
                    FunctionApp.DefinitionStages.WithDockerContainerImage withLinuxAppFramework = blank.withExistingLinuxAppServicePlan((AppServicePlan)newPlan.getRemote()).withExistingResourceGroup(this.getResourceGroupName());
                    withCreate = this.defineDockerContainerImage(withLinuxAppFramework);
                } else {
                    throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
                }
            }
            if (MapUtils.isNotEmpty(newAppSettings)) {
                withCreate.withAppSettings(newAppSettings);
            }
            if (Objects.nonNull(storageAccount)) {
                withCreate.withExistingStorageAccount((com.azure.resourcemanager.storage.models.StorageAccount)storageAccount.getRemote());
            }
            if (Objects.nonNull(newDiagnosticConfig) && Objects.isNull(environment)) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, newDiagnosticConfig);
            }
            if (Objects.nonNull(enableDistributedTracing = this.ensureConfig().getEnableDistributedTracing())) {
                withCreate.withAppSetting(APPLICATIONINSIGHTS_ENABLE_AGENT, String.valueOf(enableDistributedTracing));
            } else if (this.shouldEnableDistributedTracing(newPlan, newAppSettings)) {
                withCreate.withAppSetting(APPLICATIONINSIGHTS_ENABLE_AGENT, "true");
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Function App({0})...", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp = Objects.requireNonNull(this.doModify(() -> {
                if (isFlexConsumption) {
                    return this.createOrUpdateFlexConsumptionFunctionAppWithRawRequest((com.azure.resourcemanager.appservice.models.FunctionApp)withCreate);
                }
                return (com.azure.resourcemanager.appservice.models.FunctionApp)withCreate.create();
            }, "Creating"));
            Action deploy = this.getRuntime().isDocker() ? null : (Action)Optional.ofNullable(AzureActionManager.getInstance().getAction(AzResource.DEPLOY)).map(action -> action.bind((Object)this)).orElse(null);
            messager.success(AzureString.format((String)"Function App({0}) is successfully created", (Object[])new Object[]{name}), new Object[]{deploy});
            Optional.ofNullable(this.getEnvironment()).ifPresent(ContainerAppsEnvironment::refresh);
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp2 = functionApp;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void updateFlexFunctionAppIdentityConfiguration(com.azure.resourcemanager.appservice.models.FunctionApp app, FunctionAppConfig.Storage.Authentication configuration) throws IOException {
        AppServiceManager manager = (AppServiceManager)app.manager();
        if (configuration.getType() == StorageAuthenticationMethod.SystemAssignedIdentity) {
            ((SiteInner)app.innerModel()).withIdentity(new ManagedServiceIdentity().withType(ManagedServiceIdentityType.SYSTEM_ASSIGNED));
        } else if (configuration.getType() == StorageAuthenticationMethod.UserAssignedIdentity) {
            Subscription subscription = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSubscription(this.getSubscriptionId());
            MsiManager msiManager = MsiManager.authenticate((HttpPipeline)manager.httpPipeline(), (AzureProfile)new AzureProfile(subscription.getTenantId(), subscription.getId(), manager.environment()));
            Identity identity = (Identity)msiManager.identities().getById(configuration.getUserAssignedIdentityResourceId());
            String identityJson = String.format("{\"principalId\" : \"%s\", \"clientId\" : \"%s\"}", identity.principalId(), identity.clientId());
            SerializerAdapter adapter = SerializerFactory.createDefaultManagementSerializerAdapter();
            UserAssignedIdentity userAssignedIdentity = (UserAssignedIdentity)adapter.deserialize(identityJson, UserAssignedIdentity.class, SerializerEncoding.JSON);
            ((SiteInner)app.innerModel()).withIdentity(new ManagedServiceIdentity().withType(ManagedServiceIdentityType.USER_ASSIGNED).withUserAssignedIdentities(Collections.singletonMap(identity.id(), userAssignedIdentity)));
        }
    }

    private void grantPermissionToIdentity(com.azure.resourcemanager.appservice.models.FunctionApp result) {
        FunctionAppConfig config = this.getFlexConfigFromRemote((WebAppBase)result);
        FunctionAppConfig.Storage storage = config.getDeployment().getStorage();
        FunctionAppConfig.Storage.Authentication authConfiguration = Objects.requireNonNull(storage.getAuthentication());
        StorageAccount storageAccount = Optional.ofNullable(this.ensureConfig().getDeploymentAccount()).orElseGet(() -> this.ensureConfig().getStorageAccount());
        if (Objects.isNull(storageAccount)) {
            return;
        }
        String identityId = authConfiguration.getType() == StorageAuthenticationMethod.SystemAssignedIdentity ? result.identity().principalId() : result.identity().userAssignedIdentities().entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)authConfiguration.getUserAssignedIdentityResourceId())).findFirst().map(Map.Entry::getValue).map(UserAssignedIdentity::principalId).orElseThrow(() -> new RuntimeException("User assigned identity not found"));
        String roleAssignmentName = UUID.randomUUID().toString();
        String scope = storageAccount.getId();
        RoleAssignment existingAssignment = this.getExistingRoleAssignment(identityId, scope);
        if (Objects.isNull(existingAssignment)) {
            try {
                AuthorizationManager authorizationManager = ((AppServiceManager)Objects.requireNonNull(((AppServiceServiceSubscription)this.getParent()).getRemote())).authorizationManager();
                ((RoleAssignment.DefinitionStages.Blank)authorizationManager.roleAssignments().define(roleAssignmentName)).forObjectId(identityId).withBuiltInRole(BuiltInRole.STORAGE_BLOB_DATA_CONTRIBUTOR).withScope(scope).create();
                RoleAssignment existingRoleAssignment = this.getExistingRoleAssignment(identityId, scope);
                if (Objects.isNull(existingRoleAssignment)) {
                    AzureMessager.getMessager().error(String.format(ROLE_NOT_AFFECT, BuiltInRole.STORAGE_BLOB_DATA_CONTRIBUTOR, identityId));
                }
            }
            catch (Throwable t) {
                String message = String.format("Failed to assign role '%s' to managed identity '%s', please assign the role manually or your app may not able to work : %s", BuiltInRole.STORAGE_BLOB_DATA_CONTRIBUTOR, identityId, ExceptionUtils.getMessage((Throwable)t));
                AzureMessager.getMessager().error(message, new Object[]{t});
            }
        }
    }

    private RoleAssignment getExistingRoleAssignment(String identityId, String scope) {
        AuthorizationManager authorizationManager = ((AppServiceManager)Objects.requireNonNull(((AppServiceServiceSubscription)this.getParent()).getRemote())).authorizationManager();
        String roleDefinitionId = String.format("/subscriptions/%s/providers/Microsoft.Authorization/roleDefinitions/%s", this.getSubscriptionId(), STORAGE_BLOB_DATA_CONTRIBUTOR_ROLE_ID);
        return authorizationManager.roleAssignments().listByScope(scope).stream().filter(assignment -> StringUtils.equalsIgnoreCase((CharSequence)assignment.principalId(), (CharSequence)identityId) && StringUtils.equalsIgnoreCase((CharSequence)assignment.roleDefinitionId(), (CharSequence)roleDefinitionId)).findFirst().orElse(null);
    }

    private boolean shouldEnableDistributedTracing(@Nullable com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan servicePlan, @Nullable Map<String, String> appSettings) {
        boolean isConsumptionPlan = !Objects.isNull((Object)servicePlan) && servicePlan.getPricingTier().isConsumption();
        boolean isSetInAppSettings = MapUtils.isNotEmpty(appSettings) && appSettings.containsKey(APPLICATIONINSIGHTS_ENABLE_AGENT);
        return !isConsumptionPlan && !isSetInAppSettings;
    }

    FunctionApp.DefinitionStages.WithCreate defineDockerContainerImage(@Nonnull FunctionApp.DefinitionStages.WithDockerContainerImage withLinuxAppFramework) {
        String message = "Docker configuration is required to create a docker based Function app";
        DockerConfiguration config = Objects.requireNonNull(this.getDockerConfiguration(), "Docker configuration is required to create a docker based Function app");
        FunctionApp.DefinitionStages.WithCreate draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{config.getUserName(), config.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(config.getImage()) : (StringUtils.isEmpty((CharSequence)config.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(config.getImage()).withCredentials(config.getUserName(), config.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(config.getImage(), config.getRegistryUrl()).withCredentials(config.getUserName(), config.getPassword()));
        String decryptionKey = this.generateDecryptionKey();
        return (FunctionApp.DefinitionStages.WithCreate)draft.withAppSetting(APP_SETTING_MACHINEKEY_DECRYPTION_KEY, decryptionKey).withAppSetting(APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE, APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE).withAppSetting(APP_SETTING_FUNCTION_APP_EDIT_MODE, APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY);
    }

    protected String generateDecryptionKey() {
        return Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)32)).toUpperCase();
    }

    @Nonnull
    @AzureOperation(name="azure/function.update_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appservice.models.FunctionApp updateResourceInAzure(@Nonnull com.azure.resourcemanager.appservice.models.FunctionApp remote) {
        com.azure.resourcemanager.appservice.models.FunctionApp functionApp = remote;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)functionApp);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (this.origin != null) : "updating target is not specified.";
            Runtime.tryWarningDeprecation(this);
            Map<String, String> oldAppSettings = Objects.requireNonNull(this.origin.getAppSettings());
            Map settingsToAdd = Optional.ofNullable(this.ensureConfig().getAppSettings()).map(map -> map.entrySet().stream().filter(entry -> !StringUtils.equals((CharSequence)((CharSequence)oldAppSettings.get(entry.getKey())), (CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(HashMap::new);
            Boolean enableDistributedTracing = this.ensureConfig().getEnableDistributedTracing();
            if (Objects.nonNull(enableDistributedTracing)) {
                settingsToAdd.put(APPLICATIONINSIGHTS_ENABLE_AGENT, String.valueOf(enableDistributedTracing));
            }
            Set settingsToRemove = Optional.ofNullable(this.ensureConfig().getAppSettingsToRemove()).map(set -> set.stream().filter(oldAppSettings::containsKey).collect(Collectors.toSet())).orElse(Collections.emptySet());
            DiagnosticConfig oldDiagnosticConfig = super.getDiagnosticConfig();
            DiagnosticConfig newDiagnosticConfig = this.ensureConfig().getDiagnosticConfig();
            FunctionAppRuntime newRuntime = this.ensureConfig().getRuntime();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan = this.ensureConfig().getPlan();
            DockerConfiguration newDockerConfig = this.ensureConfig().getDockerConfiguration();
            FlexConsumptionConfiguration newFlexConsumptionConfiguration = this.ensureConfig().getFlexConsumptionConfiguration();
            StorageAccount storageAccount = this.getStorageAccount();
            FunctionAppRuntime oldRuntime = this.origin.getRuntime();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan oldPlan = this.origin.getAppServicePlan();
            FlexConsumptionConfiguration oldFlexConsumptionConfiguration = this.origin.getFlexConsumptionConfiguration();
            ContainerAppFunctionConfiguration oldContainerConfiguration = this.origin.getContainerConfiguration();
            ContainerAppFunctionConfiguration newContainerConfiguration = this.ensureConfig().getContainerConfiguration();
            boolean planModified = Objects.nonNull((Object)newPlan) && !Objects.equals((Object)newPlan, (Object)oldPlan);
            boolean dockerModified = Objects.nonNull(oldRuntime) && oldRuntime.isDocker() && Objects.nonNull(newDockerConfig);
            boolean isFlexConsumption = Optional.ofNullable(this.getAppServicePlan()).map(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan::getPricingTier).map(PricingTier::isFlexConsumption).orElse(false);
            boolean flexConsumptionModified = isFlexConsumption && Objects.nonNull(newFlexConsumptionConfiguration) && this.isFlexConsumptionModified(oldFlexConsumptionConfiguration, newFlexConsumptionConfiguration);
            boolean isAppSettingsModified = MapUtils.isNotEmpty((Map)settingsToAdd) || CollectionUtils.isNotEmpty(settingsToRemove);
            boolean isDiagnosticConfigModified = Objects.nonNull(newDiagnosticConfig) && !Objects.equals(newDiagnosticConfig, oldDiagnosticConfig);
            boolean runtimeModified = !isFlexConsumption && (Objects.isNull(oldRuntime) || !oldRuntime.isDocker()) && Objects.nonNull(newRuntime) && !Objects.equals(newRuntime, oldRuntime);
            boolean envConfigurationModified = this.isContainerHostingFunctionApp() && Objects.nonNull(newContainerConfiguration) && !Objects.equals(oldContainerConfiguration, newContainerConfiguration);
            boolean modified = planModified || runtimeModified || dockerModified || flexConsumptionModified || isAppSettingsModified || Objects.nonNull(newDiagnosticConfig) || Objects.nonNull(storageAccount) || envConfigurationModified;
            String funcExtVersion = Optional.of(settingsToAdd).map(map -> (String)map.get(FUNCTIONS_EXTENSION_VERSION)).orElseGet(() -> (String)oldAppSettings.get(FUNCTIONS_EXTENSION_VERSION));
            if (modified) {
                FunctionApp.Update update = (FunctionApp.Update)remote.update();
                Optional.ofNullable(newPlan).filter(ignore -> planModified).ifPresent(p -> this.updateAppServicePlan(update, (com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan)((Object)p)));
                Optional.ofNullable(newRuntime).filter(ignore -> runtimeModified).ifPresent(p -> this.updateRuntime(update, (Runtime)p, funcExtVersion));
                Optional.of(settingsToAdd).filter(ignore -> isAppSettingsModified).ifPresent(arg_0 -> ((FunctionApp.Update)update).withAppSettings(arg_0));
                Optional.of(settingsToRemove).filter(CollectionUtils::isNotEmpty).filter(ignore -> isAppSettingsModified).ifPresent(s -> s.forEach(arg_0 -> ((FunctionApp.Update)update).withoutAppSetting(arg_0)));
                Optional.ofNullable(newDockerConfig).filter(ignore -> dockerModified).ifPresent(p -> this.updateDockerConfiguration(update, (DockerConfiguration)p));
                Optional.ofNullable(newDiagnosticConfig).filter(ignore -> isDiagnosticConfigModified).filter(ignore -> StringUtils.isBlank((CharSequence)this.getEnvironmentId())).ifPresent(c -> AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, c));
                Optional.ofNullable(newFlexConsumptionConfiguration).filter(ignore -> flexConsumptionModified).ifPresent(c -> update.withContainerSize(c.getInstanceSize().intValue()));
                Optional.ofNullable(storageAccount).ifPresent(s -> update.withExistingStorageAccount((com.azure.resourcemanager.storage.models.StorageAccount)s.getRemote()));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating Function App({0})...", (Object[])new Object[]{remote.name()}));
                remote = Objects.requireNonNull(this.doModify(() -> {
                    if (isFlexConsumption) {
                        return this.createOrUpdateFlexConsumptionFunctionAppWithRawRequest((com.azure.resourcemanager.appservice.models.FunctionApp)update);
                    }
                    com.azure.resourcemanager.appservice.models.FunctionApp result = (com.azure.resourcemanager.appservice.models.FunctionApp)update.apply();
                    if (envConfigurationModified) {
                        FunctionApp.Update containerUpdate = (FunctionApp.Update)result.update();
                        Optional.ofNullable(newContainerConfiguration).ifPresent(c -> this.updateContainerFunctionConfiguration(containerUpdate, (ContainerAppFunctionConfiguration)c));
                        return (com.azure.resourcemanager.appservice.models.FunctionApp)((FunctionApp.DefinitionStages.WithCreate)containerUpdate).create();
                    }
                    return result;
                }, "Creating"));
                messager.success(AzureString.format((String)"Function App({0}) is successfully updated", (Object[])new Object[]{remote.name()}));
            }
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp2 = remote;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void updateContainerFunctionConfiguration(FunctionApp.Update update, ContainerAppFunctionConfiguration c) {
        Optional.ofNullable(c.getMaxReplicas()).ifPresent(arg_0 -> ((FunctionApp.Update)update).withMaxReplicas(arg_0));
        Optional.ofNullable(c.getMinReplicas()).ifPresent(arg_0 -> ((FunctionApp.Update)update).withMinReplicas(arg_0));
        SiteInner siteInner = (SiteInner)((com.azure.resourcemanager.appservice.models.FunctionApp)update).innerModel();
        Optional.ofNullable(c.getWorkloadProfileMame()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((SiteInner)siteInner).withWorkloadProfileName(arg_0));
        ResourceConfig resourceConfig = Optional.ofNullable(siteInner.resourceConfig()).orElseGet(ResourceConfig::new);
        Optional.ofNullable(c.getCpu()).ifPresent(arg_0 -> ((ResourceConfig)resourceConfig).withCpu(arg_0));
        Optional.ofNullable(c.getMemory()).ifPresent(arg_0 -> ((ResourceConfig)resourceConfig).withMemory(arg_0));
    }

    private boolean isFlexConsumptionModified(FlexConsumptionConfiguration oldConfiguration, FlexConsumptionConfiguration newConfiguration) {
        if (Objects.isNull(newConfiguration)) {
            return false;
        }
        if (Objects.isNull(oldConfiguration)) {
            return true;
        }
        return Objects.nonNull(newConfiguration.getInstanceSize()) && !Objects.equals(oldConfiguration.getInstanceSize(), newConfiguration.getInstanceSize()) || Objects.nonNull(newConfiguration.getMaximumInstances()) && !Objects.equals(oldConfiguration.getMaximumInstances(), newConfiguration.getMaximumInstances()) || Objects.nonNull(newConfiguration.getAlwaysReadyInstances()) && !Arrays.equals(oldConfiguration.getAlwaysReadyInstances(), newConfiguration.getAlwaysReadyInstances()) || Objects.nonNull(newConfiguration.getDeploymentContainer()) && !Objects.equals(oldConfiguration.getDeploymentContainer(), newConfiguration.getDeploymentContainer()) || Objects.nonNull(newConfiguration.getDeploymentResourceGroup()) && !Objects.equals(oldConfiguration.getDeploymentResourceGroup(), newConfiguration.getDeploymentResourceGroup()) || Objects.nonNull(newConfiguration.getDeploymentAccount()) && !Objects.equals(oldConfiguration.getDeploymentAccount(), newConfiguration.getDeploymentAccount()) || Objects.nonNull((Object)newConfiguration.getAuthenticationMethod()) && !Objects.equals((Object)oldConfiguration.getAuthenticationMethod(), (Object)newConfiguration.getAuthenticationMethod()) || Objects.nonNull(newConfiguration.getUserAssignedIdentityResourceId()) && !Objects.equals(oldConfiguration.getUserAssignedIdentityResourceId(), newConfiguration.getUserAssignedIdentityResourceId()) || Objects.nonNull(newConfiguration.getStorageAccountConnectionString()) && !Objects.equals(oldConfiguration.getStorageAccountConnectionString(), newConfiguration.getStorageAccountConnectionString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private com.azure.resourcemanager.appservice.models.FunctionApp createOrUpdateFlexConsumptionFunctionAppWithRawRequest(com.azure.resourcemanager.appservice.models.FunctionApp functionApp) throws IOException {
        boolean isManageIdentityAuthentication;
        FunctionAppConfig flexConfig = this.getFlexConsumptionAppConfig();
        SiteInner siteInner = (SiteInner)functionApp.innerModel();
        this.updateSiteConfigurations(functionApp, flexConfig);
        FunctionAppConfig.Storage.Authentication authentication = Optional.of(flexConfig).map(FunctionAppConfig::getDeployment).map(FunctionAppConfig.FunctionsDeployment::getStorage).map(FunctionAppConfig.Storage::getAuthentication).orElse(null);
        boolean bl = isManageIdentityAuthentication = Objects.nonNull(authentication) && authentication.getType() != StorageAuthenticationMethod.StorageAccountConnectionString;
        if (isManageIdentityAuthentication) {
            this.updateFlexFunctionAppIdentityConfiguration(functionApp, authentication);
        }
        SerializerAdapter adapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        String originContent = adapter.serializeRaw((Object)siteInner);
        ObjectNode jsonNode = (ObjectNode)adapter.deserialize(originContent, ObjectNode.class, SerializerEncoding.JSON);
        ObjectNode configNode = (ObjectNode)adapter.deserialize(adapter.serializeRaw((Object)flexConfig), ObjectNode.class, SerializerEncoding.JSON);
        ObjectNode properties = (ObjectNode)jsonNode.get("properties");
        properties.set("functionAppConfig", (JsonNode)configNode);
        Optional.ofNullable(this.getAppServicePlan()).map(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan::getPricingTier).ifPresent(tier -> properties.put("sku", tier.getTier()));
        String newContent = adapter.serializeRaw((Object)jsonNode);
        HttpPipeline httpPipeline = ((AppServiceManager)functionApp.manager()).httpPipeline();
        String targetUrl = this.getRawRequestEndpoint((WebAppBase)functionApp);
        HttpMethod method = this.exists() ? HttpMethod.PATCH : HttpMethod.PUT;
        HttpRequest request = new HttpRequest(method, targetUrl).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json").setBody(newContent);
        try (HttpResponse response = (HttpResponse)httpPipeline.send(request).block();){
            if (Objects.isNull(response) || response.getStatusCode() >= 300 || response.getStatusCode() < 200) {
                String content = Objects.isNull(response) ? "" : (String)response.getBodyAsString().block();
                throw new AzureToolkitRuntimeException(String.format("Failed to create or update function app : %s", content));
            }
            com.azure.resourcemanager.appservice.models.FunctionApp result = (com.azure.resourcemanager.appservice.models.FunctionApp)((AppServiceManager)functionApp.manager()).functionApps().getByResourceGroup(functionApp.resourceGroupName(), functionApp.name());
            result.refresh();
            if (isManageIdentityAuthentication) {
                this.grantPermissionToIdentity(result);
            }
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp2 = result;
            return functionApp2;
        }
        catch (Throwable t) {
            throw new AzureToolkitRuntimeException(t);
        }
    }

    private void updateSiteConfigurations(@Nonnull com.azure.resourcemanager.appservice.models.FunctionApp app, FunctionAppConfig flexConfig) {
        SiteInner siteInner = (SiteInner)app.innerModel();
        SiteConfigInner siteConfigInner = Optional.ofNullable(siteInner.siteConfig()).orElseGet(SiteConfigInner::new);
        siteInner.withSiteConfig(siteConfigInner);
        Map<Object, Object> appSettings = this.exists() ? Utils.normalizeAppSettings(app.getAppSettings()) : new HashMap();
        Optional.ofNullable(this.ensureConfig().getAppSettings()).ifPresent(appSettings::putAll);
        Optional.ofNullable(this.ensureConfig().getAppSettingsToRemove()).ifPresent(values -> values.forEach(appSettings::remove));
        StorageAccount storageAccount = this.getStorageAccount();
        Optional.ofNullable(storageAccount).ifPresent(account -> appSettings.put("AzureWebJobsStorage", account.getConnectionString()));
        FunctionAppConfig.Storage.Authentication authentication = flexConfig.getDeployment().getStorage().getAuthentication();
        if (authentication.getType() == StorageAuthenticationMethod.StorageAccountConnectionString) {
            StorageAccount deploymentAccount = this.ensureConfig().getDeploymentAccount();
            Optional.ofNullable(deploymentAccount).ifPresent(account -> appSettings.put(authentication.getStorageAccountConnectionStringName(), account.getConnectionString()));
        }
        appSettings.remove(FUNCTIONS_EXTENSION_VERSION);
        appSettings.remove("FUNCTIONS_WORKER_RUNTIME");
        appSettings.remove("FUNCTIONS_WORKER_RUNTIME_VERSION");
        appSettings.remove("FUNCTIONS_MAX_HTTP_CONCURRENCY");
        appSettings.remove("FUNCTIONS_WORKER_PROCESS_COUNT");
        appSettings.remove("FUNCTIONS_WORKER_DYNAMIC_CONCURRENCY_ENABLED");
        appSettings.remove("WEBSITE_CONTENTAZUREFILECONNECTIONSTRING");
        appSettings.remove("WEBSITE_CONTENTSHARE");
        List settings = appSettings.entrySet().stream().map(entry -> new NameValuePair().withName((String)entry.getKey()).withValue((String)entry.getValue())).collect(Collectors.toList());
        siteConfigInner.withAppSettings(settings);
        siteConfigInner.withHttp20Enabled(Boolean.valueOf(true));
        siteInner.withHttpsOnly(Boolean.valueOf(false));
        siteInner.withIsXenon(null);
        siteInner.withContainerSize(null);
        siteInner.withReserved(null);
        Optional.ofNullable(siteInner.siteConfig()).ifPresent(config -> {
            config.withFtpsState(null);
            config.withUse32BitWorkerProcess(null);
            config.withWindowsFxVersion(null);
            config.withLinuxFxVersion(null);
            config.withAlwaysOn(null);
            config.withPreWarmedInstanceCount(null);
            config.withFunctionAppScaleLimit(null);
            config.withJavaVersion(null);
        });
    }

    @Override
    public FunctionAppConfig getFlexConsumptionAppConfig() {
        FlexConsumptionConfiguration configuration = this.ensureConfig().getFlexConsumptionConfiguration();
        FunctionAppConfig original = super.getFlexConsumptionAppConfig();
        if (Objects.isNull(configuration)) {
            return original;
        }
        FunctionAppConfig result = this.isDraftForCreating() ? new FunctionAppConfig() : original;
        FunctionAppConfig.FunctionsDeployment deployment = Optional.ofNullable(result.getDeployment()).orElseGet(FunctionAppConfig.FunctionsDeployment::new);
        FunctionAppConfig.Storage storage = Optional.ofNullable(deployment.getStorage()).orElseGet(FunctionAppConfig.Storage::new);
        Optional.ofNullable(FunctionAppConfig.Storage.Authentication.fromConfiguration(configuration)).ifPresent(storage::setAuthentication);
        Optional.ofNullable(this.ensureConfig().getDeploymentContainerUrl()).ifPresent(storage::setValue);
        deployment.setStorage(storage);
        result.setDeployment(deployment);
        FunctionAppConfig.FunctionsRuntime functionsRuntime = Optional.ofNullable(result.getRuntime()).orElseGet(FunctionAppConfig.FunctionsRuntime::new);
        Optional.ofNullable(this.ensureConfig().getRuntime()).map(Runtime::getJavaVersionNumber).ifPresent(functionsRuntime::setVersion);
        result.setRuntime(functionsRuntime);
        FunctionAppConfig.FunctionScaleAndConcurrency concurrency = Optional.ofNullable(result.getScaleAndConcurrency()).orElseGet(FunctionAppConfig.FunctionScaleAndConcurrency::new);
        Optional.ofNullable(configuration.getHttpInstanceConcurrency()).map(FunctionAppConfig.FunctionTriggers::new).ifPresent(concurrency::setTriggers);
        Optional.ofNullable(configuration.getInstanceSize()).ifPresent(concurrency::setInstanceMemoryMB);
        Optional.ofNullable(configuration.getMaximumInstances()).ifPresent(concurrency::setMaximumInstanceCount);
        Optional.ofNullable(configuration.getAlwaysReadyInstances()).ifPresent(concurrency::setAlwaysReady);
        result.setScaleAndConcurrency(concurrency);
        return result;
    }

    private void updateAppServicePlan(@Nonnull FunctionApp.Update update, @Nonnull com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan) {
        OperatingSystem os;
        Objects.requireNonNull(newPlan.getRemote(), "Target app service plan doesn't exist");
        OperatingSystem operatingSystem = os = Objects.requireNonNull(this.getRuntime()).isDocker() ? OperatingSystem.LINUX : this.getRuntime().getOperatingSystem();
        if (os != newPlan.getOperatingSystem()) {
            throw new AzureToolkitRuntimeException(String.format("Could not migrate %s app service to %s service plan", new Object[]{this.getRuntime().getOperatingSystem(), newPlan.getOperatingSystem()}));
        }
        update.withExistingAppServicePlan((AppServicePlan)newPlan.getRemote());
    }

    private void updateRuntime(@Nonnull FunctionApp.Update update, @Nonnull Runtime newRuntime, String funcExtVersion) {
        Runtime oldRuntime = Objects.requireNonNull(Objects.requireNonNull(this.origin).getRuntime());
        if (newRuntime.getOperatingSystem() != null && oldRuntime.getOperatingSystem() != newRuntime.getOperatingSystem()) {
            throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
        }
        OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), oldRuntime.getOperatingSystem()}));
        if (operatingSystem == OperatingSystem.LINUX) {
            update.withBuiltInImage(((FunctionAppLinuxRuntime)newRuntime).toFunctionRuntimeStack(funcExtVersion));
        } else if (operatingSystem == OperatingSystem.WINDOWS) {
            update.withJavaVersion(newRuntime.getJavaVersion()).withWebContainer(null);
        } else {
            if (newRuntime.getOperatingSystem() == OperatingSystem.DOCKER) {
                return;
            }
            throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    private void updateDockerConfiguration(@Nonnull FunctionApp.Update update, @Nonnull DockerConfiguration newConfig) {
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{newConfig.getUserName(), newConfig.getPassword()})) {
            update.withPublicDockerHubImage(newConfig.getImage());
        } else if (StringUtils.isEmpty((CharSequence)newConfig.getRegistryUrl())) {
            update.withPrivateDockerHubImage(newConfig.getImage()).withCredentials(newConfig.getUserName(), newConfig.getPassword());
        } else {
            update.withPrivateRegistryImage(newConfig.getImage(), newConfig.getRegistryUrl()).withCredentials(newConfig.getUserName(), newConfig.getPassword());
        }
    }

    public void setRuntime(FunctionAppRuntime runtime) {
        this.ensureConfig().setRuntime(runtime);
    }

    @Override
    @Nullable
    public FunctionAppRuntime getRuntime() {
        return Optional.ofNullable(this.config).map(Config::getRuntime).orElseGet(() -> super.getRuntime());
    }

    public void setStorageAccount(StorageAccount account) {
        this.ensureConfig().setStorageAccount(account);
    }

    public StorageAccount getStorageAccount() {
        return Optional.ofNullable(this.config).map(Config::getStorageAccount).orElse(null);
    }

    public void setAppServicePlan(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
        this.ensureConfig().setPlan(plan);
    }

    @Override
    @Nullable
    public com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan getAppServicePlan() {
        return Optional.ofNullable(this.config).map(Config::getPlan).orElseGet(() -> super.getAppServicePlan());
    }

    public void setDiagnosticConfig(DiagnosticConfig config) {
        this.ensureConfig().setDiagnosticConfig(config);
    }

    @Override
    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.config).map(Config::getDiagnosticConfig).orElseGet(() -> super.getDiagnosticConfig());
    }

    public void setAppSettings(Map<String, String> appSettings) {
        this.ensureConfig().setAppSettings(appSettings);
    }

    public void setAppSetting(String key, String value) {
        this.ensureConfig().getAppSettings().put(key, value);
    }

    @Override
    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.config).map(Config::getAppSettings).orElseGet(() -> super.getAppSettings());
    }

    public void removeAppSetting(String key) {
        this.ensureConfig().getAppSettingsToRemove().add(key);
    }

    public void removeAppSettings(Set<String> keys) {
        this.ensureConfig().getAppSettingsToRemove().addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{keys, Collections.emptySet()}));
    }

    @Nullable
    public Set<String> getAppSettingsToRemove() {
        return Optional.ofNullable(this.config).map(Config::getAppSettingsToRemove).orElse(new HashSet());
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.ensureConfig().setDockerConfiguration(dockerConfiguration);
    }

    @Nullable
    public DockerConfiguration getDockerConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getDockerConfiguration).orElse(null);
    }

    public void setFlexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.ensureConfig().setFlexConsumptionConfiguration(flexConsumptionConfiguration);
    }

    public void setEnableDistributedTracing(@Nullable Boolean enableDistributedTracing) {
        this.ensureConfig().setEnableDistributedTracing(enableDistributedTracing);
    }

    @Override
    @Nullable
    public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getFlexConsumptionConfiguration).orElseGet(() -> super.getFlexConsumptionConfiguration());
    }

    public void setEnvironment(ContainerAppsEnvironment environment) {
        this.ensureConfig().setEnvironment(environment);
    }

    public void setContainerConfiguration(ContainerAppFunctionConfiguration containerConfiguration) {
        this.ensureConfig().setContainerConfiguration(containerConfiguration);
    }

    @Override
    public ContainerAppsEnvironment getEnvironment() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).orElseGet(() -> super.getEnvironment());
    }

    @Override
    public String getEnvironmentId() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).map(AbstractAzResource::getId).orElseGet(() -> super.getEnvironmentId());
    }

    @Override
    public ContainerAppFunctionConfiguration getContainerConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getContainerConfiguration).orElseGet(() -> super.getContainerConfiguration());
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRuntime()) || Objects.equals(this.config.getRuntime(), super.getRuntime()) || Objects.isNull((Object)this.config.getPlan()) || Objects.equals((Object)this.config.getPlan(), (Object)super.getAppServicePlan()) || Objects.isNull(this.config.getDiagnosticConfig()) || CollectionUtils.isEmpty(this.config.getAppSettingsToRemove()) || Objects.isNull(this.config.getAppSettings()) || Objects.equals(this.config.getAppSettings(), super.getAppSettings()) || Objects.isNull(this.config.getDockerConfiguration());
        return !notModified;
    }

    public void setRegion(Region region) {
        this.ensureConfig().setRegion(region);
    }

    @Override
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    public void setDeploymentAccount(StorageAccount deploymentStorageAccount) {
        this.ensureConfig().setDeploymentAccount(deploymentStorageAccount);
    }

    public void setDeploymentContainerUrl(String containerName) {
        this.ensureConfig().setDeploymentContainerUrl(containerName);
    }

    public void setSkipEndOfLifeValidation(Boolean enableEOFChecking) {
        this.ensureConfig().setSkipEndOfLifeValidation(enableEOFChecking);
    }

    public Boolean getSkipEndOfLifeValidation() {
        return Optional.ofNullable(this.config).map(Config::getSkipEndOfLifeValidation).orElse(false);
    }

    @Nullable
    public FunctionApp getOrigin() {
        return this.origin;
    }

    static {
        FunctionAppDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionAppDraft.java", FunctionAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft", "", "", "", "com.azure.resourcemanager.appservice.models.FunctionApp"), 141);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft", "com.azure.resourcemanager.appservice.models.FunctionApp", "remote", "", "com.azure.resourcemanager.appservice.models.FunctionApp"), 374);
    }

    @Nullable
    private static class Config {
        private FunctionAppRuntime runtime;
        private Region region;
        private com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan = null;
        private StorageAccount storageAccount = null;
        private ContainerAppsEnvironment environment = null;
        private ContainerAppFunctionConfiguration containerConfiguration = null;
        private Boolean enableDistributedTracing = null;
        private DiagnosticConfig diagnosticConfig = null;
        private Set<String> appSettingsToRemove = new HashSet<String>();
        private Map<String, String> appSettings = new HashMap<String, String>();
        private DockerConfiguration dockerConfiguration = null;
        private FlexConsumptionConfiguration flexConsumptionConfiguration;
        private StorageAccount deploymentAccount = null;
        private String deploymentContainerUrl = null;
        private Boolean skipEndOfLifeValidation = Boolean.TRUE;

        public FunctionAppRuntime getRuntime() {
            return this.runtime;
        }

        public Region getRegion() {
            return this.region;
        }

        public com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan getPlan() {
            return this.plan;
        }

        public StorageAccount getStorageAccount() {
            return this.storageAccount;
        }

        public ContainerAppsEnvironment getEnvironment() {
            return this.environment;
        }

        public ContainerAppFunctionConfiguration getContainerConfiguration() {
            return this.containerConfiguration;
        }

        public Boolean getEnableDistributedTracing() {
            return this.enableDistributedTracing;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }

        public Set<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DockerConfiguration getDockerConfiguration() {
            return this.dockerConfiguration;
        }

        public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
            return this.flexConsumptionConfiguration;
        }

        public StorageAccount getDeploymentAccount() {
            return this.deploymentAccount;
        }

        public String getDeploymentContainerUrl() {
            return this.deploymentContainerUrl;
        }

        public Boolean getSkipEndOfLifeValidation() {
            return this.skipEndOfLifeValidation;
        }

        public void setRuntime(FunctionAppRuntime runtime) {
            this.runtime = runtime;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public void setPlan(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
            this.plan = plan;
        }

        public void setStorageAccount(StorageAccount storageAccount) {
            this.storageAccount = storageAccount;
        }

        public void setEnvironment(ContainerAppsEnvironment environment) {
            this.environment = environment;
        }

        public void setContainerConfiguration(ContainerAppFunctionConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
        }

        public void setEnableDistributedTracing(Boolean enableDistributedTracing) {
            this.enableDistributedTracing = enableDistributedTracing;
        }

        public void setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
        }

        public void setAppSettingsToRemove(Set<String> appSettingsToRemove) {
            this.appSettingsToRemove = appSettingsToRemove;
        }

        public void setAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
        }

        public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
            this.dockerConfiguration = dockerConfiguration;
        }

        public void setFlexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
            this.flexConsumptionConfiguration = flexConsumptionConfiguration;
        }

        public void setDeploymentAccount(StorageAccount deploymentAccount) {
            this.deploymentAccount = deploymentAccount;
        }

        public void setDeploymentContainerUrl(String deploymentContainerUrl) {
            this.deploymentContainerUrl = deploymentContainerUrl;
        }

        public void setSkipEndOfLifeValidation(Boolean skipEndOfLifeValidation) {
            this.skipEndOfLifeValidation = skipEndOfLifeValidation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableDistributedTracing = this.getEnableDistributedTracing();
            Boolean other$enableDistributedTracing = other.getEnableDistributedTracing();
            if (this$enableDistributedTracing == null ? other$enableDistributedTracing != null : !((Object)this$enableDistributedTracing).equals(other$enableDistributedTracing)) {
                return false;
            }
            Boolean this$skipEndOfLifeValidation = this.getSkipEndOfLifeValidation();
            Boolean other$skipEndOfLifeValidation = other.getSkipEndOfLifeValidation();
            if (this$skipEndOfLifeValidation == null ? other$skipEndOfLifeValidation != null : !((Object)this$skipEndOfLifeValidation).equals(other$skipEndOfLifeValidation)) {
                return false;
            }
            FunctionAppRuntime this$runtime = this.getRuntime();
            FunctionAppRuntime other$runtime = other.getRuntime();
            if (this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan this$plan = this.getPlan();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !((Object)((Object)this$plan)).equals((Object)other$plan)) {
                return false;
            }
            StorageAccount this$storageAccount = this.getStorageAccount();
            StorageAccount other$storageAccount = other.getStorageAccount();
            if (this$storageAccount == null ? other$storageAccount != null : !this$storageAccount.equals(other$storageAccount)) {
                return false;
            }
            ContainerAppsEnvironment this$environment = this.getEnvironment();
            ContainerAppsEnvironment other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
                return false;
            }
            ContainerAppFunctionConfiguration this$containerConfiguration = this.getContainerConfiguration();
            ContainerAppFunctionConfiguration other$containerConfiguration = other.getContainerConfiguration();
            if (this$containerConfiguration == null ? other$containerConfiguration != null : !((Object)this$containerConfiguration).equals(other$containerConfiguration)) {
                return false;
            }
            DiagnosticConfig this$diagnosticConfig = this.getDiagnosticConfig();
            DiagnosticConfig other$diagnosticConfig = other.getDiagnosticConfig();
            if (this$diagnosticConfig == null ? other$diagnosticConfig != null : !((Object)this$diagnosticConfig).equals(other$diagnosticConfig)) {
                return false;
            }
            Set<String> this$appSettingsToRemove = this.getAppSettingsToRemove();
            Set<String> other$appSettingsToRemove = other.getAppSettingsToRemove();
            if (this$appSettingsToRemove == null ? other$appSettingsToRemove != null : !((Object)this$appSettingsToRemove).equals(other$appSettingsToRemove)) {
                return false;
            }
            Map<String, String> this$appSettings = this.getAppSettings();
            Map<String, String> other$appSettings = other.getAppSettings();
            if (this$appSettings == null ? other$appSettings != null : !((Object)this$appSettings).equals(other$appSettings)) {
                return false;
            }
            DockerConfiguration this$dockerConfiguration = this.getDockerConfiguration();
            DockerConfiguration other$dockerConfiguration = other.getDockerConfiguration();
            if (this$dockerConfiguration == null ? other$dockerConfiguration != null : !((Object)this$dockerConfiguration).equals(other$dockerConfiguration)) {
                return false;
            }
            FlexConsumptionConfiguration this$flexConsumptionConfiguration = this.getFlexConsumptionConfiguration();
            FlexConsumptionConfiguration other$flexConsumptionConfiguration = other.getFlexConsumptionConfiguration();
            if (this$flexConsumptionConfiguration == null ? other$flexConsumptionConfiguration != null : !((Object)this$flexConsumptionConfiguration).equals(other$flexConsumptionConfiguration)) {
                return false;
            }
            StorageAccount this$deploymentAccount = this.getDeploymentAccount();
            StorageAccount other$deploymentAccount = other.getDeploymentAccount();
            if (this$deploymentAccount == null ? other$deploymentAccount != null : !this$deploymentAccount.equals(other$deploymentAccount)) {
                return false;
            }
            String this$deploymentContainerUrl = this.getDeploymentContainerUrl();
            String other$deploymentContainerUrl = other.getDeploymentContainerUrl();
            return !(this$deploymentContainerUrl == null ? other$deploymentContainerUrl != null : !this$deploymentContainerUrl.equals(other$deploymentContainerUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableDistributedTracing = this.getEnableDistributedTracing();
            result = result * 59 + ($enableDistributedTracing == null ? 43 : ((Object)$enableDistributedTracing).hashCode());
            Boolean $skipEndOfLifeValidation = this.getSkipEndOfLifeValidation();
            result = result * 59 + ($skipEndOfLifeValidation == null ? 43 : ((Object)$skipEndOfLifeValidation).hashCode());
            FunctionAppRuntime $runtime = this.getRuntime();
            result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : ((Object)((Object)$plan)).hashCode());
            StorageAccount $storageAccount = this.getStorageAccount();
            result = result * 59 + ($storageAccount == null ? 43 : $storageAccount.hashCode());
            ContainerAppsEnvironment $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            ContainerAppFunctionConfiguration $containerConfiguration = this.getContainerConfiguration();
            result = result * 59 + ($containerConfiguration == null ? 43 : ((Object)$containerConfiguration).hashCode());
            DiagnosticConfig $diagnosticConfig = this.getDiagnosticConfig();
            result = result * 59 + ($diagnosticConfig == null ? 43 : ((Object)$diagnosticConfig).hashCode());
            Set<String> $appSettingsToRemove = this.getAppSettingsToRemove();
            result = result * 59 + ($appSettingsToRemove == null ? 43 : ((Object)$appSettingsToRemove).hashCode());
            Map<String, String> $appSettings = this.getAppSettings();
            result = result * 59 + ($appSettings == null ? 43 : ((Object)$appSettings).hashCode());
            DockerConfiguration $dockerConfiguration = this.getDockerConfiguration();
            result = result * 59 + ($dockerConfiguration == null ? 43 : ((Object)$dockerConfiguration).hashCode());
            FlexConsumptionConfiguration $flexConsumptionConfiguration = this.getFlexConsumptionConfiguration();
            result = result * 59 + ($flexConsumptionConfiguration == null ? 43 : ((Object)$flexConsumptionConfiguration).hashCode());
            StorageAccount $deploymentAccount = this.getDeploymentAccount();
            result = result * 59 + ($deploymentAccount == null ? 43 : $deploymentAccount.hashCode());
            String $deploymentContainerUrl = this.getDeploymentContainerUrl();
            result = result * 59 + ($deploymentContainerUrl == null ? 43 : $deploymentContainerUrl.hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppDraft.Config(runtime=" + this.getRuntime() + ", region=" + this.getRegion() + ", plan=" + (Object)((Object)this.getPlan()) + ", storageAccount=" + this.getStorageAccount() + ", environment=" + this.getEnvironment() + ", containerConfiguration=" + this.getContainerConfiguration() + ", enableDistributedTracing=" + this.getEnableDistributedTracing() + ", diagnosticConfig=" + this.getDiagnosticConfig() + ", appSettingsToRemove=" + this.getAppSettingsToRemove() + ", appSettings=" + this.getAppSettings() + ", dockerConfiguration=" + this.getDockerConfiguration() + ", flexConsumptionConfiguration=" + this.getFlexConsumptionConfiguration() + ", deploymentAccount=" + this.getDeploymentAccount() + ", deploymentContainerUrl=" + this.getDeploymentContainerUrl() + ", skipEndOfLifeValidation=" + this.getSkipEndOfLifeValidation() + ")";
        }
    }
}

