/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionsServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public interface FunctionAppRuntime
extends Runtime {
    public static final String DEFAULT_JAVA = "Java 17";

    @Override
    default public String getDisplayName() {
        if (this.isDocker()) {
            return "Docker";
        }
        return String.format("%s-%s", this.getOperatingSystem().toString(), this.getJavaVersionUserText());
    }

    @Override
    default public boolean isMajorVersion() {
        if (this.isDocker()) {
            return true;
        }
        Pattern EXCLUDE_PATTERN = Pattern.compile(".*\\..*\\..*");
        return !EXCLUDE_PATTERN.matcher(this.getJavaVersionNumber()).matches();
    }

    public static FunctionAppRuntime getDefault() {
        return FunctionAppLinuxRuntime.FUNCTION_JAVA21;
    }

    public static List<FunctionAppRuntime> getMajorRuntimes() {
        return Stream.concat(Stream.concat(FunctionAppLinuxRuntime.getMajorRuntimes().stream(), FunctionAppWindowsRuntime.getMajorRuntimes().stream()), Stream.of(FunctionAppDockerRuntime.INSTANCE)).collect(Collectors.toList());
    }

    public static List<FunctionAppRuntime> getAllRuntimes() {
        return Stream.concat(Stream.concat(FunctionAppLinuxRuntime.getAllRuntimes().stream(), FunctionAppWindowsRuntime.getAllRuntimes().stream()), Stream.of(FunctionAppDockerRuntime.INSTANCE)).collect(Collectors.toList());
    }

    public static FunctionAppRuntime fromUserText(String os, String javaVersionUserText) {
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"docker")) {
            return FunctionAppDockerRuntime.INSTANCE;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"windows")) {
            return FunctionAppWindowsRuntime.fromJavaVersionUserText(javaVersionUserText);
        }
        return FunctionAppLinuxRuntime.fromJavaVersionUserText(javaVersionUserText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadingAllRuntimes() {
        Class<FunctionAppRuntime> clazz = FunctionAppRuntime.class;
        synchronized (FunctionAppRuntime.class) {
            Account account = ((AzureAccount)Azure.az(AzureAccount.class)).getAccount();
            if (Objects.nonNull(account) && account.isLoggedIn() && !FunctionAppWindowsRuntime.isLoaded() && !FunctionAppWindowsRuntime.isLoading() && !FunctionAppLinuxRuntime.isLoaded() && !FunctionAppLinuxRuntime.isLoading()) {
                Subscription subscription = (Subscription)account.getSelectedSubscriptions().get(0);
                ((FunctionsServiceSubscription)Objects.requireNonNull(((AzureFunctions)Azure.az(AzureFunctions.class)).get(subscription.getId(), null), "You are not signed-in")).loadRuntimes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

