/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.azurecli;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.implementation.util.ScopeUtil;
import com.google.gson.JsonObject;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManagerWithCache;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.util.AzureCliUtils;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

class AzureCliTokenCredentialManager
extends TokenCredentialManagerWithCache {
    public AzureCliTokenCredentialManager(AzureEnvironment env) {
        this.environment = env;
        this.rootCredentialSupplier = () -> new AzureCliTokenCredential(null);
        this.credentialSupplier = AzureCliTokenCredential::new;
    }

    static class AzureCliTokenCredential
    implements TokenCredential {
        private static final String CLI_GET_ACCESS_TOKEN_CMD = "az account get-access-token --resource %s %s --output json";
        private static final String CLOUD_SHELL_ENV_KEY = "ACC_CLOUD";
        private final String tenantId;

        public Mono<AccessToken> getToken(TokenRequestContext request) {
            String scopes = ScopeUtil.scopesToResource((List)request.getScopes());
            try {
                ScopeUtil.validateScope((String)scopes);
            }
            catch (IllegalArgumentException ex) {
                throw new AzureToolkitAuthenticationException(String.format("Invalid scope: %s", scopes));
            }
            String azCommand = String.format(CLI_GET_ACCESS_TOKEN_CMD, scopes, StringUtils.isBlank((CharSequence)this.tenantId) || this.isInCloudShell() ? "" : " -t " + this.tenantId);
            JsonObject result = (JsonObject)JsonUtils.getGson().fromJson(AzureCliUtils.executeAzureCli(azCommand), JsonObject.class);
            String accessToken = result.get("accessToken").getAsString();
            String time = result.get("expiresOn").getAsString();
            String timeToSecond = time.substring(0, time.indexOf("."));
            String timeJoinedWithT = String.join((CharSequence)"T", timeToSecond.split(" "));
            OffsetDateTime expiresOn = LocalDateTime.parse(timeJoinedWithT, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
            return Mono.just((Object)new AccessToken(accessToken, expiresOn));
        }

        boolean isInCloudShell() {
            return System.getenv(CLOUD_SHELL_ENV_KEY) != null;
        }

        public AzureCliTokenCredential(String tenantId) {
            this.tenantId = tenantId;
        }
    }
}

