/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.utils.CommandUtils;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureCliUtils {
    private static final String MIN_VERSION = "2.11.0";

    public static void ensureMinimumCliVersion() {
        try {
            JsonObject result = (JsonObject)JsonUtils.getGson().fromJson(AzureCliUtils.executeAzureCli("az version --output json"), JsonObject.class);
            String cliVersion = result.get("azure-cli").getAsString();
            if (AzureCliUtils.compareWithMinimVersion(cliVersion) < 0) {
                throw new AzureToolkitAuthenticationException(String.format("your Azure Cli version '%s' is too old, you need to upgrade your CLI with 'az upgrade'.", cliVersion));
            }
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new AzureToolkitAuthenticationException(String.format("Azure Cli is not ready, please make sure your Azure Cli is installed and signed-in, the detailed error is : %s", ex.getMessage()));
        }
    }

    @Nonnull
    public static List<AzureCliSubscription> listSubscriptions() {
        String jsonString = AzureCliUtils.executeAzureCli("az account list --output json");
        JsonArray result = (JsonArray)JsonUtils.getGson().fromJson(jsonString, JsonArray.class);
        ArrayList<AzureCliSubscription> list = new ArrayList<AzureCliSubscription>();
        if (result != null) {
            result.forEach(j -> {
                JsonObject accountObject = j.getAsJsonObject();
                if (!accountObject.has("id")) {
                    return;
                }
                String tenantId = accountObject.get("tenantId").getAsString();
                String subscriptionId = accountObject.get("id").getAsString();
                String subscriptionName = accountObject.get("name").getAsString();
                String state = accountObject.get("state").getAsString();
                String cloud = accountObject.get("cloudName").getAsString();
                String email = accountObject.get("user").getAsJsonObject().get("name").getAsString();
                if (StringUtils.equals((CharSequence)state, (CharSequence)"Enabled") && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{subscriptionId, subscriptionName})) {
                    AzureCliSubscription entity = new AzureCliSubscription();
                    entity.setId(subscriptionId);
                    entity.setName(subscriptionName);
                    entity.setSelected(accountObject.get("isDefault").getAsBoolean());
                    entity.setTenantId(tenantId);
                    entity.setEmail(email);
                    entity.setEnvironment(AzureEnvironmentUtils.stringToAzureEnvironment(cloud));
                    list.add(entity);
                }
            });
            return list;
        }
        throw new AzureToolkitAuthenticationException("list subscriptions by command `az account list` failed, please make sure you have signed in Azure Cli using `az login`");
    }

    @Nonnull
    public static String executeAzureCli(@Nonnull String command) {
        try {
            AzureConfiguration config = Azure.az().config();
            HashMap<String, String> env = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)config.getProxySource())) {
                String proxyAuthPrefix = "";
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getProxyUsername(), config.getProxyPassword()})) {
                    proxyAuthPrefix = config.getProxyUsername() + ":" + config.getProxyPassword() + "@";
                }
                String proxyStr = String.format("http://%s%s:%s", proxyAuthPrefix, config.getHttpProxyHost(), config.getHttpProxyPort());
                env.put("HTTPS_PROXY", proxyStr);
                env.put("HTTP_PROXY", proxyStr);
            }
            return CommandUtils.exec((String)command, env);
        }
        catch (IOException e) {
            throw new AzureToolkitAuthenticationException(String.format("execute Azure Cli command '%s' failed due to error: %s.", command, e.getMessage()));
        }
    }

    private static int compareWithMinimVersion(String version) {
        Semver current = new Semver(version);
        return current.compareTo(new Semver(MIN_VERSION));
    }
}

