/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.serviceprincipal;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.core.serviceprincipal.ServicePrincipalTokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.auth.util.ValidationUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class ServicePrincipalAccount
extends Account {
    private final AuthConfiguration configuration;

    public ServicePrincipalAccount(@Nonnull AuthConfiguration authConfiguration) {
        Objects.requireNonNull(authConfiguration);
        this.configuration = authConfiguration;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.SERVICE_PRINCIPAL;
    }

    @Override
    protected String getClientId() {
        return this.configuration.getClient();
    }

    @Override
    protected Mono<Boolean> preLoginCheck() {
        return Mono.fromCallable(() -> {
            try {
                ValidationUtil.validateAuthConfiguration(this.configuration);
                return true;
            }
            catch (InvalidConfigurationException e) {
                throw new AzureToolkitAuthenticationException("Cannot login through 'SERVICE_PRINCIPAL' due to invalid configuration:" + e.getMessage());
            }
        });
    }

    @Override
    protected Mono<TokenCredentialManager> createTokenCredentialManager() {
        AzureEnvironment env = (AzureEnvironment)ObjectUtils.firstNonNull((Object[])new AzureEnvironment[]{this.configuration.getEnvironment(), ((AzureCloud)Azure.az(AzureCloud.class)).getOrDefault()});
        return Mono.just((Object)new ServicePrincipalTokenCredentialManager(env, this.createCredential(env)));
    }

    private TokenCredential createCredential(AzureEnvironment env) {
        AzureEnvironmentUtils.setupAzureEnvironment(env);
        return StringUtils.isNotBlank((CharSequence)this.configuration.getCertificate()) ? ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(this.configuration.getClient())).pfxCertificate(this.configuration.getCertificate(), this.configuration.getCertificatePassword()).tenantId(this.configuration.getTenant())).build() : ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.configuration.getClient())).clientSecret(this.configuration.getKey()).tenantId(this.configuration.getTenant())).build();
    }
}

