/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.Tenant;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.SubscriptionProvider;
import com.microsoft.azure.toolkit.lib.auth.TenantProvider;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class TokenCredentialManager
implements TenantProvider,
SubscriptionProvider {
    private static final ClientLogger LOGGER = new ClientLogger(TokenCredentialManager.class);
    protected AzureEnvironment environment;
    protected String email;
    protected Supplier<TokenCredential> rootCredentialSupplier;
    protected Function<String, TokenCredential> credentialSupplier;

    public TokenCredential createTokenCredentialForTenant(String tenantId) {
        return this.credentialSupplier.apply(tenantId);
    }

    @Override
    public Mono<List<String>> listTenants() {
        return this.createAzureClient(this.environment).tenants().listAsync().map(Tenant::tenantId).collectList();
    }

    @Override
    public Mono<List<Subscription>> listSubscriptions(List<String> tenantIds) {
        return Flux.fromIterable(tenantIds).parallel().runOn(Schedulers.boundedElastic()).flatMap(tenant -> TokenCredentialManager.listSubscriptionsInTenant(this.createAzureClient(this.environment, (String)tenant), tenant)).sequential().collectList().map(subscriptionsSet -> subscriptionsSet.stream().flatMap(Collection::stream).filter(Utils.distinctByKey(subscription -> StringUtils.lowerCase((String)subscription.getId()))).collect(Collectors.toList()));
    }

    private static Mono<List<Subscription>> listSubscriptionsInTenant(ResourceManager.Authenticated client, String tenantId) {
        return client.subscriptions().listAsync().map(s -> TokenCredentialManager.toSubscriptionEntity(tenantId, s)).collectList().onErrorResume(ex -> {
            LOGGER.warning(String.format("Cannot get subscriptions for tenant %s , please verify you have proper permissions over this tenant, detailed error: %s", tenantId, ex.getMessage()));
            return Mono.just(new ArrayList());
        });
    }

    private static Subscription toSubscriptionEntity(String tenantId, com.azure.resourcemanager.resources.models.Subscription subscription) {
        Subscription subscriptionEntity = new Subscription();
        subscriptionEntity.setId(subscription.subscriptionId());
        subscriptionEntity.setName(subscription.displayName());
        subscriptionEntity.setTenantId(tenantId);
        return subscriptionEntity;
    }

    private ResourceManager.Authenticated createAzureClient(AzureEnvironment env, String tenantId) {
        AzureProfile profile = new AzureProfile(env);
        return TokenCredentialManager.configureAzure().authenticate(this.createTokenCredentialForTenant(tenantId), profile);
    }

    private ResourceManager.Authenticated createAzureClient(AzureEnvironment env) {
        AzureProfile profile = new AzureProfile(env);
        return TokenCredentialManager.configureAzure().authenticate(this.rootCredentialSupplier.get(), profile);
    }

    private static ResourceManager.Configurable configureAzure() {
        return (ResourceManager.Configurable)((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzResourceManager.getDefaultHttpClient())).withPolicy(TokenCredentialManager.createUserAgentPolicy())).withRetryPolicy(new RetryPolicy((RetryStrategy)new FixedDelay(0, Duration.ofSeconds(0L))));
    }

    private static HttpPipelinePolicy createUserAgentPolicy() {
        String userAgent = Azure.az().config().getUserAgent();
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    public void setEnvironment(AzureEnvironment environment) {
        this.environment = environment;
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setRootCredentialSupplier(Supplier<TokenCredential> rootCredentialSupplier) {
        this.rootCredentialSupplier = rootCredentialSupplier;
    }

    public void setCredentialSupplier(Function<String, TokenCredential> credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }
}

